/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.quarkus.client.it;

import io.smallrye.mutiny.Uni;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.redisson.api.RBucketReactive;
import org.redisson.api.RExecutorFuture;
import org.redisson.api.RMap;
import org.redisson.api.RRemoteService;
import org.redisson.api.RScheduledExecutorService;
import org.redisson.api.RedissonClient;
import org.redisson.api.WorkerOptions;
import org.redisson.api.redisnode.RedisNodes;
import org.redisson.api.redisnode.RedisSingle;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.StringCodec;
import org.redisson.quarkus.client.it.RemService;
import org.redisson.quarkus.client.it.RemoteServiceImpl;
import org.redisson.quarkus.client.it.Task;

@Path(value="/quarkus-redisson-client")
public class QuarkusRedissonClientResource {
    @Inject
    RedissonClient redisson;

    @GET
    @Path(value="/map")
    public String map() {
        RMap m = this.redisson.getMap("test");
        m.put((Object)"1", (Object)2);
        return ((Integer)m.get((Object)"1")).toString();
    }

    @GET
    @Path(value="/remoteService")
    public String remoteService() {
        RRemoteService t = this.redisson.getRemoteService("test");
        t.register(RemService.class, (Object)new RemoteServiceImpl());
        RemService rs = (RemService)t.get(RemService.class);
        return rs.executeMe();
    }

    @GET
    @Path(value="/pingAll")
    public String pingAll() {
        ((RedisSingle)this.redisson.getRedisNodes(RedisNodes.SINGLE)).pingAll();
        return "OK";
    }

    @GET
    @Path(value="/executeTask")
    public String executeTask() throws ExecutionException, InterruptedException {
        RScheduledExecutorService t = this.redisson.getExecutorService("test");
        t.registerWorkers(WorkerOptions.defaults());
        RExecutorFuture r = t.submit((Callable)new Task());
        return (String)r.get();
    }

    @GET
    @Path(value="/bucket")
    public Uni<String> getBucket() {
        RBucketReactive bucket = this.redisson.reactive().getBucket("test-bucket", (Codec)new StringCodec());
        return Uni.createFrom().future((Future)bucket.set((Object)"world").toFuture()).flatMap(unused -> Uni.createFrom().future((Future)bucket.get().toFuture()));
    }

    @GET
    @Path(value="/delBucket")
    public Uni<Boolean> deleteBucket() {
        RBucketReactive bucket = this.redisson.reactive().getBucket("test-bucket", (Codec)new StringCodec());
        return Uni.createFrom().future((Future)bucket.set((Object)"world").toFuture()).flatMap(unused -> Uni.createFrom().future((Future)bucket.delete().toFuture()));
    }
}

