/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cache.redisson.runtime;

import io.quarkus.cache.CacheManager;
import io.quarkus.cache.CacheManagerInfo;
import io.quarkus.cache.redisson.runtime.RedissonCacheImpl;
import io.quarkus.cache.redisson.runtime.RedissonCacheInfo;
import io.quarkus.cache.redisson.runtime.RedissonCacheInfoBuilder;
import io.quarkus.cache.redisson.runtime.RedissonCachesConfig;
import io.quarkus.cache.runtime.CacheManagerImpl;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import java.util.function.Supplier;
import org.jboss.logging.Logger;

@Recorder
public class RedissonCacheBuildRecorder {
    private static final Logger LOGGER = Logger.getLogger(RedissonCacheBuildRecorder.class);
    private final RuntimeValue<RedissonCachesConfig> redisCacheConfigRV;

    public RedissonCacheBuildRecorder(RuntimeValue<RedissonCachesConfig> redisCacheConfigRV) {
        this.redisCacheConfigRV = redisCacheConfigRV;
    }

    public CacheManagerInfo getCacheManagerSupplier() {
        return new CacheManagerInfo(){

            public boolean supports(CacheManagerInfo.Context context) {
                return context.cacheEnabled() && "redisson".equals(context.cacheType());
            }

            public Supplier<CacheManager> get(final CacheManagerInfo.Context context) {
                return new Supplier<CacheManager>(){

                    @Override
                    public CacheManager get() {
                        Set<RedissonCacheInfo> cacheInfos = RedissonCacheInfoBuilder.build(context.cacheNames(), (RedissonCachesConfig)RedissonCacheBuildRecorder.this.redisCacheConfigRV.getValue());
                        if (cacheInfos.isEmpty()) {
                            return new CacheManagerImpl(Collections.emptyMap());
                        }
                        HashMap<String, RedissonCacheImpl> caches = new HashMap<String, RedissonCacheImpl>(cacheInfos.size() + 1, 1.0f);
                        for (RedissonCacheInfo cacheInfo : cacheInfos) {
                            if (LOGGER.isDebugEnabled()) {
                                LOGGER.debugf("Building Redis cache [%s] with [expireAfterAccess=%s], [expireAfterWrite=%s], [maxSize=%s]", new Object[]{cacheInfo.name, cacheInfo.expireAfterAccess, cacheInfo.expireAfterWrite, cacheInfo.maxSize});
                            }
                            RedissonCacheImpl cache = new RedissonCacheImpl(cacheInfo);
                            caches.put(cacheInfo.name, cache);
                        }
                        return new CacheManagerImpl(caches);
                    }
                };
            }
        };
    }
}

