/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cache.redisson.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.cache.redisson.runtime.CacheImplementation;
import io.quarkus.cache.redisson.runtime.RedissonCache;
import io.quarkus.cache.redisson.runtime.RedissonCacheInfo;
import io.quarkus.cache.runtime.AbstractCache;
import io.smallrye.mutiny.Uni;
import java.lang.annotation.Annotation;
import java.time.Duration;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.redisson.RedissonObject;
import org.redisson.api.RMap;
import org.redisson.api.RMapCache;
import org.redisson.api.RMapCacheNative;
import org.redisson.api.RedissonClient;

public class RedissonCacheImpl
extends AbstractCache
implements RedissonCache {
    private RedissonCacheInfo cacheInfo;
    private RMap map;
    private RMapCache mapCache;
    private RMapCacheNative mapCacheNative;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RedissonCacheImpl(RedissonCacheInfo cacheInfo) {
        RedissonClient redisson = (RedissonClient)Arc.container().select(RedissonClient.class, new Annotation[0]).get();
        CacheImplementation impl = cacheInfo.implementation.orElse(CacheImplementation.STANDARD);
        this.cacheInfo = cacheInfo;
        if (cacheInfo.expireAfterAccess.isPresent() || cacheInfo.expireAfterWrite.isPresent()) {
            if (impl == CacheImplementation.STANDARD) {
                this.mapCache = redisson.getMapCache(cacheInfo.name);
                this.map = this.mapCache;
                return;
            } else {
                if (impl != CacheImplementation.NATIVE) throw new IllegalArgumentException(String.valueOf((Object)impl) + " implementation is available only in PRO version. Please contact sales@redisson.pro");
                if (cacheInfo.expireAfterAccess.isPresent()) {
                    throw new IllegalArgumentException("expireAfterAccess isn't supported by NATIVE implementation");
                }
                this.mapCacheNative = redisson.getMapCacheNative(cacheInfo.name);
                this.map = this.mapCacheNative;
            }
            return;
        } else if (impl == CacheImplementation.STANDARD) {
            this.map = redisson.getMap(cacheInfo.name);
            return;
        } else {
            if (impl != CacheImplementation.NATIVE) throw new IllegalArgumentException(String.valueOf((Object)impl) + " implementation is available only in PRO version. Please contact sales@redisson.pro");
            this.map = redisson.getMapCacheNative(cacheInfo.name);
        }
    }

    @Override
    public <K, V> Uni<V> put(final K key, final V value) {
        Objects.requireNonNull(key, "Null keys are not supported by the Quarkus application data cache");
        return Uni.createFrom().completionStage(new Supplier<CompletionStage<V>>(){

            @Override
            public CompletionStage<V> get() {
                long ttl = RedissonCacheImpl.this.cacheInfo.expireAfterWrite.orElse(Duration.ZERO).toMillis();
                long maxIdleTime = RedissonCacheImpl.this.cacheInfo.expireAfterAccess.orElse(Duration.ZERO).toMillis();
                if (maxIdleTime > 0L || ttl > 0L) {
                    if (RedissonCacheImpl.this.mapCacheNative != null) {
                        return RedissonCacheImpl.this.mapCacheNative.putAsync(key, value, Duration.ofMillis(ttl));
                    }
                    return RedissonCacheImpl.this.mapCache.putAsync(key, value, ttl, TimeUnit.MILLISECONDS, maxIdleTime, TimeUnit.MILLISECONDS);
                }
                return RedissonCacheImpl.this.map.putAsync(key, value);
            }
        });
    }

    @Override
    public <K, V> Uni<Boolean> fastPut(final K key, final V value) {
        Objects.requireNonNull(key, "Null keys are not supported by the Quarkus application data cache");
        return Uni.createFrom().completionStage((Supplier)new Supplier<CompletionStage<Boolean>>(){

            @Override
            public CompletionStage<Boolean> get() {
                long ttl = RedissonCacheImpl.this.cacheInfo.expireAfterWrite.orElse(Duration.ZERO).toMillis();
                long maxIdleTime = RedissonCacheImpl.this.cacheInfo.expireAfterAccess.orElse(Duration.ZERO).toMillis();
                if (maxIdleTime > 0L || ttl > 0L) {
                    if (RedissonCacheImpl.this.mapCacheNative != null) {
                        return RedissonCacheImpl.this.mapCacheNative.fastPutAsync(key, value, Duration.ofMillis(ttl));
                    }
                    return RedissonCacheImpl.this.mapCache.fastPutAsync(key, value, ttl, TimeUnit.MILLISECONDS, maxIdleTime, TimeUnit.MILLISECONDS);
                }
                return RedissonCacheImpl.this.map.fastPutAsync(key, value);
            }
        });
    }

    @Override
    public <K, V> Uni<V> putIfAbsent(final K key, final V value) {
        Objects.requireNonNull(key, "Null keys are not supported by the Quarkus application data cache");
        return Uni.createFrom().completionStage(new Supplier<CompletionStage<V>>(){

            @Override
            public CompletionStage<V> get() {
                long ttl = RedissonCacheImpl.this.cacheInfo.expireAfterWrite.orElse(Duration.ZERO).toMillis();
                long maxIdleTime = RedissonCacheImpl.this.cacheInfo.expireAfterAccess.orElse(Duration.ZERO).toMillis();
                if (maxIdleTime > 0L || ttl > 0L) {
                    if (RedissonCacheImpl.this.mapCacheNative != null) {
                        return RedissonCacheImpl.this.mapCacheNative.putIfAbsentAsync(key, value, Duration.ofMillis(ttl));
                    }
                    return RedissonCacheImpl.this.mapCache.putIfAbsentAsync(key, value, ttl, TimeUnit.MILLISECONDS, maxIdleTime, TimeUnit.MILLISECONDS);
                }
                return RedissonCacheImpl.this.map.putIfAbsentAsync(key, value);
            }
        });
    }

    @Override
    public <K, V> Uni<V> putIfExists(final K key, final V value) {
        Objects.requireNonNull(key, "Null keys are not supported by the Quarkus application data cache");
        return Uni.createFrom().completionStage(new Supplier<CompletionStage<V>>(){

            @Override
            public CompletionStage<V> get() {
                return RedissonCacheImpl.this.map.putIfExistsAsync(key, value);
            }
        });
    }

    @Override
    public <K, V> Uni<Boolean> fastPutIfAbsent(final K key, final V value) {
        Objects.requireNonNull(key, "Null keys are not supported by the Quarkus application data cache");
        return Uni.createFrom().completionStage((Supplier)new Supplier<CompletionStage<Boolean>>(){

            @Override
            public CompletionStage<Boolean> get() {
                long ttl = RedissonCacheImpl.this.cacheInfo.expireAfterWrite.orElse(Duration.ZERO).toMillis();
                long maxIdleTime = RedissonCacheImpl.this.cacheInfo.expireAfterAccess.orElse(Duration.ZERO).toMillis();
                if (maxIdleTime > 0L || ttl > 0L) {
                    if (RedissonCacheImpl.this.mapCacheNative != null) {
                        return RedissonCacheImpl.this.mapCacheNative.fastPutIfAbsentAsync(key, value, Duration.ofMillis(ttl));
                    }
                    return RedissonCacheImpl.this.mapCache.fastPutIfAbsentAsync(key, value, ttl, TimeUnit.MILLISECONDS, maxIdleTime, TimeUnit.MILLISECONDS);
                }
                return RedissonCacheImpl.this.map.fastPutIfAbsentAsync(key, value);
            }
        });
    }

    @Override
    public <K, V> Uni<Boolean> fastPutIfExists(final K key, final V value) {
        Objects.requireNonNull(key, "Null keys are not supported by the Quarkus application data cache");
        return Uni.createFrom().completionStage((Supplier)new Supplier<CompletionStage<Boolean>>(){

            @Override
            public CompletionStage<Boolean> get() {
                return RedissonCacheImpl.this.map.fastPutIfExistsAsync(key, value);
            }
        });
    }

    @Override
    public <K, V> Uni<V> getOrDefault(final K key, V defaultValue) {
        Objects.requireNonNull(key, "Null keys are not supported by the Quarkus application data cache");
        return Uni.createFrom().completionStage(new Supplier<CompletionStage<V>>(){

            @Override
            public CompletionStage<V> get() {
                return RedissonCacheImpl.this.map.getAsync(key);
            }
        }).onItem().ifNull().continueWith(() -> defaultValue);
    }

    public String getName() {
        return this.map.getName();
    }

    public <K, V> Uni<V> get(final K key, final Function<K, V> valueLoader) {
        Objects.requireNonNull(key, "Null keys are not supported by the Quarkus application data cache");
        return Uni.createFrom().completionStage(new Supplier<CompletionStage<V>>(){

            @Override
            public CompletionStage<V> get() {
                return RedissonCacheImpl.this.map.computeIfAbsentAsync(key, valueLoader);
            }
        });
    }

    public <K, V> Uni<V> getAsync(final K key, final Function<K, Uni<V>> valueLoader) {
        Objects.requireNonNull(key, "Null keys are not supported by the Quarkus application data cache");
        return Uni.createFrom().completionStage(new Supplier<CompletionStage<V>>(){

            @Override
            public CompletionStage<V> get() {
                return RedissonCacheImpl.this.map.computeIfAbsentAsync(key, new Function<K, V>(){

                    @Override
                    public V apply(K o) {
                        return ((Uni)valueLoader.apply(o)).await().indefinitely();
                    }
                });
            }
        });
    }

    public Uni<Void> invalidate(final Object key) {
        Objects.requireNonNull(key, "Null keys are not supported by the Quarkus application data cache");
        return Uni.createFrom().completionStage((Supplier)new Supplier<CompletionStage<Void>>(){

            @Override
            public CompletionStage<Void> get() {
                return RedissonCacheImpl.this.map.removeAsync(key).thenApply(r -> null);
            }
        });
    }

    public Uni<Void> invalidateAll() {
        return Uni.createFrom().completionStage((Supplier)new Supplier<CompletionStage<Void>>(){

            @Override
            public CompletionStage<Void> get() {
                return RedissonCacheImpl.this.map.deleteAsync().thenApply(r -> null);
            }
        });
    }

    public Uni<Void> invalidateIf(final Predicate<Object> predicate) {
        return Uni.createFrom().completionStage((Supplier)new Supplier<CompletionStage<Void>>(){

            @Override
            public CompletionStage<Void> get() {
                ExecutorService executor = ((RedissonObject)RedissonCacheImpl.this.map).getServiceManager().getExecutor();
                return RedissonCacheImpl.this.map.readAllKeySetAsync().thenComposeAsync(keys -> {
                    Object[] deleted = ((Set)keys).stream().filter(k -> predicate.test(k)).toArray();
                    return RedissonCacheImpl.this.map.fastRemoveAsync(deleted);
                }, (Executor)executor);
            }
        });
    }
}

