/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redisson.client.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.HotDeploymentWatchedFileBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeInitializedClassBuildItem;
import io.quarkus.redisson.client.deployment.RedissonClientItemBuild;
import io.quarkus.redisson.client.runtime.RedissonClientProducer;
import io.quarkus.redisson.client.runtime.RedissonClientRecorder;
import io.quarkus.runtime.Quarkus;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.eclipse.microprofile.config.ConfigProvider;
import org.redisson.config.PropertiesConvertor;

class QuarkusRedissonClientProcessor {
    private static final String FEATURE = "redisson";

    QuarkusRedissonClientProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    ExtensionSslNativeSupportBuildItem sslNativeSupport() {
        return new ExtensionSslNativeSupportBuildItem(FEATURE);
    }

    @BuildStep
    AdditionalBeanBuildItem addProducer() {
        return AdditionalBeanBuildItem.unremovableOf(RedissonClientProducer.class);
    }

    @BuildStep
    void addConfig(BuildProducer<NativeImageResourceBuildItem> nativeResources, BuildProducer<HotDeploymentWatchedFileBuildItem> watchedFiles, BuildProducer<RuntimeInitializedClassBuildItem> staticItems, BuildProducer<ReflectiveClassBuildItem> reflectiveItems) {
        nativeResources.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"redisson.yaml"}));
        nativeResources.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"META-INF/services/org.jboss.marshalling.ProviderDescriptor"}));
        watchedFiles.produce((BuildItem)new HotDeploymentWatchedFileBuildItem("redisson.yaml"));
        if (Quarkus.class.getPackage().getImplementationVersion().startsWith("1.")) {
            staticItems.produce((BuildItem)new RuntimeInitializedClassBuildItem("io.quarkus.redisson.client.runtime.graal.NetUtilSubstitutions$NetUtilLocalhost4LazyHolder"));
            staticItems.produce((BuildItem)new RuntimeInitializedClassBuildItem("io.quarkus.redisson.client.runtime.graal.NetUtilSubstitutions$NetUtilLocalhost6LazyHolder"));
            staticItems.produce((BuildItem)new RuntimeInitializedClassBuildItem("io.quarkus.redisson.client.runtime.graal.NetUtilSubstitutions$NetUtilLocalhostLazyHolder"));
        }
        staticItems.produce((BuildItem)new RuntimeInitializedClassBuildItem("io.netty.resolver.HostsFileEntriesResolver"));
        staticItems.produce((BuildItem)new RuntimeInitializedClassBuildItem("io.netty.resolver.dns.DnsNameResolver"));
        staticItems.produce((BuildItem)new RuntimeInitializedClassBuildItem("io.netty.resolver.dns.DefaultDnsServerAddressStreamProvider"));
        staticItems.produce((BuildItem)new RuntimeInitializedClassBuildItem("io.netty.resolver.dns.DnsServerAddressStreamProviders$DefaultProviderHolder"));
        reflectiveItems.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{"org.redisson.codec.MarshallingCodec"}));
        reflectiveItems.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{"org.jboss.marshalling.river.RiverProviderDescriptor"}));
        reflectiveItems.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new String[]{"org.redisson.executor.RemoteExecutorService"}));
        reflectiveItems.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new String[]{"org.redisson.executor.RemoteExecutorServiceAsync"}));
        reflectiveItems.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.redisson.config.Config"}));
        reflectiveItems.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.redisson.config.BaseConfig"}));
        reflectiveItems.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.redisson.config.BaseMasterSlaveServersConfig"}));
        reflectiveItems.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.redisson.config.SingleServerConfig"}));
        reflectiveItems.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.redisson.config.ReplicatedServersConfig"}));
        reflectiveItems.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.redisson.config.SentinelServersConfig"}));
        reflectiveItems.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.redisson.config.ClusterServersConfig"}));
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    RedissonClientItemBuild build(RedissonClientRecorder recorder) throws IOException {
        InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream("redisson.yaml");
        if (stream != null) {
            byte[] array = new byte[stream.available()];
            stream.read(array);
            recorder.configureRedisson(new String(array, StandardCharsets.UTF_8));
        } else {
            String yaml = PropertiesConvertor.toYaml((String)"quarkus.redisson.", (Iterable)ConfigProvider.getConfig().getPropertyNames(), prop -> (String)ConfigProvider.getConfig().getValue(prop, String.class));
            recorder.configureRedisson(yaml);
        }
        return new RedissonClientItemBuild();
    }
}

