/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redisson.client.runtime;

import io.quarkus.arc.DefaultBean;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Singleton;
import org.eclipse.microprofile.config.ConfigProvider;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;
import org.redisson.config.PropertiesConvertor;

@ApplicationScoped
public class RedissonClientProducer {
    private RedissonClient redisson;

    @Produces
    @Singleton
    @DefaultBean
    public RedissonClient create() throws IOException {
        String config;
        Optional configFile = ConfigProvider.getConfig().getOptionalValue("quarkus.redisson.file", String.class);
        InputStream configStream = configFile.isPresent() ? this.getClass().getResourceAsStream((String)configFile.get()) : Thread.currentThread().getContextClassLoader().getResourceAsStream("redisson.yaml");
        if (configStream != null) {
            byte[] array = new byte[configStream.available()];
            configStream.read(array);
            config = new String(array, StandardCharsets.UTF_8);
        } else {
            String yaml;
            config = yaml = PropertiesConvertor.toYaml((String)"quarkus.redisson.", (Iterable)ConfigProvider.getConfig().getPropertyNames(), prop -> (String)ConfigProvider.getConfig().getValue(prop, String.class));
        }
        Config c = Config.fromYAML((String)config);
        this.redisson = Redisson.create((Config)c);
        return this.redisson;
    }

    public void setConfig(org.eclipse.microprofile.config.Config config) {
    }

    @PreDestroy
    public void close() {
        if (this.redisson != null) {
            this.redisson.shutdown();
        }
    }
}

