/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redisson.client.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.HotDeploymentWatchedFileBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeInitializedClassBuildItem;
import io.quarkus.redisson.client.deployment.RedissonClientItemBuild;
import io.quarkus.redisson.client.runtime.RedissonClientProducer;
import io.quarkus.redisson.client.runtime.RedissonClientRecorder;
import java.io.IOException;

class QuarkusRedissonClientProcessor {
    private static final String FEATURE = "redisson";

    QuarkusRedissonClientProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    ExtensionSslNativeSupportBuildItem sslNativeSupport() {
        return new ExtensionSslNativeSupportBuildItem(FEATURE);
    }

    @BuildStep
    AdditionalBeanBuildItem addProducer() {
        return AdditionalBeanBuildItem.unremovableOf(RedissonClientProducer.class);
    }

    @BuildStep
    void addConfig(BuildProducer<NativeImageResourceBuildItem> nativeResources, BuildProducer<HotDeploymentWatchedFileBuildItem> watchedFiles, BuildProducer<RuntimeInitializedClassBuildItem> staticItems, BuildProducer<ReflectiveClassBuildItem> reflectiveItems) {
        nativeResources.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"redisson.yaml"}));
        nativeResources.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"META-INF/services/org.jboss.marshalling.ProviderDescriptor"}));
        watchedFiles.produce((BuildItem)new HotDeploymentWatchedFileBuildItem("redisson.yaml"));
        reflectiveItems.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{"org.redisson.codec.MarshallingCodec"}));
        reflectiveItems.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{"org.jboss.marshalling.river.RiverProviderDescriptor"}));
        reflectiveItems.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new String[]{"org.redisson.executor.RemoteExecutorService"}));
        reflectiveItems.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new String[]{"org.redisson.executor.RemoteExecutorServiceAsync"}));
        reflectiveItems.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.redisson.config.Config"}));
        reflectiveItems.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.redisson.config.BaseConfig"}));
        reflectiveItems.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.redisson.config.BaseMasterSlaveServersConfig"}));
        reflectiveItems.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.redisson.config.SingleServerConfig"}));
        reflectiveItems.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.redisson.config.ReplicatedServersConfig"}));
        reflectiveItems.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.redisson.config.SentinelServersConfig"}));
        reflectiveItems.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.redisson.config.ClusterServersConfig"}));
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    RedissonClientItemBuild build(RedissonClientRecorder recorder) throws IOException {
        recorder.createProducer();
        return new RedissonClientItemBuild();
    }
}

