/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.micronaut.session;

import io.micronaut.context.annotation.Primary;
import io.micronaut.context.annotation.Replaces;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.event.ApplicationEventPublisher;
import io.micronaut.session.InMemorySessionStore;
import io.micronaut.session.Session;
import io.micronaut.session.SessionIdGenerator;
import io.micronaut.session.SessionStore;
import io.micronaut.session.event.SessionCreatedEvent;
import io.micronaut.session.event.SessionDeletedEvent;
import io.micronaut.session.event.SessionExpiredEvent;
import jakarta.inject.Singleton;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.redisson.Redisson;
import org.redisson.api.RBatch;
import org.redisson.api.RBucket;
import org.redisson.api.RMap;
import org.redisson.api.RPatternTopic;
import org.redisson.api.RTopic;
import org.redisson.api.RedissonClient;
import org.redisson.api.listener.MessageListener;
import org.redisson.api.listener.PatternMessageListener;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.IntegerCodec;
import org.redisson.client.codec.StringCodec;
import org.redisson.codec.CompositeCodec;
import org.redisson.micronaut.session.AttributeMessage;
import org.redisson.micronaut.session.AttributeRemoveMessage;
import org.redisson.micronaut.session.AttributeUpdateMessage;
import org.redisson.micronaut.session.AttributesClearMessage;
import org.redisson.micronaut.session.AttributesPutAllMessage;
import org.redisson.micronaut.session.RedissonHttpSessionConfiguration;
import org.redisson.micronaut.session.RedissonSession;
import org.redisson.pubsub.PublishSubscribeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Primary
@Requires(property="micronaut.session.http.redisson.enabled", value="true")
@Replaces(value=InMemorySessionStore.class)
public class RedissonSessionStore
implements SessionStore<RedissonSession>,
PatternMessageListener<String>,
MessageListener<String> {
    public static final String ENABLED = "micronaut.session.http.redisson.enabled";
    private static final String SESSION_PREFIX = "redisson:session:";
    private MessageListener<AttributeMessage> messageListener;
    private final String nodeId = UUID.randomUUID().toString();
    private static final Logger LOG = LoggerFactory.getLogger(RedissonSessionStore.class);
    private RPatternTopic deletedTopic;
    private RPatternTopic expiredTopic;
    private RTopic createdTopic;
    private RedissonClient redisson;
    private final SessionIdGenerator sessionIdGenerator;
    private RedissonHttpSessionConfiguration sessionConfiguration;
    private final ApplicationEventPublisher eventPublisher;

    public RedissonSessionStore(RedissonClient redisson, SessionIdGenerator sessionIdGenerator, RedissonHttpSessionConfiguration sessionConfiguration, ApplicationEventPublisher eventPublisher) {
        this.sessionIdGenerator = sessionIdGenerator;
        this.sessionConfiguration = sessionConfiguration;
        this.eventPublisher = eventPublisher;
        this.redisson = redisson;
        this.deletedTopic = redisson.getPatternTopic("__keyevent@*:del", (Codec)StringCodec.INSTANCE);
        this.expiredTopic = redisson.getPatternTopic("__keyevent@*:expired", (Codec)StringCodec.INSTANCE);
        this.createdTopic = this.getTopic(this.getEventsChannelPrefix(), (Codec)StringCodec.INSTANCE);
        this.deletedTopic.addListener(String.class, (PatternMessageListener)this);
        this.expiredTopic.addListener(String.class, (PatternMessageListener)this);
        this.createdTopic.addListener(String.class, (MessageListener)this);
        if (sessionConfiguration.isBroadcastSessionUpdates()) {
            RTopic updatesTopic = this.getTopic();
            this.messageListener = new MessageListener<AttributeMessage>(){

                public void onMessage(CharSequence channel, AttributeMessage msg) {
                    if (msg.getNodeId().equals(RedissonSessionStore.this.nodeId)) {
                        return;
                    }
                    RedissonSessionStore.this.findSession(msg.getSessionId()).thenAccept(s -> {
                        if (s.isPresent()) {
                            return;
                        }
                        try {
                            AttributeMessage m;
                            RedissonSession session = (RedissonSession)((Object)((Object)s.get()));
                            if (msg instanceof AttributeRemoveMessage) {
                                for (CharSequence name : ((AttributeRemoveMessage)msg).getNames()) {
                                    session.superRemove(name);
                                }
                            }
                            if (msg instanceof AttributesClearMessage) {
                                RedissonSessionStore.this.deleteSession(session.getId());
                            }
                            if (msg instanceof AttributesPutAllMessage) {
                                m = (AttributesPutAllMessage)msg;
                                Map<CharSequence, Object> attrs = ((AttributesPutAllMessage)m).getAttrs(RedissonSessionStore.this.getCodec().getMapValueDecoder());
                                session.load(attrs);
                            }
                            if (msg instanceof AttributeUpdateMessage) {
                                m = (AttributeUpdateMessage)msg;
                                session.superPut(((AttributeUpdateMessage)m).getName(), ((AttributeUpdateMessage)m).getValue(RedissonSessionStore.this.getCodec().getMapValueDecoder()));
                            }
                        }
                        catch (Exception e) {
                            LOG.error("Unable to handle topic message", (Throwable)e);
                        }
                    });
                }
            };
            updatesTopic.addListener(AttributeMessage.class, this.messageListener);
        }
    }

    String getEventsChannelPrefix() {
        return this.sessionConfiguration.getKeyPrefix() + "sessions:created:";
    }

    String getExpiredKeyPrefix() {
        return this.sessionConfiguration.getKeyPrefix() + "sessions:expires:";
    }

    public RedissonSession newSession() {
        return new RedissonSession(this, this.sessionIdGenerator.generateId(), this.sessionConfiguration.getUpdateMode(), this.sessionConfiguration.getMaxInactiveInterval());
    }

    public CompletableFuture<Optional<RedissonSession>> findSession(String id) {
        return this.loadSession(id, false);
    }

    public CompletableFuture<Boolean> deleteSession(String id) {
        return ((CompletableFuture)this.loadSession(id, false).thenCompose(optional -> optional.map(s -> s.delete().thenApply(r -> true)).orElse(CompletableFuture.completedFuture(false)))).toCompletableFuture();
    }

    public CompletableFuture<RedissonSession> save(RedissonSession session) {
        CompletableFuture<RedissonSession> f = session.save();
        return f.thenCompose(v -> {
            if (session.isNew()) {
                return this.createdTopic.publishAsync((Object)v.getId()).thenApply(val -> v);
            }
            return CompletableFuture.completedFuture(session);
        });
    }

    public void onMessage(CharSequence pattern, CharSequence channel, String body) {
        if (this.deletedTopic.getPatternNames().contains(pattern.toString())) {
            if (!body.contains("redisson:session:notification:")) {
                return;
            }
            String id = body.split("redisson:session:notification:")[1];
            this.loadSession(id, true).whenComplete((r, e) -> r.ifPresent(v -> this.eventPublisher.publishEvent((Object)new SessionDeletedEvent((Session)v))));
        } else if (this.expiredTopic.getPatternNames().contains(pattern.toString())) {
            if (!body.contains("redisson:session:notification:")) {
                return;
            }
            String id = body.split("redisson:session:notification:")[1];
            this.loadSession(id, true).whenComplete((r, e) -> r.ifPresent(v -> this.eventPublisher.publishEvent((Object)new SessionExpiredEvent((Session)v))));
        }
    }

    private CompletableFuture<Optional<RedissonSession>> loadSession(String id, boolean useExpired) {
        RMap<CharSequence, Object> map = this.getMap(id);
        return map.readAllMapAsync().thenApply(data -> {
            if (data.isEmpty()) {
                return Optional.empty();
            }
            RedissonSession session = new RedissonSession(this, id, this.sessionConfiguration.getUpdateMode());
            session.load((Map<CharSequence, Object>)data);
            if (useExpired || !session.isExpired()) {
                return Optional.of(session);
            }
            return Optional.empty();
        }).toCompletableFuture();
    }

    public void onMessage(CharSequence channel, String id) {
        this.loadSession(id, true).whenComplete((r, e) -> r.ifPresent(v -> this.eventPublisher.publishEvent((Object)new SessionCreatedEvent((Session)v))));
    }

    public RTopic getTopic() {
        String keyPrefix = this.sessionConfiguration.getKeyPrefix();
        String separator = keyPrefix == null || keyPrefix.isEmpty() ? "" : ":";
        String name = keyPrefix + separator + "redisson:session_updates";
        return this.getTopic(name, this.getCodec());
    }

    private RTopic getTopic(String name, Codec codec) {
        PublishSubscribeService ss = ((Redisson)this.redisson).getConnectionManager().getSubscribeService();
        if (ss.isShardingSupported()) {
            return this.redisson.getShardedTopic(name, codec);
        }
        return this.redisson.getTopic(name, codec);
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public RBatch createBatch() {
        return this.redisson.createBatch();
    }

    private Codec getCodec() {
        return Optional.ofNullable(this.sessionConfiguration.getCodec()).orElse(this.redisson.getConfig().getCodec());
    }

    public RMap<CharSequence, Object> getMap(String sessionId) {
        String keyPrefix = this.sessionConfiguration.getKeyPrefix();
        String separator = keyPrefix == null || keyPrefix.isEmpty() ? "" : ":";
        String name = keyPrefix + separator + SESSION_PREFIX + sessionId;
        return this.redisson.getMap(name, (Codec)new CompositeCodec((Codec)StringCodec.INSTANCE, this.getCodec(), this.getCodec()));
    }

    public RBucket<Integer> getNotificationBucket(String sessionId) {
        String keyPrefix = this.sessionConfiguration.getKeyPrefix();
        String separator = keyPrefix == null || keyPrefix.isEmpty() ? "" : ":";
        String name = keyPrefix + separator + SESSION_PREFIX + "notification:" + sessionId;
        return this.redisson.getBucket(name, (Codec)IntegerCodec.INSTANCE);
    }
}

