/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.micronaut.cache;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.naming.Named;
import java.time.Duration;
import org.redisson.api.MapOptions;
import org.redisson.api.map.MapLoader;
import org.redisson.api.map.MapWriter;
import org.redisson.client.codec.Codec;

public class BaseCacheConfiguration
implements Named {
    MapOptions<Object, Object> mapOptions = MapOptions.defaults();
    private final String name;
    private Codec codec;
    private Duration expireAfterWrite;
    private Duration expireAfterAccess;
    private int maxSize;

    public BaseCacheConfiguration(String name) {
        this.name = name;
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    public Codec getCodec() {
        return this.codec;
    }

    public void setCodec(Codec codec) {
        this.codec = codec;
    }

    public Duration getExpireAfterWrite() {
        return this.expireAfterWrite;
    }

    public void setExpireAfterWrite(Duration expireAfterWrite) {
        this.expireAfterWrite = expireAfterWrite;
    }

    public Duration getExpireAfterAccess() {
        return this.expireAfterAccess;
    }

    public void setExpireAfterAccess(Duration expireAfterAccess) {
        this.expireAfterAccess = expireAfterAccess;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    public void setWriteBehindBatchSize(int writeBehindBatchSize) {
        this.mapOptions.writeBehindBatchSize(writeBehindBatchSize);
    }

    public void setWriteBehindDelay(int writeBehindDelay) {
        this.mapOptions.writeBehindDelay(writeBehindDelay);
    }

    public void setWriter(MapWriter<Object, Object> writer) {
        this.mapOptions.writer(writer);
    }

    public void setWriteMode(MapOptions.WriteMode writeMode) {
        this.mapOptions.writeMode(writeMode);
    }

    public void setLoader(MapLoader<Object, Object> loader) {
        this.mapOptions.loader(loader);
    }

    public MapOptions<Object, Object> getMapOptions() {
        return this.mapOptions;
    }
}

