/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.micronaut.cache;

import io.micronaut.cache.AsyncCache;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArgumentUtils;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import org.redisson.api.RMap;
import org.redisson.api.RMapCache;

public class RedissonAsyncCache
implements AsyncCache<RMap<Object, Object>> {
    private final ConversionService<?> conversionService;
    private final RMapCache<Object, Object> mapCache;
    private final RMap<Object, Object> map;
    private final ExecutorService executorService;

    public RedissonAsyncCache(RMapCache<Object, Object> mapCache, RMap<Object, Object> map, ExecutorService executorService, ConversionService<?> conversionService) {
        this.mapCache = mapCache;
        this.map = map;
        this.executorService = executorService;
        this.conversionService = conversionService;
    }

    public <T> CompletableFuture<Optional<T>> get(Object key, Argument<T> requiredType) {
        ArgumentUtils.requireNonNull((String)"key", (Object)key);
        return this.map.getAsync(key).thenApply(v -> {
            if (v != null) {
                return Optional.of(this.conversionService.convert(v, ConversionContext.of((Argument)requiredType)));
            }
            return Optional.empty();
        }).toCompletableFuture();
    }

    public <T> CompletableFuture<T> get(Object key, Argument<T> requiredType, Supplier<T> supplier) {
        ArgumentUtils.requireNonNull((String)"key", (Object)key);
        return this.get(key, requiredType).thenCompose(existingValue -> {
            if (existingValue.isPresent()) {
                return CompletableFuture.completedFuture(existingValue.get());
            }
            return CompletableFuture.supplyAsync(supplier, this.executorService).thenApply(value -> {
                this.put(key, value);
                return value;
            });
        });
    }

    public <T> CompletableFuture<Optional<T>> putIfAbsent(Object key, T value) {
        ArgumentUtils.requireNonNull((String)"key", (Object)key);
        ArgumentUtils.requireNonNull((String)"value", value);
        return this.map.putIfAbsentAsync(key, value).thenApply(v -> Optional.ofNullable(v)).toCompletableFuture();
    }

    public CompletableFuture<Boolean> put(Object key, Object value) {
        ArgumentUtils.requireNonNull((String)"key", (Object)key);
        ArgumentUtils.requireNonNull((String)"value", (Object)value);
        return this.map.fastPutAsync(key, value).thenApply(counter -> true).toCompletableFuture();
    }

    public CompletableFuture<Boolean> invalidate(Object key) {
        ArgumentUtils.requireNonNull((String)"key", (Object)key);
        return this.map.fastRemoveAsync(new Object[]{key}).thenApply(counter -> true).toCompletableFuture();
    }

    public CompletableFuture<Boolean> invalidateAll() {
        return this.map.deleteAsync().toCompletableFuture();
    }

    public String getName() {
        return this.map.getName();
    }

    public RMap<Object, Object> getNativeCache() {
        return this.map;
    }
}

