/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.micronaut;

import io.micronaut.context.annotation.ConfigurationBuilder;
import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import org.redisson.config.ClusterServersConfig;
import org.redisson.config.Config;
import org.redisson.config.MasterSlaveServersConfig;
import org.redisson.config.ReplicatedServersConfig;
import org.redisson.config.SentinelServersConfig;
import org.redisson.config.SingleServerConfig;

@ConfigurationProperties(value="redisson")
@Requirements(value={@Requires(missingBeans={Config.class}), @Requires(property="redisson")})
public class RedissonConfiguration
extends Config {
    public SingleServerConfig getSingleServerConfig() {
        if (this.isNotDefined()) {
            return this.useSingleServer();
        }
        return super.getSingleServerConfig();
    }

    @ConfigurationBuilder(value="singleServerConfig")
    protected void setSingleServerConfig(SingleServerConfig singleConnectionConfig) {
        super.setSingleServerConfig(singleConnectionConfig);
    }

    public ClusterServersConfig getClusterServersConfig() {
        if (this.isNotDefined()) {
            return this.useClusterServers();
        }
        return super.getClusterServersConfig();
    }

    @ConfigurationBuilder(value="clusterServersConfig", includes={"nodeAddresses"})
    protected void setClusterServersConfig(ClusterServersConfig clusterServersConfig) {
        super.setClusterServersConfig(clusterServersConfig);
    }

    private boolean isNotDefined() {
        return super.getSingleServerConfig() == null && super.getClusterServersConfig() == null && super.getReplicatedServersConfig() == null && super.getSentinelServersConfig() == null && super.getMasterSlaveServersConfig() == null;
    }

    public ReplicatedServersConfig getReplicatedServersConfig() {
        if (this.isNotDefined()) {
            return this.useReplicatedServers();
        }
        return super.getReplicatedServersConfig();
    }

    @ConfigurationBuilder(value="replicatedServersConfig", includes={"nodeAddresses"})
    protected void setReplicatedServersConfig(ReplicatedServersConfig replicatedServersConfig) {
        super.setReplicatedServersConfig(replicatedServersConfig);
    }

    public SentinelServersConfig getSentinelServersConfig() {
        if (this.isNotDefined()) {
            return this.useSentinelServers();
        }
        return super.getSentinelServersConfig();
    }

    @ConfigurationBuilder(value="sentinelServersConfig", includes={"sentinelAddresses"})
    protected void setSentinelServersConfig(SentinelServersConfig sentinelConnectionConfig) {
        super.setSentinelServersConfig(sentinelConnectionConfig);
    }

    public MasterSlaveServersConfig getMasterSlaveServersConfig() {
        if (this.isNotDefined()) {
            return this.useMasterSlaveServers();
        }
        return super.getMasterSlaveServersConfig();
    }

    @ConfigurationBuilder(value="masterSlaveServersConfig", includes={"slaveAddresses"})
    protected void setMasterSlaveServersConfig(MasterSlaveServersConfig masterSlaveConnectionConfig) {
        super.setMasterSlaveServersConfig(masterSlaveConnectionConfig);
    }
}

