/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.hibernate.region;

import java.util.Properties;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.CacheDataDescription;
import org.hibernate.cache.spi.CacheKeysFactory;
import org.hibernate.cache.spi.CollectionRegion;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.cache.spi.access.CollectionRegionAccessStrategy;
import org.hibernate.cfg.Settings;
import org.redisson.api.RMapCache;
import org.redisson.connection.ServiceManager;
import org.redisson.hibernate.region.BaseRegion;
import org.redisson.hibernate.strategy.NonStrictReadWriteCollectionRegionAccessStrategy;
import org.redisson.hibernate.strategy.ReadOnlyCollectionRegionAccessStrategy;
import org.redisson.hibernate.strategy.ReadWriteCollectionRegionAccessStrategy;
import org.redisson.hibernate.strategy.TransactionalCollectionRegionAccessStrategy;

public class RedissonCollectionRegion
extends BaseRegion
implements CollectionRegion {
    private final Settings settings;
    private final CacheKeysFactory cacheKeysFactory;

    public RedissonCollectionRegion(RMapCache<Object, Object> mapCache, ServiceManager serviceManager, RegionFactory regionFactory, CacheDataDescription metadata, Settings settings, Properties properties, String defaultKey, CacheKeysFactory cacheKeysFactory) {
        super(mapCache, serviceManager, regionFactory, metadata, properties, defaultKey);
        this.settings = settings;
        this.cacheKeysFactory = cacheKeysFactory;
    }

    public CacheKeysFactory getCacheKeysFactory() {
        return this.cacheKeysFactory;
    }

    public CollectionRegionAccessStrategy buildAccessStrategy(AccessType accessType) throws CacheException {
        if (accessType == AccessType.READ_ONLY) {
            return new ReadOnlyCollectionRegionAccessStrategy(this.settings, this);
        }
        if (accessType == AccessType.READ_WRITE) {
            return new ReadWriteCollectionRegionAccessStrategy(this.settings, this, (RMapCache<Object, Object>)this.mapCache);
        }
        if (accessType == AccessType.NONSTRICT_READ_WRITE) {
            return new NonStrictReadWriteCollectionRegionAccessStrategy(this.settings, this);
        }
        if (accessType == AccessType.TRANSACTIONAL) {
            return new TransactionalCollectionRegionAccessStrategy(this.settings, this);
        }
        throw new CacheException("Unsupported access strategy: " + accessType);
    }
}

