/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.hibernate.strategy;

import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.CollectionRegion;
import org.hibernate.cache.spi.GeneralDataRegion;
import org.hibernate.cache.spi.access.CollectionRegionAccessStrategy;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.cfg.Settings;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.persister.collection.CollectionPersister;
import org.redisson.hibernate.region.RedissonCollectionRegion;
import org.redisson.hibernate.strategy.BaseRegionAccessStrategy;

public class ReadOnlyCollectionRegionAccessStrategy
extends BaseRegionAccessStrategy
implements CollectionRegionAccessStrategy {
    public ReadOnlyCollectionRegionAccessStrategy(Settings settings, GeneralDataRegion region) {
        super(settings, region);
    }

    public CollectionRegion getRegion() {
        return (CollectionRegion)this.region;
    }

    public Object get(SessionImplementor session, Object key, long txTimestamp) throws CacheException {
        return this.region.get(session, key);
    }

    public boolean putFromLoad(SessionImplementor session, Object key, Object value, long txTimestamp, Object version, boolean minimalPutOverride) throws CacheException {
        if (minimalPutOverride && this.region.contains(key)) {
            return false;
        }
        this.region.put(session, key, value);
        return true;
    }

    public SoftLock lockItem(SessionImplementor session, Object key, Object version) throws CacheException {
        return null;
    }

    public void unlockItem(SessionImplementor session, Object key, SoftLock lock) throws CacheException {
    }

    public Object generateCacheKey(Object id, CollectionPersister persister, SessionFactoryImplementor factory, String tenantIdentifier) {
        return ((RedissonCollectionRegion)this.region).getCacheKeysFactory().createCollectionKey(id, persister, factory, tenantIdentifier);
    }

    public Object getCacheKeyId(Object cacheKey) {
        return ((RedissonCollectionRegion)this.region).getCacheKeysFactory().getCollectionId(cacheKey);
    }
}

