/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.hibernate.strategy;

import org.hibernate.cache.CacheException;
import org.hibernate.cache.internal.DefaultCacheKeysFactory;
import org.hibernate.cache.spi.GeneralDataRegion;
import org.hibernate.cache.spi.NaturalIdRegion;
import org.hibernate.cache.spi.access.NaturalIdRegionAccessStrategy;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.cfg.Settings;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.redisson.api.RMapCache;
import org.redisson.hibernate.strategy.AbstractReadWriteAccessStrategy;

public class ReadWriteNaturalIdRegionAccessStrategy
extends AbstractReadWriteAccessStrategy
implements NaturalIdRegionAccessStrategy {
    public ReadWriteNaturalIdRegionAccessStrategy(Settings settings, GeneralDataRegion region, RMapCache<Object, Object> mapCache) {
        super(settings, region, mapCache);
    }

    public NaturalIdRegion getRegion() {
        return (NaturalIdRegion)this.region;
    }

    public boolean insert(SessionImplementor session, Object key, Object value) throws CacheException {
        return false;
    }

    public boolean afterInsert(SessionImplementor session, Object key, Object value) throws CacheException {
        this.region.put(session, key, value);
        return true;
    }

    public boolean update(SessionImplementor session, Object key, Object value) throws CacheException {
        return false;
    }

    public boolean afterUpdate(SessionImplementor session, Object key, Object value, SoftLock lock) throws CacheException {
        this.region.put(session, key, value);
        return true;
    }

    public Object generateCacheKey(Object[] naturalIdValues, EntityPersister persister, SessionImplementor session) {
        return DefaultCacheKeysFactory.staticCreateNaturalIdKey((Object[])naturalIdValues, (EntityPersister)persister, (SessionImplementor)session);
    }

    public Object[] getNaturalIdValues(Object cacheKey) {
        return DefaultCacheKeysFactory.staticGetNaturalIdValues((Object)cacheKey);
    }
}

