/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.hibernate;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.CacheDataDescription;
import org.hibernate.cache.spi.CollectionRegion;
import org.hibernate.cache.spi.EntityRegion;
import org.hibernate.cache.spi.NaturalIdRegion;
import org.hibernate.cache.spi.QueryResultsRegion;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.cache.spi.TimestampsRegion;
import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.cfg.Settings;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.jboss.logging.Logger;
import org.redisson.Redisson;
import org.redisson.api.RMapCache;
import org.redisson.api.RScript;
import org.redisson.api.RedissonClient;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.LongCodec;
import org.redisson.config.Config;
import org.redisson.hibernate.region.RedissonCollectionRegion;
import org.redisson.hibernate.region.RedissonEntityRegion;
import org.redisson.hibernate.region.RedissonNaturalIdRegion;
import org.redisson.hibernate.region.RedissonQueryRegion;
import org.redisson.hibernate.region.RedissonTimestampsRegion;

public class RedissonRegionFactory
implements RegionFactory {
    private static final Logger log = Logger.getLogger(RedissonRegionFactory.class);
    private static final long serialVersionUID = 3785315696581773811L;
    public static final String QUERY_DEF = "query";
    public static final String COLLECTION_DEF = "collection";
    public static final String ENTITY_DEF = "entity";
    public static final String NATURAL_ID_DEF = "naturalid";
    public static final String TIMESTAMPS_DEF = "timestamps";
    public static final String MAX_ENTRIES_SUFFIX = ".eviction.max_entries";
    public static final String TTL_SUFFIX = ".expiration.time_to_live";
    public static final String MAX_IDLE_SUFFIX = ".expiration.max_idle_time";
    public static final String CONFIG_PREFIX = "hibernate.cache.redisson.";
    public static final String REDISSON_CONFIG_PATH = "hibernate.cache.redisson.config";
    public static final String FALLBACK = "hibernate.cache.redisson.fallback";
    protected RedissonClient redisson;
    private Settings settings;

    public void start(Settings settings, Properties properties) throws CacheException {
        this.redisson = this.createRedissonClient(properties);
        this.settings = settings;
    }

    protected RedissonClient createRedissonClient(Properties properties) {
        Config config = null;
        if (!properties.containsKey(REDISSON_CONFIG_PATH)) {
            config = this.loadConfig(RedissonRegionFactory.class.getClassLoader(), "redisson.json");
            if (config == null) {
                config = this.loadConfig(RedissonRegionFactory.class.getClassLoader(), "redisson.yaml");
            }
        } else {
            String configPath = ConfigurationHelper.getString((String)REDISSON_CONFIG_PATH, (Map)properties);
            config = this.loadConfig(RedissonRegionFactory.class.getClassLoader(), configPath);
            if (config == null) {
                config = this.loadConfig(configPath);
            }
        }
        if (config == null) {
            throw new CacheException("Unable to locate Redisson configuration");
        }
        return Redisson.create((Config)config);
    }

    private Config loadConfig(String configPath) {
        try {
            return Config.fromYAML((File)new File(configPath));
        }
        catch (IOException e) {
            try {
                return Config.fromJSON((File)new File(configPath));
            }
            catch (IOException e1) {
                throw new CacheException("Can't parse default yaml config", (Throwable)e1);
            }
        }
    }

    private Config loadConfig(ClassLoader classLoader, String fileName) {
        InputStream is = classLoader.getResourceAsStream(fileName);
        if (is != null) {
            try {
                return Config.fromYAML((InputStream)is);
            }
            catch (IOException e) {
                try {
                    is = classLoader.getResourceAsStream(fileName);
                    return Config.fromJSON((InputStream)is);
                }
                catch (IOException e1) {
                    throw new CacheException("Can't parse yaml config", (Throwable)e1);
                }
            }
        }
        return null;
    }

    public void stop() {
        this.redisson.shutdown();
    }

    public boolean isMinimalPutsEnabledByDefault() {
        return true;
    }

    public AccessType getDefaultAccessType() {
        return AccessType.TRANSACTIONAL;
    }

    public long nextTimestamp() {
        long time = System.currentTimeMillis() << 12;
        return (Long)this.redisson.getScript((Codec)LongCodec.INSTANCE).eval(RScript.Mode.READ_WRITE, "local currentTime = redis.call('get', KEYS[1]);if currentTime == false then redis.call('set', KEYS[1], ARGV[1]); return ARGV[1]; end;local nextValue = math.max(tonumber(ARGV[1]), tonumber(currentTime) + 1); redis.call('set', KEYS[1], nextValue); return nextValue;", RScript.ReturnType.INTEGER, Arrays.asList("redisson-hibernate-timestamp"), new Object[]{time});
    }

    public EntityRegion buildEntityRegion(String regionName, Properties properties, CacheDataDescription metadata) throws CacheException {
        log.debug((Object)("Building entity cache region: " + regionName));
        RMapCache<Object, Object> mapCache = this.getCache(regionName, properties, ENTITY_DEF);
        return new RedissonEntityRegion(mapCache, ((Redisson)this.redisson).getConnectionManager(), this, metadata, this.settings, properties, ENTITY_DEF);
    }

    public NaturalIdRegion buildNaturalIdRegion(String regionName, Properties properties, CacheDataDescription metadata) throws CacheException {
        log.debug((Object)("Building naturalId cache region: " + regionName));
        RMapCache<Object, Object> mapCache = this.getCache(regionName, properties, NATURAL_ID_DEF);
        return new RedissonNaturalIdRegion(mapCache, ((Redisson)this.redisson).getConnectionManager(), this, metadata, this.settings, properties, NATURAL_ID_DEF);
    }

    public CollectionRegion buildCollectionRegion(String regionName, Properties properties, CacheDataDescription metadata) throws CacheException {
        log.debug((Object)("Building collection cache region: " + regionName));
        RMapCache<Object, Object> mapCache = this.getCache(regionName, properties, COLLECTION_DEF);
        return new RedissonCollectionRegion(mapCache, ((Redisson)this.redisson).getConnectionManager(), this, metadata, this.settings, properties, COLLECTION_DEF);
    }

    public QueryResultsRegion buildQueryResultsRegion(String regionName, Properties properties) throws CacheException {
        log.debug((Object)("Building query cache region: " + regionName));
        RMapCache<Object, Object> mapCache = this.getCache(regionName, properties, QUERY_DEF);
        return new RedissonQueryRegion(mapCache, ((Redisson)this.redisson).getConnectionManager(), this, properties, QUERY_DEF);
    }

    public TimestampsRegion buildTimestampsRegion(String regionName, Properties properties) throws CacheException {
        log.debug((Object)("Building timestamps cache region: " + regionName));
        RMapCache<Object, Object> mapCache = this.getCache(regionName, properties, TIMESTAMPS_DEF);
        return new RedissonTimestampsRegion(mapCache, ((Redisson)this.redisson).getConnectionManager(), this, properties, TIMESTAMPS_DEF);
    }

    protected RMapCache<Object, Object> getCache(String regionName, Properties properties, String defaultKey) {
        return this.redisson.getMapCache(regionName);
    }
}

