/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.hibernate.strategy;

import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.GeneralDataRegion;
import org.hibernate.cache.spi.NaturalIdRegion;
import org.hibernate.cache.spi.access.NaturalIdRegionAccessStrategy;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.cfg.Settings;
import org.redisson.api.RLock;
import org.redisson.api.RMapCache;
import org.redisson.hibernate.strategy.AbstractReadWriteAccessStrategy;

public class ReadWriteNaturalIdRegionAccessStrategy
extends AbstractReadWriteAccessStrategy
implements NaturalIdRegionAccessStrategy {
    public ReadWriteNaturalIdRegionAccessStrategy(Settings settings, GeneralDataRegion region, RMapCache<Object, Object> mapCache) {
        super(settings, region, mapCache);
    }

    public NaturalIdRegion getRegion() {
        return (NaturalIdRegion)this.region;
    }

    public boolean insert(Object key, Object value) throws CacheException {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean afterInsert(Object key, Object value) throws CacheException {
        RLock writeLock = this.mapCache.getReadWriteLock(key).writeLock();
        writeLock.lock();
        try {
            AbstractReadWriteAccessStrategy.Lockable item = (AbstractReadWriteAccessStrategy.Lockable)this.region.get(key);
            if (item == null) {
                this.region.put(key, (Object)new AbstractReadWriteAccessStrategy.Item(value, null, this.region.nextTimestamp()));
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            writeLock.unlock();
        }
    }

    public boolean update(Object key, Object value) throws CacheException {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean afterUpdate(Object key, Object value, SoftLock lock) throws CacheException {
        RLock writeLock = this.mapCache.getReadWriteLock(key).writeLock();
        writeLock.lock();
        try {
            AbstractReadWriteAccessStrategy.Lockable item = (AbstractReadWriteAccessStrategy.Lockable)this.region.get(key);
            if (item != null && item.isUnlockable(lock)) {
                AbstractReadWriteAccessStrategy.Lock lockItem = (AbstractReadWriteAccessStrategy.Lock)item;
                if (lockItem.wasLockedConcurrently()) {
                    this.decrementLock(key, lockItem);
                    boolean bl = false;
                    return bl;
                }
                this.region.put(key, (Object)new AbstractReadWriteAccessStrategy.Item(value, null, this.region.nextTimestamp()));
                boolean bl = true;
                return bl;
            }
            this.handleLockExpiry(key, item);
            boolean bl = false;
            return bl;
        }
        finally {
            writeLock.unlock();
        }
    }
}

