/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.hibernate.strategy;

import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.GeneralDataRegion;
import org.hibernate.cache.spi.access.RegionAccessStrategy;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.cfg.Settings;

abstract class BaseRegionAccessStrategy
implements RegionAccessStrategy {
    final GeneralDataRegion region;
    final Settings settings;

    BaseRegionAccessStrategy(Settings settings, GeneralDataRegion region) {
        this.settings = settings;
        this.region = region;
    }

    public boolean putFromLoad(Object key, Object value, long txTimestamp, Object version) throws CacheException {
        return this.putFromLoad(key, value, txTimestamp, version, this.settings.isMinimalPutsEnabled());
    }

    public SoftLock lockRegion() throws CacheException {
        return null;
    }

    public void unlockRegion(SoftLock lock) throws CacheException {
        this.region.evictAll();
    }

    public void remove(Object key) throws CacheException {
    }

    public void removeAll() throws CacheException {
        this.region.evictAll();
    }

    public void evict(Object key) throws CacheException {
        this.region.evict(key);
    }

    public void evictAll() throws CacheException {
        this.region.evictAll();
    }
}

