/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.hibernate.strategy;

import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.CollectionRegion;
import org.hibernate.cache.spi.GeneralDataRegion;
import org.hibernate.cache.spi.access.CollectionRegionAccessStrategy;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.cfg.Settings;
import org.redisson.hibernate.strategy.BaseRegionAccessStrategy;

public class ReadOnlyCollectionRegionAccessStrategy
extends BaseRegionAccessStrategy
implements CollectionRegionAccessStrategy {
    public ReadOnlyCollectionRegionAccessStrategy(Settings settings, GeneralDataRegion region) {
        super(settings, region);
    }

    public CollectionRegion getRegion() {
        return (CollectionRegion)this.region;
    }

    public Object get(Object key, long txTimestamp) throws CacheException {
        return this.region.get(key);
    }

    public boolean putFromLoad(Object key, Object value, long txTimestamp, Object version, boolean minimalPutOverride) throws CacheException {
        if (minimalPutOverride && this.region.contains(key)) {
            return false;
        }
        this.region.put(key, value);
        return true;
    }

    public SoftLock lockItem(Object key, Object version) throws CacheException {
        return null;
    }

    public void unlockItem(Object key, SoftLock lock) throws CacheException {
    }
}

