/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.hibernate.strategy;

import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.GeneralDataRegion;
import org.hibernate.cache.spi.NaturalIdRegion;
import org.hibernate.cache.spi.access.NaturalIdRegionAccessStrategy;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.cfg.Settings;
import org.redisson.hibernate.strategy.BaseRegionAccessStrategy;

public class TransactionalNaturalIdRegionAccessStrategy
extends BaseRegionAccessStrategy
implements NaturalIdRegionAccessStrategy {
    public TransactionalNaturalIdRegionAccessStrategy(Settings settings, GeneralDataRegion region) {
        super(settings, region);
    }

    public Object get(Object key, long txTimestamp) throws CacheException {
        return this.region.get(key);
    }

    public boolean putFromLoad(Object key, Object value, long txTimestamp, Object version, boolean minimalPutOverride) throws CacheException {
        if (minimalPutOverride && this.region.contains(key)) {
            return false;
        }
        this.region.put(key, value);
        return true;
    }

    public SoftLock lockItem(Object key, Object version) throws CacheException {
        return null;
    }

    public void unlockItem(Object key, SoftLock lock) throws CacheException {
    }

    public NaturalIdRegion getRegion() {
        return (NaturalIdRegion)this.region;
    }

    @Override
    public void remove(Object key) throws CacheException {
        this.region.evict(key);
    }

    public boolean insert(Object key, Object value) throws CacheException {
        this.region.put(key, value);
        return true;
    }

    public boolean afterInsert(Object key, Object value) throws CacheException {
        return false;
    }

    public boolean update(Object key, Object value) throws CacheException {
        return this.insert(key, value);
    }

    public boolean afterUpdate(Object key, Object value, SoftLock lock) throws CacheException {
        return false;
    }
}

