/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.helidon;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.ProcessInjectionPoint;
import javax.inject.Named;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;
import org.redisson.config.PropertiesConvertor;

public class RedissonExtension
implements Extension {
    private final Set<Annotation> qualifiers = new HashSet<Annotation>();

    private <T extends RedissonClient> void processRedissonInjectionPoint(@Observes ProcessInjectionPoint<?, T> point) {
        if (point == null) {
            return;
        }
        InjectionPoint injectionPoint = point.getInjectionPoint();
        if (injectionPoint == null) {
            return;
        }
        this.qualifiers.addAll(injectionPoint.getQualifiers());
    }

    private void addBeans(@Observes AfterBeanDiscovery discovery, BeanManager beanManager) {
        if (discovery == null || beanManager == null) {
            return;
        }
        for (Annotation qualifier : this.qualifiers) {
            Set<Annotation> qualifiers = Collections.singleton(qualifier);
            discovery.addBean().scope(ApplicationScoped.class).addQualifiers(qualifiers).addTransitiveTypeClosure(RedissonClient.class).produceWith(instance -> {
                String instanceName = "default";
                if (qualifier instanceof Named) {
                    instanceName = ((Named)qualifier).value();
                }
                org.eclipse.microprofile.config.Config cfg = (org.eclipse.microprofile.config.Config)instance.select(org.eclipse.microprofile.config.Config.class, new Annotation[0]).get();
                String yamlConfig = PropertiesConvertor.toYaml((String)(Redisson.class.getName() + "." + instanceName + "."), (Iterable)cfg.getPropertyNames(), prop -> (String)cfg.getValue(prop, String.class));
                try {
                    Config config = Config.fromYAML((String)yamlConfig);
                    return Redisson.create((Config)config);
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            });
        }
    }
}

