/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.transaction.operation.bucket;

import org.redisson.RedissonBucket;
import org.redisson.client.codec.Codec;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.transaction.RedissonTransactionalLock;
import org.redisson.transaction.operation.TransactionalOperation;

public class BucketCompareAndSetOperation<V>
extends TransactionalOperation {
    private V expected;
    private V value;
    private String lockName;
    private String transactionId;

    public BucketCompareAndSetOperation(String name, String lockName, Codec codec, V expected, V value, String transactionId, long threadId) {
        super(name, codec, threadId);
        this.expected = expected;
        this.value = value;
        this.lockName = lockName;
        this.transactionId = transactionId;
    }

    @Override
    public void commit(CommandAsyncExecutor commandExecutor) {
        RedissonBucket<V> bucket = new RedissonBucket<V>(this.codec, commandExecutor, this.name);
        bucket.compareAndSetAsync(this.expected, this.value);
        RedissonTransactionalLock lock = new RedissonTransactionalLock(commandExecutor, this.lockName, this.transactionId);
        lock.unlockAsync(this.getThreadId());
    }

    @Override
    public void rollback(CommandAsyncExecutor commandExecutor) {
        RedissonTransactionalLock lock = new RedissonTransactionalLock(commandExecutor, this.lockName, this.transactionId);
        lock.unlockAsync(this.getThreadId());
    }

    public V getExpected() {
        return this.expected;
    }

    public V getValue() {
        return this.value;
    }

    public String getLockName() {
        return this.lockName;
    }
}

