/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.api.search.query.hybrid;

import org.redisson.api.search.query.hybrid.VectorSimilarity;
import org.redisson.api.search.query.hybrid.VectorSimilarityBasic;
import org.redisson.api.search.query.hybrid.VectorSimilarityNearestNeighbors;
import org.redisson.api.search.query.hybrid.VectorSimilarityRange;

public final class VectorSimilarityParams
implements VectorSimilarityRange,
VectorSimilarityNearestNeighbors,
VectorSimilarityBasic {
    private final String field;
    private final String param;
    private VectorSearchMode mode;
    private Integer knnK;
    private Integer efRuntime;
    private Double rangeRadius;
    private Double rangeEpsilon;
    private String scoreAlias;
    private String filter;

    VectorSimilarityParams(String field, String param) {
        this.field = field;
        this.param = param;
        this.mode = null;
    }

    @Override
    public VectorSimilarityRange range(double radius) {
        this.mode = VectorSearchMode.RANGE;
        this.rangeRadius = radius;
        return this;
    }

    @Override
    public VectorSimilarityNearestNeighbors nearestNeighbors(int k) {
        this.mode = VectorSearchMode.KNN;
        this.knnK = k;
        return this;
    }

    @Override
    public VectorSimilarity epsilon(double epsilon) {
        this.rangeEpsilon = epsilon;
        return this;
    }

    @Override
    public VectorSimilarity efRuntime(int efRuntime) {
        this.efRuntime = efRuntime;
        return this;
    }

    @Override
    public VectorSimilarityBasic scoreAlias(String value) {
        this.scoreAlias = value;
        return this;
    }

    @Override
    public VectorSimilarityBasic filter(String value) {
        this.filter = value;
        return this;
    }

    public String getField() {
        return this.field;
    }

    public String getParam() {
        return this.param;
    }

    public VectorSearchMode getMode() {
        return this.mode;
    }

    public Integer getKnnK() {
        return this.knnK;
    }

    public Integer getEfRuntime() {
        return this.efRuntime;
    }

    public Double getRangeRadius() {
        return this.rangeRadius;
    }

    public Double getRangeEpsilon() {
        return this.rangeEpsilon;
    }

    public String getScoreAlias() {
        return this.scoreAlias;
    }

    public String getFilter() {
        return this.filter;
    }

    public static enum VectorSearchMode {
        KNN,
        RANGE;

    }
}

