/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.api.map;

import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import org.redisson.api.map.PutArgs;

public final class PutParams<K, V>
implements PutArgs<K, V> {
    private boolean keepTTL;
    private Duration timeToLive;
    private Instant expireAt;
    private final Map<K, V> entries;

    public PutParams(Map<K, V> values) {
        this.entries = values;
    }

    @Override
    public PutArgs<K, V> keepTTL() {
        this.keepTTL = true;
        return this;
    }

    @Override
    public PutArgs<K, V> timeToLive(Duration ttl) {
        this.timeToLive = ttl;
        return this;
    }

    @Override
    public PutArgs<K, V> expireAt(Instant time) {
        this.expireAt = time;
        return this;
    }

    public boolean isKeepTTL() {
        return this.keepTTL;
    }

    public Duration getTimeToLive() {
        return this.timeToLive;
    }

    public Instant getExpireAt() {
        return this.expireAt;
    }

    public Map<K, V> getEntries() {
        return this.entries;
    }
}

