/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.api.bucket;

import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import org.redisson.api.bucket.CompareAndSetParams;
import org.redisson.api.bucket.CompareAndSetStep;
import org.redisson.api.bucket.ConditionType;

public interface CompareAndSetArgs<V> {
    public static <V> CompareAndSetStep<V> expected(V object) {
        return new CompareAndSetParams<V>(ConditionType.EXPECTED, object);
    }

    public static <V> CompareAndSetStep<V> unexpected(V object) {
        return new CompareAndSetParams<V>(ConditionType.UNEXPECTED, object);
    }

    public static <V> CompareAndSetStep<V> expectedDigest(String value) {
        Objects.requireNonNull(value, "Digest value can't be null");
        return new CompareAndSetParams(ConditionType.EXPECTED_DIGEST, value);
    }

    public static <V> CompareAndSetStep<V> unexpectedDigest(String value) {
        Objects.requireNonNull(value, "Digest value can't be null");
        return new CompareAndSetParams(ConditionType.UNEXPECTED_DIGEST, value);
    }

    public CompareAndSetArgs<V> timeToLive(Duration var1);

    public CompareAndSetArgs<V> expireAt(Instant var1);
}

