/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import org.redisson.RedissonBlockingQueue;
import org.redisson.RedissonQueue;
import org.redisson.RedissonQueueSemaphore;
import org.redisson.RedissonSemaphore;
import org.redisson.api.Entry;
import org.redisson.api.RBoundedBlockingQueue;
import org.redisson.api.RFuture;
import org.redisson.api.RedissonClient;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.connection.decoder.ListDrainToDecoder;
import org.redisson.misc.CompletableFutureWrapper;

@Deprecated
public class RedissonBoundedBlockingQueue<V>
extends RedissonQueue<V>
implements RBoundedBlockingQueue<V> {
    private final RedissonBlockingQueue<V> blockingQueue;
    private final RedissonQueueSemaphore semaphore;
    private final String channelName;
    private final String semaphoreName;

    protected RedissonBoundedBlockingQueue(CommandAsyncExecutor commandExecutor, String name, RedissonClient redisson) {
        super(commandExecutor, name, redisson);
        this.blockingQueue = new RedissonBlockingQueue(commandExecutor, name, redisson);
        this.semaphoreName = this.getSemaphoreName(this.getRawName());
        this.semaphore = new RedissonQueueSemaphore(commandExecutor, this.semaphoreName, this.getServiceManager().getCfg().getCodec());
        this.channelName = RedissonSemaphore.getChannelName(this.semaphore.getRawName());
    }

    protected RedissonBoundedBlockingQueue(Codec codec, CommandAsyncExecutor commandExecutor, String name, RedissonClient redisson) {
        super(codec, commandExecutor, name, redisson);
        this.blockingQueue = new RedissonBlockingQueue(commandExecutor, name, redisson);
        this.semaphoreName = this.getSemaphoreName(this.getRawName());
        this.semaphore = new RedissonQueueSemaphore(commandExecutor, this.semaphoreName, codec);
        this.channelName = RedissonSemaphore.getChannelName(this.semaphore.getRawName());
    }

    private String getSemaphoreName(String name) {
        return RedissonBoundedBlockingQueue.prefixName("redisson_bqs", name);
    }

    @Override
    public RFuture<Boolean> addAsync(V e) {
        RFuture<Boolean> future = this.offerAsync(e);
        CompletionStage<Boolean> f = future.handle((res, ex) -> {
            if (ex != null) {
                throw new CompletionException((Throwable)ex);
            }
            if (!res.booleanValue()) {
                throw new CompletionException(new IllegalStateException("Queue is full"));
            }
            return true;
        });
        return new CompletableFutureWrapper<Boolean>(f);
    }

    @Override
    public RFuture<Void> putAsync(V e) {
        RedissonQueueSemaphore semaphore = this.createSemaphore(e);
        return semaphore.acquireAsync();
    }

    private RedissonQueueSemaphore createSemaphore(V e) {
        RedissonQueueSemaphore semaphore = new RedissonQueueSemaphore(this.commandExecutor, this.semaphoreName, this.getCodec());
        semaphore.setQueueName(this.getRawName());
        semaphore.setValue(e);
        return semaphore;
    }

    @Override
    public void put(V e) throws InterruptedException {
        RedissonQueueSemaphore semaphore = this.createSemaphore(e);
        semaphore.acquire();
    }

    @Override
    public RFuture<Boolean> offerAsync(V e) {
        RedissonQueueSemaphore semaphore = this.createSemaphore(e);
        return semaphore.tryAcquireAsync();
    }

    @Override
    public boolean offer(V e, long timeout, TimeUnit unit) throws InterruptedException {
        RedissonQueueSemaphore semaphore = this.createSemaphore(e);
        return semaphore.tryAcquire(timeout, unit);
    }

    @Override
    public RFuture<Boolean> offerAsync(V e, long timeout, TimeUnit unit) {
        RedissonQueueSemaphore semaphore = this.createSemaphore(e);
        return semaphore.tryAcquireAsync(timeout, unit);
    }

    @Override
    public RFuture<V> takeAsync() {
        RFuture<V> takeFuture = this.blockingQueue.takeAsync();
        return this.wrapTakeFuture(takeFuture);
    }

    private <V> RFuture<V> wrapTakeFuture(RFuture<V> takeFuture) {
        CompletionStage f = takeFuture.thenCompose(res -> {
            if (res == null) {
                return CompletableFuture.completedFuture(null);
            }
            return this.createSemaphore(null).releaseAsync().handle((r, ex) -> res);
        });
        f.whenComplete((r, e) -> {
            if (f.toCompletableFuture().isCancelled()) {
                takeFuture.cancel(false);
            }
        });
        return new CompletableFutureWrapper(f);
    }

    @Override
    public RFuture<Boolean> removeAsync(Object o) {
        return this.removeAllAsync(Collections.singleton(o));
    }

    @Override
    public RFuture<Boolean> removeAllAsync(Collection<?> c) {
        if (c.isEmpty()) {
            return new CompletableFutureWrapper<Boolean>(false);
        }
        return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, RedisCommands.EVAL_BOOLEAN, "local count = 0; for i = 1, #ARGV, 1 do if redis.call('lrem', KEYS[1], 0, ARGV[i]) == 1 then count = count + 1; end; end; if count > 0 then local value = redis.call('incrby', KEYS[2], count); redis.call('publish', KEYS[3], value); return 1;end;return 0 ", Arrays.asList(this.getRawName(), this.semaphore.getRawName(), this.channelName), this.encode(c).toArray());
    }

    @Override
    public RFuture<V> pollAsync() {
        return this.commandExecutor.evalWriteNoRetryAsync(this.getRawName(), this.codec, RedisCommands.EVAL_OBJECT, "local res = redis.call('lpop', KEYS[1]);if res ~= false then local value = redis.call('incrby', KEYS[2], ARGV[1]); redis.call('publish', KEYS[3], value); end;return res;", Arrays.asList(this.getRawName(), this.semaphore.getRawName(), this.channelName), 1);
    }

    @Override
    public V take() throws InterruptedException {
        return this.commandExecutor.getInterrupted(this.takeAsync());
    }

    @Override
    public RFuture<V> pollAsync(long timeout, TimeUnit unit) {
        RFuture<V> takeFuture = this.blockingQueue.pollAsync(timeout, unit);
        return this.wrapTakeFuture(takeFuture);
    }

    @Override
    public V poll(long timeout, TimeUnit unit) throws InterruptedException {
        return this.commandExecutor.getInterrupted(this.pollAsync(timeout, unit));
    }

    @Override
    public V pollFromAny(long timeout, TimeUnit unit, String ... queueNames) throws InterruptedException {
        return this.commandExecutor.getInterrupted(this.pollFromAnyAsync(timeout, unit, queueNames));
    }

    @Override
    public RFuture<V> pollFromAnyAsync(long timeout, TimeUnit unit, String ... queueNames) {
        RFuture<V> takeFuture = this.blockingQueue.pollFromAnyAsync(timeout, unit, queueNames);
        return this.wrapTakeFuture(takeFuture);
    }

    @Override
    public Entry<String, V> pollFromAnyWithName(Duration timeout, String ... queueNames) throws InterruptedException {
        return this.commandExecutor.getInterrupted(this.pollFromAnyWithNameAsync(timeout, queueNames));
    }

    @Override
    public RFuture<Entry<String, V>> pollFromAnyWithNameAsync(Duration timeout, String ... queueNames) {
        RFuture<Entry<String, V>> takeFuture = this.blockingQueue.pollFromAnyWithNameAsync(timeout, queueNames);
        return this.wrapTakeFuture(takeFuture);
    }

    @Override
    public Entry<String, V> pollLastFromAnyWithName(Duration timeout, String ... queueNames) throws InterruptedException {
        return this.commandExecutor.getInterrupted(this.pollLastFromAnyWithNameAsync(timeout, queueNames));
    }

    @Override
    public RFuture<Entry<String, V>> pollLastFromAnyWithNameAsync(Duration timeout, String ... queueNames) {
        RFuture<Entry<String, V>> takeFuture = this.blockingQueue.pollLastFromAnyWithNameAsync(timeout, queueNames);
        return this.wrapTakeFuture(takeFuture);
    }

    @Override
    public Map<String, List<V>> pollFirstFromAny(Duration duration, int count, String ... queueNames) {
        return this.get(this.pollFirstFromAnyAsync(duration, count, queueNames));
    }

    @Override
    public Map<String, List<V>> pollLastFromAny(Duration duration, int count, String ... queueNames) {
        return this.get(this.pollLastFromAnyAsync(duration, count, queueNames));
    }

    @Override
    public RFuture<Map<String, List<V>>> pollFirstFromAnyAsync(Duration duration, int count, String ... queueNames) {
        RFuture<Map<String, List<V>>> future = this.blockingQueue.pollFirstFromAnyAsync(duration, count, queueNames);
        return this.wrapTakeFuture(future);
    }

    @Override
    public RFuture<Map<String, List<V>>> pollLastFromAnyAsync(Duration duration, int count, String ... queueNames) {
        RFuture<Map<String, List<V>>> future = this.blockingQueue.pollLastFromAnyAsync(duration, count, queueNames);
        return this.wrapTakeFuture(future);
    }

    @Override
    public V takeLastAndOfferFirstTo(String queueName) throws InterruptedException {
        return this.commandExecutor.getInterrupted(this.takeLastAndOfferFirstToAsync(queueName));
    }

    @Override
    public int subscribeOnElements(Consumer<V> consumer) {
        return this.getServiceManager().getElementsSubscribeService().subscribeOnElements(this::takeAsync, consumer);
    }

    @Override
    public int subscribeOnElements(Function<V, CompletionStage<Void>> consumer) {
        return this.getServiceManager().getElementsSubscribeService().subscribeOnElements(this::takeAsync, consumer);
    }

    @Override
    public void unsubscribe(int listenerId) {
        this.getServiceManager().getElementsSubscribeService().unsubscribe(listenerId);
    }

    @Override
    public RFuture<V> takeLastAndOfferFirstToAsync(String queueName) {
        return this.pollLastAndOfferFirstToAsync(queueName, 0L, TimeUnit.SECONDS);
    }

    @Override
    public RFuture<V> pollLastAndOfferFirstToAsync(String queueName, long timeout, TimeUnit unit) {
        RFuture<V> takeFuture = this.blockingQueue.pollLastAndOfferFirstToAsync(queueName, timeout, unit);
        return this.wrapTakeFuture(takeFuture);
    }

    @Override
    public V pollLastAndOfferFirstTo(String queueName, long timeout, TimeUnit unit) throws InterruptedException {
        return this.commandExecutor.getInterrupted(this.pollLastAndOfferFirstToAsync(queueName, timeout, unit));
    }

    @Override
    public int remainingCapacity() {
        return this.createSemaphore(null).availablePermits();
    }

    @Override
    public int drainTo(Collection<? super V> c) {
        return this.get(this.drainToAsync(c));
    }

    @Override
    public RFuture<Integer> drainToAsync(Collection<? super V> c) {
        if (c == null) {
            throw new NullPointerException();
        }
        return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, new RedisCommand<Integer>("EVAL", new ListDrainToDecoder(c)), "local vals = redis.call('lrange', KEYS[1], 0, -1); redis.call('del', KEYS[1]); if #vals > 0 then local value = redis.call('incrby', KEYS[2], #vals); redis.call('publish', KEYS[3], value); end; return vals", Arrays.asList(this.getRawName(), this.semaphore.getRawName(), this.channelName), new Object[0]);
    }

    @Override
    public int drainTo(Collection<? super V> c, int maxElements) {
        return this.get(this.drainToAsync(c, maxElements));
    }

    @Override
    public RFuture<Integer> drainToAsync(Collection<? super V> c, int maxElements) {
        if (c == null) {
            throw new NullPointerException();
        }
        if (maxElements <= 0) {
            return new CompletableFutureWrapper<Integer>(0);
        }
        return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, new RedisCommand<Integer>("EVAL", new ListDrainToDecoder(c)), "local elemNum = math.min(ARGV[1], redis.call('llen', KEYS[1])) - 1;local vals = redis.call('lrange', KEYS[1], 0, elemNum); redis.call('ltrim', KEYS[1], elemNum + 1, -1); if #vals > 0 then local value = redis.call('incrby', KEYS[2], #vals); redis.call('publish', KEYS[3], value); end; return vals", Arrays.asList(this.getRawName(), this.semaphore.getRawName(), this.channelName), maxElements);
    }

    @Override
    public RFuture<Boolean> trySetCapacityAsync(int capacity) {
        return this.commandExecutor.evalWriteAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "local value = redis.call('get', KEYS[1]); if (value == false) then redis.call('set', KEYS[1], ARGV[1]); redis.call('publish', KEYS[2], ARGV[1]); return 1;end;return 0;", Arrays.asList(this.semaphore.getRawName(), this.channelName), capacity);
    }

    @Override
    public boolean trySetCapacity(int capacity) {
        return this.get(this.trySetCapacityAsync(capacity));
    }

    @Override
    public void clear() {
        this.get(this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, RedisCommands.EVAL_BOOLEAN, "local len = redis.call('llen', KEYS[1]); if len > 0 then redis.call('del', KEYS[1]); local value = redis.call('incrby', KEYS[2], len); redis.call('publish', KEYS[3], value); end; ", Arrays.asList(this.getRawName(), this.semaphore.getRawName(), this.channelName), new Object[0]));
    }

    @Override
    public RFuture<Boolean> deleteAsync() {
        return this.deleteAsync(this.getRawName(), this.semaphoreName);
    }

    @Override
    public RFuture<Boolean> copyAsync(List<Object> keys, int database, boolean replace) {
        String newName = (String)keys.get(1);
        List<Object> kks = Arrays.asList(this.getRawName(), this.semaphoreName, newName, this.getSemaphoreName(newName));
        return super.copyAsync(kks, database, replace);
    }

    @Override
    public RFuture<Long> sizeInMemoryAsync() {
        List<Object> keys = Arrays.asList(this.getRawName(), this.semaphoreName);
        return super.sizeInMemoryAsync(keys);
    }

    @Override
    public RFuture<Boolean> expireAsync(long timeToLive, TimeUnit timeUnit, String param, String ... keys) {
        return super.expireAsync(timeToLive, timeUnit, param, this.getRawName(), this.semaphoreName);
    }

    @Override
    protected RFuture<Boolean> expireAtAsync(long timestamp, String param, String ... keys) {
        return super.expireAtAsync(timestamp, param, this.getRawName(), this.semaphoreName);
    }

    @Override
    public RFuture<Boolean> clearExpireAsync() {
        return this.clearExpireAsync(this.getRawName(), this.semaphoreName);
    }

    @Override
    public RFuture<Boolean> addAllAsync(Collection<? extends V> c) {
        if (c.isEmpty()) {
            return new CompletableFutureWrapper<Boolean>(false);
        }
        RedissonQueueSemaphore semaphore = new RedissonQueueSemaphore(this.commandExecutor, this.semaphoreName, this.getCodec());
        semaphore.setQueueName(this.getRawName());
        semaphore.setValues(c);
        return semaphore.tryAcquireAsync();
    }
}

