/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.transaction.operation;

import org.redisson.RedissonKeys;
import org.redisson.RedissonLock;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.transaction.RedissonTransactionalLock;
import org.redisson.transaction.RedissonTransactionalWriteLock;
import org.redisson.transaction.operation.TransactionalOperation;

public class DeleteOperation
extends TransactionalOperation {
    private String writeLockName;
    private String lockName;
    private String transactionId;

    public DeleteOperation(String name) {
        this(name, null, null, 0L);
    }

    public DeleteOperation(String name, String lockName, String transactionId, long threadId) {
        super(name, null, threadId);
        this.lockName = lockName;
        this.transactionId = transactionId;
    }

    public DeleteOperation(String name, String lockName, String writeLockName, String transactionId, long threadId) {
        this(name, lockName, transactionId, threadId);
        this.writeLockName = writeLockName;
    }

    @Override
    public void commit(CommandAsyncExecutor commandExecutor) {
        RedissonLock lock;
        RedissonKeys keys = new RedissonKeys(commandExecutor);
        keys.deleteAsync(this.getName());
        if (this.lockName != null) {
            lock = new RedissonTransactionalLock(commandExecutor, this.lockName, this.transactionId);
            lock.unlockAsync();
        }
        if (this.writeLockName != null) {
            lock = new RedissonTransactionalWriteLock(commandExecutor, this.writeLockName, this.transactionId);
            lock.unlockAsync(this.getThreadId());
        }
    }

    @Override
    public void rollback(CommandAsyncExecutor commandExecutor) {
        RedissonLock lock;
        if (this.lockName != null) {
            lock = new RedissonTransactionalLock(commandExecutor, this.lockName, this.transactionId);
            lock.unlockAsync();
        }
        if (this.writeLockName != null) {
            lock = new RedissonTransactionalWriteLock(commandExecutor, this.writeLockName, this.transactionId);
            lock.unlockAsync(this.getThreadId());
        }
    }

    public String getLockName() {
        return this.lockName;
    }
}

