/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.renewal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.redisson.api.RFuture;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.decoder.ContainsDecoder;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.renewal.LockEntry;
import org.redisson.renewal.RenewalTask;

public class LockTask
extends RenewalTask {
    public LockTask(long internalLockLeaseTime, CommandAsyncExecutor executor, int chunkSize) {
        super(internalLockLeaseTime, executor, chunkSize);
    }

    @Override
    CompletionStage<Void> renew(Iterator<String> iter, int chunkSize) {
        if (!iter.hasNext()) {
            return CompletableFuture.completedFuture(null);
        }
        HashMap<String, Long> name2threadId = new HashMap<String, Long>(chunkSize);
        ArrayList<Object> args = new ArrayList<Object>(chunkSize + 1);
        args.add(this.internalLockLeaseTime);
        ArrayList<String> keys = new ArrayList<String>(chunkSize);
        while (iter.hasNext()) {
            String lockName;
            Long threadId;
            String key = iter.next();
            LockEntry entry = (LockEntry)this.name2entry.get(key);
            if (entry == null || (threadId = entry.getFirstThreadId()) == null || (lockName = entry.getLockName(threadId)) == null) continue;
            keys.add(key);
            args.add(lockName);
            name2threadId.put(key, threadId);
            if (keys.size() != chunkSize) continue;
            break;
        }
        if (keys.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        String firstName = (String)keys.get(0);
        RFuture f = this.executor.syncedEval(firstName, LongCodec.INSTANCE, new RedisCommand("EVAL", new ContainsDecoder(keys)), "local result = {} for i = 1, #KEYS, 1 do if (redis.call('hexists', KEYS[i], ARGV[i + 1]) == 1) then redis.call('pexpire', KEYS[i], ARGV[1]); table.insert(result, 1); else table.insert(result, 0); end; end; return result;", new ArrayList<Object>(keys), args.toArray());
        return f.thenCompose(existingNames -> {
            keys.removeAll((Collection<?>)existingNames);
            for (String key : keys) {
                this.cancelExpirationRenewal(key, (Long)name2threadId.get(key));
            }
            return this.renew(iter, chunkSize);
        });
    }

    public void add(String rawName, String lockName, long threadId) {
        LockEntry entry = new LockEntry();
        entry.addThreadId(threadId, lockName);
        this.add(rawName, lockName, threadId, entry);
    }
}

