/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.config;

import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import org.redisson.config.DelayStrategy;

public class FullJitterDelay
implements DelayStrategy {
    private final Duration baseDelay;
    private final Duration maxDelay;

    public FullJitterDelay(Duration baseDelay, Duration maxDelay) {
        Objects.requireNonNull(baseDelay);
        Objects.requireNonNull(maxDelay);
        this.baseDelay = baseDelay;
        this.maxDelay = maxDelay;
    }

    @Override
    public Duration calcDelay(int attempt) {
        long exponentialDelayMs = Math.min(Math.max(this.baseDelay.toMillis() * (1L << Math.min(attempt, 62)), 1L), this.maxDelay.toMillis());
        long jitteredDelayMs = 0L;
        if (exponentialDelayMs != 0L) {
            jitteredDelayMs = ThreadLocalRandom.current().nextLong(0L, exponentialDelayMs + 1L);
        }
        return Duration.ofMillis(jitteredDelayMs);
    }
}

