/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.redisson.BooleanSlotCallback;
import org.redisson.SlotCallback;
import org.redisson.VoidSlotCallback;
import org.redisson.api.RBuckets;
import org.redisson.api.RFuture;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.codec.CompositeCodec;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.connection.decoder.BucketsDecoder;
import org.redisson.connection.decoder.MapGetAllDecoder;
import org.redisson.misc.CompletableFutureWrapper;

public class RedissonBuckets
implements RBuckets {
    protected final Codec codec;
    protected final CommandAsyncExecutor commandExecutor;

    public RedissonBuckets(CommandAsyncExecutor commandExecutor) {
        this(commandExecutor.getServiceManager().getCfg().getCodec(), commandExecutor);
    }

    public RedissonBuckets(Codec codec, CommandAsyncExecutor commandExecutor) {
        this.codec = commandExecutor.getServiceManager().getCodec(codec);
        this.commandExecutor = commandExecutor;
    }

    @Override
    public <V> Map<String, V> get(String ... keys) {
        RFuture<Map<String, V>> future = this.getAsync(keys);
        return this.commandExecutor.get(future);
    }

    @Override
    public boolean trySet(Map<String, ?> buckets) {
        RFuture<Boolean> future = this.trySetAsync(buckets);
        return this.commandExecutor.get(future);
    }

    @Override
    public void set(Map<String, ?> buckets) {
        this.commandExecutor.get(this.setAsync(buckets));
    }

    @Override
    public <V> RFuture<Map<String, V>> getAsync(String ... keys) {
        if (keys.length == 0) {
            return new CompletableFutureWrapper<Map<String, V>>(Collections.emptyMap());
        }
        List<Object> keysList = Arrays.stream(keys).map((? super T k) -> this.commandExecutor.getServiceManager().getNameMapper().map((String)k)).collect(Collectors.toList());
        CompositeCodec commandCodec = new CompositeCodec(StringCodec.INSTANCE, this.codec, this.codec);
        RedisCommand<Map<Object, Object>> command = new RedisCommand<Map<Object, Object>>(RedisCommands.MGET.getName(), new MapGetAllDecoder(keysList, 0));
        return this.commandExecutor.readBatchedAsync(commandCodec, command, new SlotCallback<Map<Object, Object>, Map<String, V>>(){

            @Override
            public Map<String, V> onResult(Collection<Map<Object, Object>> result) {
                return result.stream().flatMap(c -> c.entrySet().stream()).filter(e -> e.getKey() != null && e.getValue() != null).map(e -> {
                    String key = RedissonBuckets.this.commandExecutor.getServiceManager().getNameMapper().unmap((String)e.getKey());
                    return new AbstractMap.SimpleEntry(key, e.getValue());
                }).collect(Collectors.toMap(e -> (String)e.getKey(), e -> e.getValue()));
            }

            @Override
            public RedisCommand<Map<Object, Object>> createCommand(List<Object> keys) {
                return new RedisCommand<Map<Object, Object>>(RedisCommands.MGET.getName(), new BucketsDecoder(keys));
            }
        }, keysList.toArray(new Object[0]));
    }

    @Override
    public RFuture<Boolean> trySetAsync(Map<String, ?> buckets) {
        if (buckets.isEmpty()) {
            return new CompletableFutureWrapper<Boolean>(false);
        }
        final Map<String, ?> mappedBuckets = this.map(buckets);
        return this.commandExecutor.writeBatchedAsync(this.codec, RedisCommands.MSETNX, new BooleanSlotCallback(){

            @Override
            public Object[] createParams(List<Object> keys) {
                ArrayList<Object> params = new ArrayList<Object>(keys.size());
                for (Object key : keys) {
                    params.add(key);
                    try {
                        params.add(RedissonBuckets.this.codec.getValueEncoder().encode(mappedBuckets.get(key)));
                    }
                    catch (IOException e) {
                        throw new IllegalArgumentException(e);
                    }
                }
                return params.toArray();
            }
        }, mappedBuckets.keySet().toArray(new Object[0]));
    }

    private Map<String, ?> map(Map<String, ?> buckets) {
        return buckets.entrySet().stream().collect(Collectors.toMap(e -> this.commandExecutor.getServiceManager().getNameMapper().map((String)e.getKey()), e -> e.getValue()));
    }

    @Override
    public RFuture<Void> setAsync(Map<String, ?> buckets) {
        if (buckets.isEmpty()) {
            return new CompletableFutureWrapper<Void>((Void)null);
        }
        final Map<String, ?> mappedBuckets = this.map(buckets);
        return this.commandExecutor.writeBatchedAsync(this.codec, RedisCommands.MSET, new VoidSlotCallback(){

            @Override
            public Object[] createParams(List<Object> keys) {
                ArrayList<Object> params = new ArrayList<Object>(keys.size());
                for (Object key : keys) {
                    params.add(key);
                    try {
                        params.add(RedissonBuckets.this.codec.getValueEncoder().encode(mappedBuckets.get(key)));
                    }
                    catch (IOException e) {
                        throw new IllegalArgumentException(e);
                    }
                }
                return params.toArray();
            }
        }, mappedBuckets.keySet().toArray(new Object[0]));
    }
}

