/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.util.Set;
import org.redisson.api.listener.MessageListener;
import org.redisson.client.RedisPubSubListener;
import org.redisson.client.protocol.pubsub.PubSubType;

public class PubSubMessageListener<V>
implements RedisPubSubListener<Object> {
    private final MessageListener<V> listener;
    private final Set<String> names;
    private final Class<V> type;
    private Runnable callback;

    public PubSubMessageListener(Class<V> type, MessageListener<V> listener, Set<String> names) {
        this.type = type;
        this.listener = listener;
        this.names = names;
    }

    public PubSubMessageListener(Class<V> type, MessageListener<V> listener, Set<String> names, Runnable callback) {
        this.type = type;
        this.listener = listener;
        this.names = names;
        this.callback = callback;
    }

    public MessageListener<V> getListener() {
        return this.listener;
    }

    @Override
    public void onMessage(CharSequence channel, Object message) {
        if (this.names.contains(channel.toString()) && this.type.isInstance(message)) {
            this.listener.onMessage(channel, message);
            if (this.callback != null) {
                this.callback.run();
            }
        }
    }

    @Override
    public void onPatternMessage(CharSequence pattern, CharSequence channel, Object message) {
        if (this.names.contains(pattern.toString()) && this.type.isInstance(message)) {
            this.listener.onMessage(channel, message);
            if (this.callback != null) {
                this.callback.run();
            }
        }
    }

    @Override
    public void onStatus(PubSubType type, CharSequence channel) {
    }
}

