/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

final class Traces {
    Traces() {
    }

    static String stackTraceToString(StackTraceElement[] stackTraceElements) {
        StringBuilder sb = new StringBuilder();
        for (StackTraceElement e : stackTraceElements) {
            String row = e.toString();
            sb.append("\t").append(row).append("\n");
        }
        return sb.toString();
    }

    static boolean shouldSanitize(String stackTraceRow) {
        return stackTraceRow.trim().isEmpty() || stackTraceRow.contains("java.util.function") || stackTraceRow.contains("reactor.core.publisher.Mono.onAssembly") || stackTraceRow.contains("reactor.core.publisher.Flux.onAssembly") || stackTraceRow.contains("reactor.core.publisher.ParallelFlux.onAssembly") || stackTraceRow.contains("reactor.core.publisher.SignalLogger") || stackTraceRow.contains("FluxOnAssembly.") || stackTraceRow.contains("MonoOnAssembly.") || stackTraceRow.contains("MonoCallableOnAssembly.") || stackTraceRow.contains("FluxCallableOnAssembly.") || stackTraceRow.contains("OnOperatorDebug") || stackTraceRow.contains("reactor.core.publisher.Hooks") || stackTraceRow.contains(".junit.runner") || stackTraceRow.contains(".junit4.runner") || stackTraceRow.contains(".junit.internal") || stackTraceRow.contains("org.gradle.") || stackTraceRow.contains("sun.reflect") || stackTraceRow.contains("useTraceAssembly") || stackTraceRow.contains("java.lang.Thread.") || stackTraceRow.contains("ThreadPoolExecutor") || stackTraceRow.contains("org.apache.catalina.") || stackTraceRow.contains("org.apache.tomcat.") || stackTraceRow.contains("com.intellij.") || stackTraceRow.contains("java.lang.reflect");
    }

    static String stackTraceToSanitizedString(StackTraceElement[] stackTraceElements) {
        StringBuilder sb = new StringBuilder();
        for (StackTraceElement e : stackTraceElements) {
            String row = e.toString();
            if (e.getLineNumber() <= 1 || Traces.shouldSanitize(row)) continue;
            sb.append("\t").append(row).append("\n");
        }
        return sb.toString();
    }

    static String extractOperatorAssemblyInformation(String source) {
        return Traces.extractOperatorAssemblyInformation(source, false);
    }

    static String extractOperatorAssemblyInformation(String source, boolean skipFirst) {
        String userCodeLine;
        String apiLine;
        int i;
        String[] uncleanTraces = source.split("\n");
        List traces = Stream.of(uncleanTraces).map(String::trim).filter(s -> !s.isEmpty()).skip(skipFirst ? 1L : 0L).collect(Collectors.toList());
        if (traces.isEmpty()) {
            return "[no operator assembly information]";
        }
        for (i = 0; i < traces.size() && ((String)traces.get(i)).startsWith("reactor.core.publisher") && !((String)traces.get(i)).contains("Test"); ++i) {
        }
        if (i == 0) {
            apiLine = "";
            userCodeLine = (String)traces.get(0);
        } else if (i == traces.size()) {
            apiLine = "";
            userCodeLine = ((String)traces.get(i - 1)).replaceFirst("reactor.core.publisher.", "");
        } else {
            apiLine = (String)traces.get(i - 1);
            userCodeLine = (String)traces.get(i);
        }
        if (apiLine.isEmpty()) {
            return userCodeLine;
        }
        int linePartIndex = apiLine.indexOf(40);
        if (linePartIndex > 0) {
            apiLine = apiLine.substring(0, linePartIndex);
        }
        apiLine = apiLine.replaceFirst("reactor.core.publisher.", "");
        return apiLine + " \u21e2 " + userCodeLine;
    }
}

