/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.reactive;

import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.LongConsumer;
import org.reactivestreams.Publisher;
import org.redisson.RedissonKeys;
import org.redisson.client.RedisClient;
import org.redisson.client.protocol.decoder.ListScanResult;
import org.redisson.connection.MasterSlaveEntry;
import org.redisson.reactive.CommandReactiveService;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;

public class RedissonKeysReactive {
    private final CommandReactiveService commandExecutor;
    private final RedissonKeys instance;

    public RedissonKeysReactive(CommandReactiveService commandExecutor) {
        this.instance = new RedissonKeys(commandExecutor);
        this.commandExecutor = commandExecutor;
    }

    public Publisher<String> getKeysByPattern(String pattern) {
        return this.getKeysByPattern(pattern, 10);
    }

    public Publisher<String> getKeysByPattern(String pattern, int count) {
        ArrayList<Publisher<String>> publishers = new ArrayList<Publisher<String>>();
        for (MasterSlaveEntry entry : this.commandExecutor.getConnectionManager().getEntrySet()) {
            publishers.add(this.createKeysIterator(entry, pattern, count));
        }
        return Flux.merge(publishers);
    }

    private Publisher<String> createKeysIterator(final MasterSlaveEntry entry, final String pattern, final int count) {
        return Flux.create(new Consumer<FluxSink<String>>(){

            @Override
            public void accept(final FluxSink<String> emitter) {
                emitter.onRequest(new LongConsumer(){
                    private RedisClient client;
                    private List<String> firstValues;
                    private long nextIterPos;
                    private long currentIndex;

                    @Override
                    public void accept(long value) {
                        this.currentIndex = value;
                        this.nextValues(emitter);
                    }

                    protected void nextValues(final FluxSink<String> emitter2) {
                        RedissonKeysReactive.this.instance.scanIteratorAsync(this.client, entry, this.nextIterPos, pattern, count).addListener(new FutureListener<ListScanResult<Object>>(){

                            @Override
                            public void operationComplete(Future<ListScanResult<Object>> future) throws Exception {
                                if (!future.isSuccess()) {
                                    emitter2.error(future.cause());
                                    return;
                                }
                                ListScanResult res = (ListScanResult)future.get();
                                client = res.getRedisClient();
                                long prevIterPos = nextIterPos;
                                if (nextIterPos == 0L && firstValues == null) {
                                    firstValues = (List)res.getValues();
                                } else if (res.getValues().equals(firstValues)) {
                                    emitter2.complete();
                                    currentIndex = 0L;
                                    return;
                                }
                                nextIterPos = res.getPos();
                                if (prevIterPos == nextIterPos) {
                                    nextIterPos = -1L;
                                }
                                for (Object val : res.getValues()) {
                                    emitter2.next((String)val);
                                    currentIndex--;
                                    if (currentIndex != 0L) continue;
                                    emitter2.complete();
                                    return;
                                }
                                if (nextIterPos == -1L) {
                                    emitter2.complete();
                                    currentIndex = 0L;
                                }
                                if (currentIndex == 0L) {
                                    return;
                                }
                                this.nextValues(emitter2);
                            }
                        });
                    }
                });
            }
        });
    }
}

