/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.Flowable;
import io.reactivex.FlowableSubscriber;
import io.reactivex.exceptions.CompositeException;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.BiPredicate;
import io.reactivex.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.internal.subscriptions.SubscriptionArbiter;
import java.util.concurrent.atomic.AtomicInteger;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableRetryBiPredicate<T>
extends AbstractFlowableWithUpstream<T, T> {
    final BiPredicate<? super Integer, ? super Throwable> predicate;

    public FlowableRetryBiPredicate(Flowable<T> source, BiPredicate<? super Integer, ? super Throwable> predicate) {
        super(source);
        this.predicate = predicate;
    }

    @Override
    public void subscribeActual(Subscriber<? super T> s) {
        SubscriptionArbiter sa = new SubscriptionArbiter();
        s.onSubscribe(sa);
        RetryBiSubscriber<T> rs = new RetryBiSubscriber<T>(s, this.predicate, sa, this.source);
        rs.subscribeNext();
    }

    static final class RetryBiSubscriber<T>
    extends AtomicInteger
    implements FlowableSubscriber<T> {
        private static final long serialVersionUID = -7098360935104053232L;
        final Subscriber<? super T> actual;
        final SubscriptionArbiter sa;
        final Publisher<? extends T> source;
        final BiPredicate<? super Integer, ? super Throwable> predicate;
        int retries;
        long produced;

        RetryBiSubscriber(Subscriber<? super T> actual, BiPredicate<? super Integer, ? super Throwable> predicate, SubscriptionArbiter sa, Publisher<? extends T> source) {
            this.actual = actual;
            this.sa = sa;
            this.source = source;
            this.predicate = predicate;
        }

        @Override
        public void onSubscribe(Subscription s) {
            this.sa.setSubscription(s);
        }

        @Override
        public void onNext(T t) {
            ++this.produced;
            this.actual.onNext(t);
        }

        @Override
        public void onError(Throwable t) {
            boolean b;
            try {
                b = this.predicate.test((Integer)(++this.retries), t);
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this.actual.onError(new CompositeException(t, e));
                return;
            }
            if (!b) {
                this.actual.onError(t);
                return;
            }
            this.subscribeNext();
        }

        @Override
        public void onComplete() {
            this.actual.onComplete();
        }

        void subscribeNext() {
            block3: {
                if (this.getAndIncrement() != 0) break block3;
                int missed = 1;
                do {
                    if (this.sa.isCancelled()) {
                        return;
                    }
                    long p = this.produced;
                    if (p != 0L) {
                        this.produced = 0L;
                        this.sa.produced(p);
                    }
                    this.source.subscribe(this);
                } while ((missed = this.addAndGet(-missed)) != 0);
            }
        }
    }
}

