/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.scheduler;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import reactor.core.Disposable;
import reactor.core.Exceptions;
import reactor.core.Scannable;
import reactor.core.scheduler.ExecutorServiceWorker;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

final class DelegateServiceScheduler
implements Scheduler,
Scannable {
    final ScheduledExecutorService executor;

    DelegateServiceScheduler(ExecutorService executorService) {
        ScheduledExecutorService exec = DelegateServiceScheduler.convert(executorService);
        this.executor = Schedulers.decorateExecutorService("ExecutorService", () -> exec);
    }

    @Override
    public Scheduler.Worker createWorker() {
        return new ExecutorServiceWorker(this.executor);
    }

    @Override
    public Disposable schedule(Runnable task) {
        return Schedulers.directSchedule(this.executor, task, 0L, TimeUnit.MILLISECONDS);
    }

    @Override
    public Disposable schedule(Runnable task, long delay, TimeUnit unit) {
        return Schedulers.directSchedule(this.executor, task, delay, unit);
    }

    @Override
    public Disposable schedulePeriodically(Runnable task, long initialDelay, long period, TimeUnit unit) {
        return Schedulers.directSchedulePeriodically(this.executor, task, initialDelay, period, unit);
    }

    @Override
    public boolean isDisposed() {
        return this.executor.isShutdown();
    }

    @Override
    public void dispose() {
        this.executor.shutdownNow();
    }

    static ScheduledExecutorService convert(ExecutorService executor) {
        if (executor instanceof ScheduledExecutorService) {
            return (ScheduledExecutorService)executor;
        }
        return new UnsupportedScheduledExecutorService(executor);
    }

    @Override
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.TERMINATED || key == Scannable.Attr.CANCELLED) {
            return this.isDisposed();
        }
        if (key == Scannable.Attr.NAME) {
            return "fromExecutorService(" + this.executor + ")";
        }
        return Schedulers.scanExecutor(this.executor, key);
    }

    static final class UnsupportedScheduledExecutorService
    implements ScheduledExecutorService,
    Supplier<ExecutorService> {
        final ExecutorService exec;

        UnsupportedScheduledExecutorService(ExecutorService exec) {
            this.exec = exec;
        }

        @Override
        public ExecutorService get() {
            return this.exec;
        }

        @Override
        public void shutdown() {
            this.exec.shutdown();
        }

        @Override
        @NotNull
        public List<Runnable> shutdownNow() {
            return this.exec.shutdownNow();
        }

        @Override
        public boolean isShutdown() {
            return this.exec.isShutdown();
        }

        @Override
        public boolean isTerminated() {
            return this.exec.isTerminated();
        }

        @Override
        public boolean awaitTermination(long timeout, @NotNull TimeUnit unit) throws InterruptedException {
            return this.exec.awaitTermination(timeout, unit);
        }

        @Override
        @NotNull
        public <T> Future<T> submit(@NotNull Callable<T> task) {
            return this.exec.submit(task);
        }

        @Override
        @NotNull
        public <T> Future<T> submit(@NotNull Runnable task, T result) {
            return this.exec.submit(task, result);
        }

        @Override
        @NotNull
        public Future<?> submit(@NotNull Runnable task) {
            return this.exec.submit(task);
        }

        @Override
        @NotNull
        public <T> List<Future<T>> invokeAll(@NotNull Collection<? extends Callable<T>> tasks) throws InterruptedException {
            return this.exec.invokeAll(tasks);
        }

        @Override
        @NotNull
        public <T> List<Future<T>> invokeAll(@NotNull Collection<? extends Callable<T>> tasks, long timeout, @NotNull TimeUnit unit) throws InterruptedException {
            return this.exec.invokeAll(tasks, timeout, unit);
        }

        @Override
        @NotNull
        public <T> T invokeAny(@NotNull Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
            return this.exec.invokeAny(tasks);
        }

        @Override
        public <T> T invokeAny(@NotNull Collection<? extends Callable<T>> tasks, long timeout, @NotNull TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.exec.invokeAny(tasks, timeout, unit);
        }

        @Override
        public void execute(@NotNull Runnable command) {
            this.exec.execute(command);
        }

        @Override
        @NotNull
        public ScheduledFuture<?> schedule(@NotNull Runnable command, long delay, @NotNull TimeUnit unit) {
            throw Exceptions.failWithRejectedNotTimeCapable();
        }

        @Override
        @NotNull
        public <V> ScheduledFuture<V> schedule(@NotNull Callable<V> callable, long delay, @NotNull TimeUnit unit) {
            throw Exceptions.failWithRejectedNotTimeCapable();
        }

        @Override
        @NotNull
        public ScheduledFuture<?> scheduleAtFixedRate(@NotNull Runnable command, long initialDelay, long period, @NotNull TimeUnit unit) {
            throw Exceptions.failWithRejectedNotTimeCapable();
        }

        @Override
        @NotNull
        public ScheduledFuture<?> scheduleWithFixedDelay(@NotNull Runnable command, long initialDelay, long delay, @NotNull TimeUnit unit) {
            throw Exceptions.failWithRejectedNotTimeCapable();
        }

        public String toString() {
            return this.exec.toString();
        }
    }
}

