/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.jcache;

import io.netty.buffer.ByteBuf;
import io.netty.util.internal.PlatformDependent;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import org.redisson.client.codec.Codec;
import org.redisson.client.handler.State;
import org.redisson.client.protocol.Decoder;
import org.redisson.client.protocol.Encoder;

public class JCacheEventCodec
implements Codec {
    private final Codec codec;
    private final boolean sync;
    private final Decoder<Object> decoder = new Decoder<Object>(){

        @Override
        public Object decode(ByteBuf buf, State state) throws IOException {
            ArrayList<Object> result = new ArrayList<Object>();
            int keyLen = PlatformDependent.isWindows() ? buf.readIntLE() : (int)buf.readLongLE();
            ByteBuf keyBuf = buf.readSlice(keyLen);
            Object key = JCacheEventCodec.this.codec.getMapKeyDecoder().decode(keyBuf, state);
            result.add(key);
            int valueLen = PlatformDependent.isWindows() ? buf.readIntLE() : (int)buf.readLongLE();
            ByteBuf valueBuf = buf.readSlice(valueLen);
            Object value = JCacheEventCodec.this.codec.getMapValueDecoder().decode(valueBuf, state);
            result.add(value);
            if (JCacheEventCodec.this.sync) {
                double syncId = buf.order(ByteOrder.LITTLE_ENDIAN).readDouble();
                result.add(syncId);
            }
            return result;
        }
    };

    public JCacheEventCodec(Codec codec, boolean sync) {
        this.codec = codec;
        this.sync = sync;
    }

    @Override
    public Decoder<Object> getMapValueDecoder() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Encoder getMapValueEncoder() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Decoder<Object> getMapKeyDecoder() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Encoder getMapKeyEncoder() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Decoder<Object> getValueDecoder() {
        return this.decoder;
    }

    @Override
    public Encoder getValueEncoder() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.getClass().getClassLoader();
    }
}

