/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.reactive;

import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import org.redisson.RedissonBlockingQueue;
import org.redisson.api.RBlockingQueueAsync;
import org.redisson.api.RBlockingQueueReactive;
import org.redisson.api.RFuture;
import org.redisson.client.codec.Codec;
import org.redisson.command.CommandReactiveExecutor;
import org.redisson.reactive.RedissonQueueReactive;

public class RedissonBlockingQueueReactive<V>
extends RedissonQueueReactive<V>
implements RBlockingQueueReactive<V> {
    private final RBlockingQueueAsync<V> instance;

    public RedissonBlockingQueueReactive(CommandReactiveExecutor commandExecutor, String name) {
        super(commandExecutor, name);
        this.instance = new RedissonBlockingQueue(commandExecutor, name, null);
    }

    public RedissonBlockingQueueReactive(Codec codec, CommandReactiveExecutor commandExecutor, String name) {
        super(codec, commandExecutor, name);
        this.instance = new RedissonBlockingQueue(codec, commandExecutor, name, null);
    }

    @Override
    public Publisher<Integer> put(V e) {
        return this.offer(e);
    }

    @Override
    public Publisher<V> take() {
        return this.reactive(new Supplier<RFuture<V>>(){

            @Override
            public RFuture<V> get() {
                return RedissonBlockingQueueReactive.this.instance.takeAsync();
            }
        });
    }

    @Override
    public Publisher<V> poll(final long timeout, final TimeUnit unit) {
        return this.reactive(new Supplier<RFuture<V>>(){

            @Override
            public RFuture<V> get() {
                return RedissonBlockingQueueReactive.this.instance.pollAsync(timeout, unit);
            }
        });
    }

    @Override
    public Publisher<V> pollFromAny(final long timeout, final TimeUnit unit, final String ... queueNames) {
        return this.reactive(new Supplier<RFuture<V>>(){

            @Override
            public RFuture<V> get() {
                return RedissonBlockingQueueReactive.this.instance.pollFromAnyAsync(timeout, unit, queueNames);
            }
        });
    }

    @Override
    public Publisher<V> pollLastAndOfferFirstTo(final String queueName, final long timeout, final TimeUnit unit) {
        return this.reactive(new Supplier<RFuture<V>>(){

            @Override
            public RFuture<V> get() {
                return RedissonBlockingQueueReactive.this.instance.pollLastAndOfferFirstToAsync(queueName, timeout, unit);
            }
        });
    }

    @Override
    public Publisher<Integer> drainTo(final Collection<? super V> c) {
        return this.reactive(new Supplier<RFuture<Integer>>(){

            @Override
            public RFuture<Integer> get() {
                return RedissonBlockingQueueReactive.this.instance.drainToAsync(c);
            }
        });
    }

    @Override
    public Publisher<Integer> drainTo(final Collection<? super V> c, final int maxElements) {
        return this.reactive(new Supplier<RFuture<Integer>>(){

            @Override
            public RFuture<Integer> get() {
                return RedissonBlockingQueueReactive.this.instance.drainToAsync(c, maxElements);
            }
        });
    }
}

