/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.client.handler;

import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.util.AttributeKey;
import io.netty.util.internal.PlatformDependent;
import java.io.IOException;
import java.util.List;
import java.util.Queue;
import java.util.regex.Pattern;
import org.redisson.client.ChannelName;
import org.redisson.client.WriteRedisConnectionException;
import org.redisson.client.handler.CommandPubSubDecoder;
import org.redisson.client.protocol.CommandData;
import org.redisson.client.protocol.QueueCommand;
import org.redisson.client.protocol.QueueCommandHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandsQueue
extends ChannelDuplexHandler {
    private static final Logger log = LoggerFactory.getLogger(CommandsQueue.class);
    private static final Pattern IGNORABLE_ERROR_MESSAGE = Pattern.compile("^.*(?:connection.*(?:reset|closed|abort|broken)|broken.*pipe).*$", 2);
    public static final AttributeKey<QueueCommand> CURRENT_COMMAND = AttributeKey.valueOf("promise");
    private final Queue<QueueCommandHolder> queue = PlatformDependent.newMpscQueue();
    private final ChannelFutureListener listener = new ChannelFutureListener(){

        @Override
        public void operationComplete(ChannelFuture future) throws Exception {
            if (!future.isSuccess() && future.channel().isActive()) {
                CommandsQueue.this.sendNextCommand(future.channel());
            }
        }
    };

    public void sendNextCommand(Channel channel) {
        channel.attr(CURRENT_COMMAND).set(null);
        this.queue.poll();
        this.sendData(channel);
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        QueueCommandHolder command;
        while ((command = this.queue.poll()) != null) {
            command.getChannelPromise().tryFailure(new WriteRedisConnectionException("Can't write command: " + command.getCommand() + " to channel: " + ctx.channel()));
        }
        super.channelInactive(ctx);
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof QueueCommand) {
            QueueCommand data = (QueueCommand)msg;
            QueueCommandHolder holder = this.queue.peek();
            if (holder != null && holder.getCommand() == data) {
                super.write(ctx, msg, promise);
            } else {
                this.queue.add(new QueueCommandHolder(data, promise));
                this.sendData(ctx.channel());
            }
        } else {
            super.write(ctx, msg, promise);
        }
    }

    private void sendData(Channel ch) {
        QueueCommandHolder command = this.queue.peek();
        if (command != null && command.trySend()) {
            QueueCommand data = command.getCommand();
            List<CommandData<Object, Object>> pubSubOps = data.getPubSubOperations();
            if (!pubSubOps.isEmpty()) {
                for (CommandData<Object, Object> cd : pubSubOps) {
                    for (Object channel : cd.getParams()) {
                        ch.pipeline().get(CommandPubSubDecoder.class).addPubSubCommand((ChannelName)channel, cd);
                    }
                }
            } else {
                ch.attr(CURRENT_COMMAND).set(data);
            }
            command.getChannelPromise().addListener(this.listener);
            ch.writeAndFlush(data, command.getChannelPromise());
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        String message;
        if (cause instanceof IOException && IGNORABLE_ERROR_MESSAGE.matcher(message = String.valueOf(cause.getMessage()).toLowerCase()).matches()) {
            return;
        }
        log.error("Exception occured. Channel: " + ctx.channel(), cause);
    }
}

