/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.serialization;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.io.NotActiveException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectInputValidation;
import java.io.ObjectStreamClass;
import java.io.OptionalDataException;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.nustaq.serialization.FSTClazzInfo;
import org.nustaq.serialization.FSTClazzInfoRegistry;
import org.nustaq.serialization.FSTConfiguration;
import org.nustaq.serialization.FSTDecoder;
import org.nustaq.serialization.FSTObjectRegistry;
import org.nustaq.serialization.FSTObjectSerializer;
import org.nustaq.serialization.VersionConflictListener;
import org.nustaq.serialization.coders.Unknown;
import org.nustaq.serialization.minbin.MBObject;
import org.nustaq.serialization.util.FSTUtil;

public class FSTObjectInput
implements ObjectInput {
    public static boolean REGISTER_ENUMS_READ = false;
    public static ByteArrayInputStream emptyStream = new ByteArrayInputStream(new byte[0]);
    protected FSTDecoder codec;
    protected FSTObjectRegistry objects;
    protected Stack<String> debugStack;
    protected int curDepth;
    protected ArrayList<CallbackEntry> callbacks;
    protected boolean ignoreAnnotations;
    protected FSTClazzInfoRegistry clInfoRegistry;
    protected ConditionalCallback conditionalCallback;
    protected int readExternalReadAHead = 8000;
    protected VersionConflictListener versionConflictListener;
    protected FSTConfiguration conf;
    protected boolean isCrossPlatform;
    protected FSTClazzInfo.FSTFieldInfo infoCache;
    protected boolean closed = false;
    protected MyObjectStream fakeWrapper;

    public FSTConfiguration getConf() {
        return this.conf;
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        this.getCodec().readPlainBytes(b, off, len);
    }

    @Override
    public int skipBytes(int n) throws IOException {
        this.getCodec().skip(n);
        return n;
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.getCodec().readFByte() != 0;
    }

    @Override
    public byte readByte() throws IOException {
        return this.getCodec().readFByte();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.getCodec().readFByte() + 256 & 0xFF;
    }

    @Override
    public short readShort() throws IOException {
        return this.getCodec().readFShort();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.readShort() + 65536 & 0xFFFF;
    }

    @Override
    public char readChar() throws IOException {
        return this.getCodec().readFChar();
    }

    @Override
    public int readInt() throws IOException {
        return this.getCodec().readFInt();
    }

    @Override
    public long readLong() throws IOException {
        return this.getCodec().readFLong();
    }

    @Override
    public float readFloat() throws IOException {
        return this.getCodec().readFFloat();
    }

    @Override
    public double readDouble() throws IOException {
        return this.getCodec().readFDouble();
    }

    @Override
    public String readLine() throws IOException {
        throw new RuntimeException("not implemented");
    }

    @Override
    public String readUTF() throws IOException {
        return this.getCodec().readStringUTF();
    }

    public FSTDecoder getCodec() {
        return this.codec;
    }

    protected void setCodec(FSTDecoder codec) {
        this.codec = codec;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public FSTObjectInput() throws IOException {
        this(emptyStream, FSTConfiguration.getDefaultConfiguration());
    }

    public FSTObjectInput(FSTConfiguration conf) {
        this(emptyStream, conf);
    }

    public FSTObjectInput(InputStream in) throws IOException {
        this(in, FSTConfiguration.getDefaultConfiguration());
    }

    public FSTObjectInput(InputStream in, FSTConfiguration conf) {
        this.setCodec(conf.createStreamDecoder());
        this.getCodec().setInputStream(in);
        this.isCrossPlatform = conf.isCrossPlatform();
        this.initRegistries(conf);
        this.conf = conf;
    }

    public Class getClassForName(String name) throws ClassNotFoundException {
        return this.getCodec().classForName(name);
    }

    protected void initRegistries(FSTConfiguration conf) {
        this.ignoreAnnotations = conf.getCLInfoRegistry().isIgnoreAnnotations();
        this.clInfoRegistry = conf.getCLInfoRegistry();
        this.objects = (FSTObjectRegistry)conf.getCachedObject(FSTObjectRegistry.class);
        if (this.objects == null) {
            this.objects = new FSTObjectRegistry(conf);
        } else {
            this.objects.clearForRead(conf);
        }
    }

    public ConditionalCallback getConditionalCallback() {
        return this.conditionalCallback;
    }

    public void setConditionalCallback(ConditionalCallback conditionalCallback) {
        this.conditionalCallback = conditionalCallback;
    }

    public int getReadExternalReadAHead() {
        return this.readExternalReadAHead;
    }

    public void setReadExternalReadAHead(int readExternalReadAHead) {
        this.readExternalReadAHead = readExternalReadAHead;
    }

    @Override
    public Object readObject() throws ClassNotFoundException, IOException {
        try {
            return this.readObject(null);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public int read() throws IOException {
        return this.getCodec().readIntByte();
    }

    @Override
    public int read(byte[] b) throws IOException {
        this.getCodec().readPlainBytes(b, 0, b.length);
        return b.length;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.getCodec().readPlainBytes(b, off, len);
        return b.length;
    }

    @Override
    public long skip(long n) throws IOException {
        this.getCodec().skip((int)n);
        return n;
    }

    @Override
    public int available() throws IOException {
        return this.getCodec().available();
    }

    protected void processValidation() throws InvalidObjectException {
        if (this.callbacks == null) {
            return;
        }
        Collections.sort(this.callbacks, new Comparator<CallbackEntry>(){

            @Override
            public int compare(CallbackEntry o1, CallbackEntry o2) {
                return o2.prio - o1.prio;
            }
        });
        for (int i = 0; i < this.callbacks.size(); ++i) {
            CallbackEntry callbackEntry = this.callbacks.get(i);
            try {
                callbackEntry.cb.validateObject();
                continue;
            }
            catch (Exception ex) {
                FSTUtil.rethrow(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object readObject(Class ... possibles) throws Exception {
        ++this.curDepth;
        if (this.isCrossPlatform) {
            return this.readObjectInternal(null);
        }
        try {
            if (possibles != null && possibles.length > 1) {
                for (int i = 0; i < possibles.length; ++i) {
                    Class possible = possibles[i];
                    this.getCodec().registerClass(possible);
                }
            }
            Object res = this.readObjectInternal(possibles);
            this.processValidation();
            Object object = res;
            return object;
        }
        catch (Throwable th) {
            FSTUtil.rethrow(th);
        }
        finally {
            --this.curDepth;
        }
        return null;
    }

    public Object readObjectInternal(Class ... expected) throws ClassNotFoundException, IOException, IllegalAccessException, InstantiationException {
        try {
            FSTClazzInfo.FSTFieldInfo info = this.infoCache;
            this.infoCache = null;
            if (info == null) {
                info = new FSTClazzInfo.FSTFieldInfo(expected, null, this.ignoreAnnotations);
            } else {
                info.possibleClasses = expected;
            }
            Object res = this.readObjectWithHeader(info);
            this.infoCache = info;
            return res;
        }
        catch (Throwable t) {
            FSTUtil.rethrow(t);
            return null;
        }
    }

    public Object readObjectWithHeader(FSTClazzInfo.FSTFieldInfo referencee) throws Exception {
        Class c;
        FSTClazzInfo clzSerInfo;
        int readPos = this.getCodec().getInputPos();
        byte code = this.getCodec().readObjectHeaderTag();
        if (code == 0) {
            clzSerInfo = this.readClass();
            c = clzSerInfo.getClazz();
            if (c.isArray()) {
                return this.readArrayNoHeader(referencee, readPos, c);
            }
        } else if (code == -3) {
            c = referencee.getType();
            clzSerInfo = this.getClazzInfo(c, referencee);
        } else if (code >= 1) {
            try {
                c = referencee.getPossibleClasses()[code - 1];
                clzSerInfo = this.getClazzInfo(c, referencee);
            }
            catch (Throwable th) {
                clzSerInfo = null;
                c = null;
                FSTUtil.rethrow(th);
            }
        } else {
            Object res = this.instantiateSpecialTag(referencee, readPos, code);
            return res;
        }
        try {
            FSTObjectSerializer ser = clzSerInfo.getSer();
            if (ser != null) {
                Object res = this.instantiateAndReadWithSer(c, ser, clzSerInfo, referencee, readPos);
                this.getCodec().readArrayEnd(clzSerInfo);
                return res;
            }
            Object res = this.instantiateAndReadNoSer(c, clzSerInfo, referencee, readPos);
            return res;
        }
        catch (Exception e) {
            FSTUtil.rethrow(e);
            return null;
        }
    }

    protected Object instantiateSpecialTag(FSTClazzInfo.FSTFieldInfo referencee, int readPos, byte code) throws Exception {
        if (code == -4) {
            String res = this.getCodec().readStringUTF();
            this.objects.registerObjectForRead(res, readPos);
            return res;
        }
        if (code == -9) {
            return this.instantiateBigInt();
        }
        if (code == -1) {
            return null;
        }
        switch (code) {
            case -10: {
                return this.getCodec().readFLong();
            }
            case -17: {
                return Boolean.FALSE;
            }
            case -16: {
                return Boolean.TRUE;
            }
            case -18: {
                return referencee.getOneOf()[this.getCodec().readFByte()];
            }
            case -8: {
                Object directObject = this.getCodec().getDirectObject();
                this.objects.registerObjectForRead(directObject, readPos);
                return directObject;
            }
            case -2: {
                Object directObject = this.getCodec().getDirectObject();
                if (directObject.getClass() == byte[].class && referencee != null && referencee.getType() == boolean[].class) {
                    byte[] ba = (byte[])directObject;
                    boolean[] res = new boolean[ba.length];
                    for (int i = 0; i < res.length; ++i) {
                        res[i] = ba[i] != 0;
                    }
                    directObject = res;
                }
                this.objects.registerObjectForRead(directObject, readPos);
                return directObject;
            }
            case -7: {
                Object res = this.instantiateHandle(referencee);
                this.getCodec().readObjectEnd();
                return res;
            }
            case -5: {
                Object res = this.instantiateArray(referencee, readPos);
                return res;
            }
            case -6: {
                return this.instantiateEnum(referencee, readPos);
            }
        }
        throw new RuntimeException("unknown object tag " + code);
    }

    protected FSTClazzInfo getClazzInfo(Class c, FSTClazzInfo.FSTFieldInfo referencee) {
        FSTClazzInfo clzSerInfo;
        FSTClazzInfo lastInfo = referencee.lastInfo;
        if (lastInfo != null && lastInfo.clazz == c && lastInfo.conf == this.conf) {
            clzSerInfo = lastInfo;
        } else {
            referencee.lastInfo = clzSerInfo = this.clInfoRegistry.getCLInfo(c, this.conf);
        }
        return clzSerInfo;
    }

    protected Object instantiateHandle(FSTClazzInfo.FSTFieldInfo referencee) throws IOException {
        int handle = this.getCodec().readFInt();
        Object res = this.objects.getReadRegisteredObject(handle);
        if (res == null) {
            throw new IOException("unable to ressolve handle " + handle + " " + referencee.getDesc() + " " + this.getCodec().getInputPos());
        }
        return res;
    }

    protected Object instantiateArray(FSTClazzInfo.FSTFieldInfo referencee, int readPos) throws Exception {
        Object res = this.readArray(referencee, readPos);
        return res;
    }

    protected Object instantiateEnum(FSTClazzInfo.FSTFieldInfo referencee, int readPos) throws IOException, ClassNotFoundException {
        FSTClazzInfo clzSerInfo = this.readClass();
        Class c = clzSerInfo.getClazz();
        int ordinal = this.getCodec().readFInt();
        Object[] enumConstants = clzSerInfo.getEnumConstants();
        if (enumConstants == null) {
            return null;
        }
        Object res = enumConstants[ordinal];
        if (REGISTER_ENUMS_READ && !referencee.isFlat()) {
            this.objects.registerObjectForRead(res, readPos);
        }
        return res;
    }

    protected Object instantiateBigInt() throws IOException {
        int val = this.getCodec().readFInt();
        return val;
    }

    protected Object instantiateAndReadWithSer(Class c, FSTObjectSerializer ser, FSTClazzInfo clzSerInfo, FSTClazzInfo.FSTFieldInfo referencee, int readPos) throws Exception {
        boolean serInstance = false;
        Object newObj = ser.instantiate(c, this, clzSerInfo, referencee, readPos);
        if (newObj == null) {
            newObj = clzSerInfo.newInstance(this.getCodec().isMapBased());
        } else {
            serInstance = true;
        }
        if (newObj == null) {
            throw new IOException(referencee.getDesc() + ":Failed to instantiate '" + c.getName() + "'. Register a custom serializer implementing instantiate or define empty constructor..");
        }
        if (newObj == "REALLY_NULL") {
            newObj = null;
        } else {
            if (newObj.getClass() != c && ser == null) {
                c = newObj.getClass();
                clzSerInfo = this.clInfoRegistry.getCLInfo(c, this.conf);
            }
            if (!(referencee.isFlat() || clzSerInfo.isFlat() || ser.alwaysCopy())) {
                this.objects.registerObjectForRead(newObj, readPos);
            }
            if (!serInstance) {
                ser.readObject(this, newObj, clzSerInfo, referencee);
            }
        }
        this.getCodec().consumeEndMarker();
        return newObj;
    }

    protected Object instantiateAndReadNoSer(Class c, FSTClazzInfo clzSerInfo, FSTClazzInfo.FSTFieldInfo referencee, int readPos) throws Exception {
        boolean needsRefLookup;
        Object newObj = clzSerInfo.newInstance(this.getCodec().isMapBased());
        if (newObj == null) {
            throw new IOException(referencee.getDesc() + ":Failed to instantiate '" + c.getName() + "'. Register a custom serializer implementing instantiate or define empty constructor.");
        }
        boolean bl = needsRefLookup = this.conf.shareReferences && !referencee.isFlat() && !clzSerInfo.isFlat();
        if (needsRefLookup) {
            this.objects.registerObjectForRead(newObj, readPos);
        }
        if (clzSerInfo.isExternalizable()) {
            int tmp = readPos;
            this.getCodec().ensureReadAhead(this.readExternalReadAHead);
            ((Externalizable)newObj).readExternal(this);
            this.getCodec().readExternalEnd();
            if (clzSerInfo.getReadResolveMethod() != null) {
                Object prevNew = newObj;
                if ((newObj = this.handleReadRessolve(clzSerInfo, newObj)) != prevNew && needsRefLookup) {
                    this.objects.replace(prevNew, newObj, tmp);
                }
            }
        } else if (clzSerInfo.useCompatibleMode()) {
            Object replaced = this.readObjectCompatible(referencee, clzSerInfo, newObj);
            if (replaced != null && replaced != newObj) {
                this.objects.replace(newObj, replaced, readPos);
                newObj = replaced;
            }
        } else {
            FSTClazzInfo.FSTFieldInfo[] fieldInfo = clzSerInfo.getFieldInfo();
            this.readObjectFields(referencee, clzSerInfo, fieldInfo, newObj, 0, 0);
        }
        return newObj;
    }

    protected Object readObjectCompatible(FSTClazzInfo.FSTFieldInfo referencee, FSTClazzInfo serializationInfo, Object newObj) throws Exception {
        Class cl = serializationInfo.getClazz();
        this.readObjectCompatibleRecursive(referencee, newObj, serializationInfo, cl);
        if (newObj != null && serializationInfo.getReadResolveMethod() != null) {
            newObj = this.handleReadRessolve(serializationInfo, newObj);
        }
        return newObj;
    }

    protected Object handleReadRessolve(FSTClazzInfo serializationInfo, Object newObj) throws IllegalAccessException {
        Object rep = null;
        try {
            rep = serializationInfo.getReadResolveMethod().invoke(newObj, new Object[0]);
        }
        catch (InvocationTargetException e) {
            FSTUtil.rethrow(e);
        }
        newObj = rep;
        return newObj;
    }

    protected void readObjectCompatibleRecursive(FSTClazzInfo.FSTFieldInfo referencee, Object toRead, FSTClazzInfo serializationInfo, Class cl) throws Exception {
        FSTClazzInfo.FSTCompatibilityInfo fstCompatibilityInfo = serializationInfo.getCompInfo().get(cl);
        if (!Serializable.class.isAssignableFrom(cl)) {
            return;
        }
        this.readObjectCompatibleRecursive(referencee, toRead, serializationInfo, cl.getSuperclass());
        if (fstCompatibilityInfo != null && fstCompatibilityInfo.getReadMethod() != null) {
            try {
                byte tag = this.readByte();
                if (tag == 66) {
                    this.getCodec().moveTo(this.getCodec().getInputPos() - 1);
                }
                ObjectInputStream objectInputStream = this.getObjectInputStream(cl, serializationInfo, referencee, toRead);
                fstCompatibilityInfo.getReadMethod().invoke(toRead, objectInputStream);
                this.fakeWrapper.pop();
            }
            catch (Exception e) {
                FSTUtil.rethrow(e);
            }
        } else if (fstCompatibilityInfo != null) {
            byte tag = this.readByte();
            if (tag == 55 && (tag = this.readByte()) == 77) {
                HashMap fieldMap = (HashMap)this.readObjectInternal(HashMap.class);
                FSTClazzInfo.FSTFieldInfo[] fieldArray = fstCompatibilityInfo.getFieldArray();
                for (int i = 0; i < fieldArray.length; ++i) {
                    FSTClazzInfo.FSTFieldInfo fstFieldInfo = fieldArray[i];
                    Object val = fieldMap.get(fstFieldInfo.getName());
                    if (val == null) continue;
                    fstFieldInfo.setObjectValue(toRead, val);
                }
                return;
            }
            this.readObjectFields(referencee, serializationInfo, fstCompatibilityInfo.getFieldArray(), toRead, 0, 0);
        }
    }

    public void defaultReadObject(FSTClazzInfo.FSTFieldInfo referencee, FSTClazzInfo serializationInfo, Object newObj) {
        try {
            this.readObjectFields(referencee, serializationInfo, serializationInfo.getFieldInfo(), newObj, 0, -1);
        }
        catch (Exception e) {
            FSTUtil.rethrow(e);
        }
    }

    protected void readObjectFields(FSTClazzInfo.FSTFieldInfo referencee, FSTClazzInfo serializationInfo, FSTClazzInfo.FSTFieldInfo[] fieldInfo, Object newObj, int startIndex, int version) throws Exception {
        if (this.getCodec().isMapBased()) {
            this.readFieldsMapBased(referencee, serializationInfo, newObj);
            if (version >= 0 && !(newObj instanceof Unknown)) {
                this.getCodec().readObjectEnd();
            }
            return;
        }
        if (version < 0) {
            version = 0;
        }
        int booleanMask = 0;
        int boolcount = 8;
        int length = fieldInfo.length;
        int conditional = 0;
        for (int i = startIndex; i < length; ++i) {
            try {
                FSTClazzInfo.FSTFieldInfo subInfo = fieldInfo[i];
                if (subInfo.getVersion() > version) {
                    int nextVersion = this.getCodec().readVersionTag();
                    if (nextVersion == 0) {
                        this.oldVersionRead(newObj);
                        return;
                    }
                    if (nextVersion != subInfo.getVersion()) {
                        throw new RuntimeException("read version tag " + nextVersion + " fieldInfo has " + subInfo.getVersion());
                    }
                    this.readObjectFields(referencee, serializationInfo, fieldInfo, newObj, i, nextVersion);
                    return;
                }
                if (subInfo.isPrimitive()) {
                    int integralType = subInfo.getIntegralType();
                    if (integralType == 1) {
                        if (boolcount == 8) {
                            booleanMask = this.getCodec().readFByte() + 256 & 0xFF;
                            boolcount = 0;
                        }
                        boolean val = (booleanMask & 0x80) != 0;
                        booleanMask <<= 1;
                        ++boolcount;
                        subInfo.setBooleanValue(newObj, val);
                        continue;
                    }
                    switch (integralType) {
                        case 2: {
                            subInfo.setByteValue(newObj, this.getCodec().readFByte());
                            break;
                        }
                        case 3: {
                            subInfo.setCharValue(newObj, this.getCodec().readFChar());
                            break;
                        }
                        case 4: {
                            subInfo.setShortValue(newObj, this.getCodec().readFShort());
                            break;
                        }
                        case 5: {
                            subInfo.setIntValue(newObj, this.getCodec().readFInt());
                            break;
                        }
                        case 6: {
                            subInfo.setLongValue(newObj, this.getCodec().readFLong());
                            break;
                        }
                        case 7: {
                            subInfo.setFloatValue(newObj, this.getCodec().readFFloat());
                            break;
                        }
                        case 8: {
                            subInfo.setDoubleValue(newObj, this.getCodec().readFDouble());
                        }
                    }
                    continue;
                }
                if (subInfo.isConditional() && conditional == 0 && this.skipConditional(newObj, conditional = this.getCodec().readPlainInt(), subInfo)) {
                    this.getCodec().moveTo(conditional);
                    continue;
                }
                Object subObject = this.readObjectWithHeader(subInfo);
                subInfo.setObjectValue(newObj, subObject);
                continue;
            }
            catch (IllegalAccessException ex) {
                throw new IOException(ex);
            }
        }
        int debug = this.getCodec().readVersionTag();
    }

    public VersionConflictListener getVersionConflictListener() {
        return this.versionConflictListener;
    }

    public void setVersionConflictListener(VersionConflictListener versionConflictListener) {
        this.versionConflictListener = versionConflictListener;
    }

    protected void oldVersionRead(Object newObj) {
        if (this.versionConflictListener != null) {
            this.versionConflictListener.onOldVersionRead(newObj);
        }
    }

    protected void readFieldsMapBased(FSTClazzInfo.FSTFieldInfo referencee, FSTClazzInfo serializationInfo, Object newObj) throws Exception {
        int len = this.getCodec().getObjectHeaderLen();
        if (len < 0) {
            len = Integer.MAX_VALUE;
        }
        int count = 0;
        boolean isUnknown = newObj.getClass() == Unknown.class;
        boolean inArray = isUnknown && this.getCodec().inArray();
        this.getCodec().startFieldReading(newObj);
        block10: while (count < len) {
            Object toSet;
            if (inArray) {
                Object o = this.readObjectWithHeader(null);
                if (o != null && this.getCodec().isEndMarker(o.toString())) {
                    return;
                }
                ((Unknown)newObj).add(o);
                continue;
            }
            String name = this.getCodec().readStringUTF();
            if (len == Integer.MAX_VALUE && this.getCodec().isEndMarker(name)) {
                return;
            }
            ++count;
            if (isUnknown) {
                FSTClazzInfo.FSTFieldInfo fakeField = new FSTClazzInfo.FSTFieldInfo(null, null, true);
                fakeField.fakeName = name;
                toSet = this.readObjectWithHeader(fakeField);
                ((Unknown)newObj).set(name, toSet);
                continue;
            }
            if (newObj.getClass() == MBObject.class) {
                Object toSet2 = this.readObjectWithHeader(null);
                ((MBObject)newObj).put(name, toSet2);
                continue;
            }
            FSTClazzInfo.FSTFieldInfo fieldInfo = serializationInfo.getFieldInfo(name, null);
            if (fieldInfo == null) {
                System.out.println("warning: unknown field: " + name + " on class " + serializationInfo.getClazz().getName());
                continue;
            }
            if (fieldInfo.isPrimitive()) {
                switch (fieldInfo.getIntegralType()) {
                    case 1: {
                        fieldInfo.setBooleanValue(newObj, this.getCodec().readFByte() != 0);
                        continue block10;
                    }
                    case 2: {
                        fieldInfo.setByteValue(newObj, this.getCodec().readFByte());
                        continue block10;
                    }
                    case 3: {
                        fieldInfo.setCharValue(newObj, this.getCodec().readFChar());
                        continue block10;
                    }
                    case 4: {
                        fieldInfo.setShortValue(newObj, this.getCodec().readFShort());
                        continue block10;
                    }
                    case 5: {
                        fieldInfo.setIntValue(newObj, this.getCodec().readFInt());
                        continue block10;
                    }
                    case 6: {
                        fieldInfo.setLongValue(newObj, this.getCodec().readFLong());
                        continue block10;
                    }
                    case 7: {
                        fieldInfo.setFloatValue(newObj, this.getCodec().readFFloat());
                        continue block10;
                    }
                    case 8: {
                        fieldInfo.setDoubleValue(newObj, this.getCodec().readFDouble());
                        continue block10;
                    }
                }
                throw new RuntimeException("unkown primitive type " + fieldInfo);
            }
            toSet = this.readObjectWithHeader(fieldInfo);
            toSet = this.getCodec().coerceElement(fieldInfo.getType(), toSet);
            fieldInfo.setObjectValue(newObj, toSet);
        }
        this.getCodec().endFieldReading(newObj);
    }

    protected boolean skipConditional(Object newObj, int conditional, FSTClazzInfo.FSTFieldInfo subInfo) {
        if (this.conditionalCallback != null) {
            return this.conditionalCallback.shouldSkip(newObj, conditional, subInfo.getField());
        }
        return false;
    }

    protected void readCompatibleObjectFields(FSTClazzInfo.FSTFieldInfo referencee, FSTClazzInfo serializationInfo, FSTClazzInfo.FSTFieldInfo[] fieldInfo, Map res) throws Exception {
        int booleanMask = 0;
        int boolcount = 8;
        for (int i = 0; i < fieldInfo.length; ++i) {
            try {
                FSTClazzInfo.FSTFieldInfo subInfo = fieldInfo[i];
                if (subInfo.isIntegral() && !subInfo.isArray()) {
                    Class subInfoType = subInfo.getType();
                    if (subInfoType == Boolean.TYPE) {
                        if (boolcount == 8) {
                            booleanMask = this.getCodec().readFByte() + 256 & 0xFF;
                            boolcount = 0;
                        }
                        boolean val = (booleanMask & 0x80) != 0;
                        booleanMask <<= 1;
                        ++boolcount;
                        res.put(subInfo.getName(), val);
                    }
                    if (subInfoType == Byte.TYPE) {
                        res.put(subInfo.getName(), this.getCodec().readFByte());
                        continue;
                    }
                    if (subInfoType == Character.TYPE) {
                        res.put(subInfo.getName(), Character.valueOf(this.getCodec().readFChar()));
                        continue;
                    }
                    if (subInfoType == Short.TYPE) {
                        res.put(subInfo.getName(), this.getCodec().readFShort());
                        continue;
                    }
                    if (subInfoType == Integer.TYPE) {
                        res.put(subInfo.getName(), this.getCodec().readFInt());
                        continue;
                    }
                    if (subInfoType == Double.TYPE) {
                        res.put(subInfo.getName(), this.getCodec().readFDouble());
                        continue;
                    }
                    if (subInfoType == Float.TYPE) {
                        res.put(subInfo.getName(), Float.valueOf(this.getCodec().readFFloat()));
                        continue;
                    }
                    if (subInfoType != Long.TYPE) continue;
                    res.put(subInfo.getName(), this.getCodec().readFLong());
                    continue;
                }
                Object subObject = this.readObjectWithHeader(subInfo);
                res.put(subInfo.getName(), subObject);
                continue;
            }
            catch (IllegalAccessException ex) {
                throw new IOException(ex);
            }
        }
    }

    public String readStringUTF() throws IOException {
        return this.getCodec().readStringUTF();
    }

    public String readStringAsc() throws IOException {
        return this.getCodec().readStringAsc();
    }

    protected Object readArray(FSTClazzInfo.FSTFieldInfo referencee, int pos) throws Exception {
        Object classOrArray = this.getCodec().readArrayHeader();
        if (pos < 0) {
            pos = this.getCodec().getInputPos();
        }
        if (!(classOrArray instanceof Class)) {
            return classOrArray;
        }
        if (classOrArray == null) {
            return null;
        }
        Object o = this.readArrayNoHeader(referencee, pos, (Class)classOrArray);
        this.getCodec().readArrayEnd(null);
        return o;
    }

    protected Object readArrayNoHeader(FSTClazzInfo.FSTFieldInfo referencee, int pos, Class arrCl) throws Exception {
        int len = this.getCodec().readFInt();
        if (len == -1) {
            return null;
        }
        Class<?> arrType = arrCl.getComponentType();
        if (!arrCl.getComponentType().isArray()) {
            Object array = Array.newInstance(arrType, len);
            if (!referencee.isFlat()) {
                this.objects.registerObjectForRead(array, pos);
            }
            if (arrCl.getComponentType().isPrimitive()) {
                return this.getCodec().readFPrimitiveArray(array, arrType, len);
            }
            Object[] arr = (Object[])array;
            for (int i = 0; i < len; ++i) {
                Object value = this.readObjectWithHeader(referencee);
                arr[i] = value = this.getCodec().coerceElement(arrType, value);
            }
            this.getCodec().readObjectEnd();
            return array;
        }
        Object[] array = (Object[])Array.newInstance(arrType, len);
        if (!referencee.isFlat()) {
            this.objects.registerObjectForRead(array, pos);
        }
        FSTClazzInfo.FSTFieldInfo ref1 = new FSTClazzInfo.FSTFieldInfo(referencee.getPossibleClasses(), null, this.clInfoRegistry.isIgnoreAnnotations());
        for (int i = 0; i < len; ++i) {
            Object subArray;
            array[i] = subArray = this.readArray(ref1, -1);
        }
        return array;
    }

    public void registerObject(Object o, int streamPosition, FSTClazzInfo info, FSTClazzInfo.FSTFieldInfo referencee) {
        if (!(this.objects.disabled || referencee.isFlat() || info != null && info.isFlat())) {
            this.objects.registerObjectForRead(o, streamPosition);
        }
    }

    public FSTClazzInfo readClass() throws IOException, ClassNotFoundException {
        return this.getCodec().readClass();
    }

    protected void resetAndClearRefs() {
        try {
            this.reset();
            this.objects.clearForRead(this.conf);
        }
        catch (IOException e) {
            FSTUtil.rethrow(e);
        }
    }

    public void reset() throws IOException {
        this.getCodec().reset();
    }

    public void resetForReuse(InputStream in) throws IOException {
        if (this.closed) {
            throw new RuntimeException("can't reuse closed stream");
        }
        this.getCodec().reset();
        this.getCodec().setInputStream(in);
        this.objects.clearForRead(this.conf);
        this.callbacks = null;
    }

    public void resetForReuseCopyArray(byte[] bytes, int off, int len) throws IOException {
        if (this.closed) {
            throw new RuntimeException("can't reuse closed stream");
        }
        this.getCodec().reset();
        this.objects.clearForRead(this.conf);
        this.getCodec().resetToCopyOf(bytes, off, len);
        this.callbacks = null;
    }

    public void resetForReuseUseArray(byte[] bytes) throws IOException {
        this.resetForReuseUseArray(bytes, bytes.length);
    }

    public void resetForReuseUseArray(byte[] bytes, int len) throws IOException {
        if (this.closed) {
            throw new RuntimeException("can't reuse closed stream");
        }
        this.objects.clearForRead(this.conf);
        this.getCodec().resetWith(bytes, len);
        this.callbacks = null;
    }

    public final int readFInt() throws IOException {
        return this.getCodec().readFInt();
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        this.resetAndClearRefs();
        this.conf.returnObject(this.objects);
        this.getCodec().close();
    }

    protected ObjectInputStream getObjectInputStream(final Class cl, final FSTClazzInfo clInfo, final FSTClazzInfo.FSTFieldInfo referencee, final Object toRead) throws IOException {
        ObjectInputStream wrapped = new ObjectInputStream(){
            HashMap<String, Object> fieldMap;

            @Override
            public Object readObjectOverride() throws IOException, ClassNotFoundException {
                try {
                    byte b = FSTObjectInput.this.readByte();
                    if (b != -19) {
                        Constructor<?>[] constructors = OptionalDataException.class.getDeclaredConstructors();
                        FSTObjectInput.this.pushBack(1);
                        for (int i = 0; i < constructors.length; ++i) {
                            Constructor<?> constructor = constructors[i];
                            Class<?>[] typeParameters = constructor.getParameterTypes();
                            if (typeParameters == null || typeParameters.length != 1 || typeParameters[0] != Integer.TYPE) continue;
                            constructor.setAccessible(true);
                            try {
                                OptionalDataException ode = (OptionalDataException)constructor.newInstance(0);
                                throw ode;
                            }
                            catch (InvocationTargetException e) {
                                break;
                            }
                        }
                        throw new EOFException("if your code relies on this, think");
                    }
                    return FSTObjectInput.this.readObjectInternal(referencee.getPossibleClasses());
                }
                catch (IllegalAccessException e) {
                    throw new IOException(e);
                }
                catch (InstantiationException e) {
                    throw new IOException(e);
                }
            }

            @Override
            public Object readUnshared() throws IOException, ClassNotFoundException {
                try {
                    return FSTObjectInput.this.readObjectInternal(referencee.getPossibleClasses());
                }
                catch (IllegalAccessException e) {
                    throw new IOException(e);
                }
                catch (InstantiationException e) {
                    throw new IOException(e);
                }
            }

            @Override
            public void defaultReadObject() throws IOException, ClassNotFoundException {
                try {
                    byte tag = this.readByte();
                    if (tag == 77) {
                        this.fieldMap = (HashMap)FSTObjectInput.this.readObjectInternal(HashMap.class);
                        for (String key : this.fieldMap.keySet()) {
                            FSTClazzInfo.FSTFieldInfo fieldInfo = clInfo.getFieldInfo(key, null);
                            if (fieldInfo == null) continue;
                            fieldInfo.setObjectValue(toRead, this.fieldMap.get(key));
                        }
                    } else {
                        FSTObjectInput.this.readObjectFields(referencee, clInfo, clInfo.getCompInfo().get(cl).getFieldArray(), toRead, 0, 0);
                    }
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }

            @Override
            public ObjectInputStream.GetField readFields() throws IOException, ClassNotFoundException {
                byte tag = this.readByte();
                try {
                    FSTClazzInfo.FSTCompatibilityInfo fstCompatibilityInfo = clInfo.getCompInfo().get(cl);
                    if (tag == 99) {
                        this.fieldMap = new HashMap();
                        FSTObjectInput.this.readCompatibleObjectFields(referencee, clInfo, fstCompatibilityInfo.getFieldArray(), this.fieldMap);
                        FSTObjectInput.this.getCodec().readVersionTag();
                    } else if (tag == 66) {
                        this.fieldMap = new HashMap();
                        FSTObjectInput.this.readCompatibleObjectFields(referencee, clInfo, fstCompatibilityInfo.getFieldArray(), this.fieldMap);
                        FSTObjectInput.this.getCodec().readVersionTag();
                    } else {
                        this.fieldMap = (HashMap)FSTObjectInput.this.readObjectInternal(HashMap.class);
                    }
                }
                catch (Exception e) {
                    FSTUtil.rethrow(e);
                }
                return new ObjectInputStream.GetField(){

                    @Override
                    public ObjectStreamClass getObjectStreamClass() {
                        return ObjectStreamClass.lookup(cl);
                    }

                    @Override
                    public boolean defaulted(String name) throws IOException {
                        return fieldMap.get(name) == null;
                    }

                    @Override
                    public boolean get(String name, boolean val) throws IOException {
                        if (fieldMap.get(name) == null) {
                            return val;
                        }
                        return (Boolean)fieldMap.get(name);
                    }

                    @Override
                    public byte get(String name, byte val) throws IOException {
                        if (fieldMap.get(name) == null) {
                            return val;
                        }
                        return (Byte)fieldMap.get(name);
                    }

                    @Override
                    public char get(String name, char val) throws IOException {
                        if (fieldMap.get(name) == null) {
                            return val;
                        }
                        return ((Character)fieldMap.get(name)).charValue();
                    }

                    @Override
                    public short get(String name, short val) throws IOException {
                        if (fieldMap.get(name) == null) {
                            return val;
                        }
                        return (Short)fieldMap.get(name);
                    }

                    @Override
                    public int get(String name, int val) throws IOException {
                        if (fieldMap.get(name) == null) {
                            return val;
                        }
                        return (Integer)fieldMap.get(name);
                    }

                    @Override
                    public long get(String name, long val) throws IOException {
                        if (fieldMap.get(name) == null) {
                            return val;
                        }
                        return (Long)fieldMap.get(name);
                    }

                    @Override
                    public float get(String name, float val) throws IOException {
                        if (fieldMap.get(name) == null) {
                            return val;
                        }
                        return ((Float)fieldMap.get(name)).floatValue();
                    }

                    @Override
                    public double get(String name, double val) throws IOException {
                        if (fieldMap.get(name) == null) {
                            return val;
                        }
                        return (Double)fieldMap.get(name);
                    }

                    @Override
                    public Object get(String name, Object val) throws IOException {
                        Object res = fieldMap.get(name);
                        if (res == null) {
                            return val;
                        }
                        return res;
                    }
                };
            }

            @Override
            public void registerValidation(ObjectInputValidation obj, int prio) throws NotActiveException, InvalidObjectException {
                if (FSTObjectInput.this.callbacks == null) {
                    FSTObjectInput.this.callbacks = new ArrayList();
                }
                FSTObjectInput.this.callbacks.add(new CallbackEntry(obj, prio));
            }

            @Override
            public int read() throws IOException {
                return FSTObjectInput.this.getCodec().readFByte();
            }

            @Override
            public int read(byte[] buf, int off, int len) throws IOException {
                return FSTObjectInput.this.read(buf, off, len);
            }

            @Override
            public int available() throws IOException {
                return FSTObjectInput.this.available();
            }

            @Override
            public void close() throws IOException {
            }

            @Override
            public boolean readBoolean() throws IOException {
                return FSTObjectInput.this.readBoolean();
            }

            @Override
            public byte readByte() throws IOException {
                return FSTObjectInput.this.getCodec().readFByte();
            }

            @Override
            public int readUnsignedByte() throws IOException {
                return FSTObjectInput.this.readUnsignedByte();
            }

            @Override
            public char readChar() throws IOException {
                return FSTObjectInput.this.getCodec().readFChar();
            }

            @Override
            public short readShort() throws IOException {
                return FSTObjectInput.this.getCodec().readFShort();
            }

            @Override
            public int readUnsignedShort() throws IOException {
                return FSTObjectInput.this.readUnsignedShort();
            }

            @Override
            public int readInt() throws IOException {
                return FSTObjectInput.this.getCodec().readFInt();
            }

            @Override
            public long readLong() throws IOException {
                return FSTObjectInput.this.getCodec().readFLong();
            }

            @Override
            public float readFloat() throws IOException {
                return FSTObjectInput.this.getCodec().readFFloat();
            }

            @Override
            public double readDouble() throws IOException {
                return FSTObjectInput.this.getCodec().readFDouble();
            }

            @Override
            public void readFully(byte[] buf) throws IOException {
                FSTObjectInput.this.readFully(buf);
            }

            @Override
            public void readFully(byte[] buf, int off, int len) throws IOException {
                FSTObjectInput.this.readFully(buf, off, len);
            }

            @Override
            public int skipBytes(int len) throws IOException {
                return FSTObjectInput.this.skipBytes(len);
            }

            @Override
            public String readUTF() throws IOException {
                return FSTObjectInput.this.getCodec().readStringUTF();
            }

            @Override
            public String readLine() throws IOException {
                return FSTObjectInput.this.readLine();
            }

            @Override
            public int read(byte[] b) throws IOException {
                return FSTObjectInput.this.read(b);
            }

            @Override
            public long skip(long n) throws IOException {
                return FSTObjectInput.this.skip(n);
            }

            @Override
            public void mark(int readlimit) {
                throw new RuntimeException("not implemented");
            }

            @Override
            public void reset() throws IOException {
                FSTObjectInput.this.reset();
            }

            @Override
            public boolean markSupported() {
                return false;
            }
        };
        if (this.fakeWrapper == null) {
            this.fakeWrapper = new MyObjectStream();
        }
        this.fakeWrapper.push(wrapped);
        return this.fakeWrapper;
    }

    protected void pushBack(int i) {
        this.getCodec().pushBack(i);
    }

    protected static class MyObjectStream
    extends ObjectInputStream {
        ObjectInputStream wrapped;
        ArrayDeque<ObjectInputStream> wrappedStack = new ArrayDeque();

        public void push(ObjectInputStream in) {
            this.wrappedStack.push(in);
            this.wrapped = in;
        }

        public void pop() {
            this.wrapped = this.wrappedStack.pop();
        }

        MyObjectStream() throws IOException, SecurityException {
        }

        @Override
        public Object readObjectOverride() throws IOException, ClassNotFoundException {
            return this.wrapped.readObject();
        }

        @Override
        public Object readUnshared() throws IOException, ClassNotFoundException {
            return this.wrapped.readUnshared();
        }

        @Override
        public void defaultReadObject() throws IOException, ClassNotFoundException {
            this.wrapped.defaultReadObject();
        }

        @Override
        public ObjectInputStream.GetField readFields() throws IOException, ClassNotFoundException {
            return this.wrapped.readFields();
        }

        @Override
        public void registerValidation(ObjectInputValidation obj, int prio) throws NotActiveException, InvalidObjectException {
            this.wrapped.registerValidation(obj, prio);
        }

        @Override
        public int read() throws IOException {
            return this.wrapped.read();
        }

        @Override
        public int read(byte[] buf, int off, int len) throws IOException {
            return this.wrapped.read(buf, off, len);
        }

        @Override
        public int available() throws IOException {
            return this.wrapped.available();
        }

        @Override
        public void close() throws IOException {
            this.wrapped.close();
        }

        @Override
        public boolean readBoolean() throws IOException {
            return this.wrapped.readBoolean();
        }

        @Override
        public byte readByte() throws IOException {
            return this.wrapped.readByte();
        }

        @Override
        public int readUnsignedByte() throws IOException {
            return this.wrapped.readUnsignedByte();
        }

        @Override
        public char readChar() throws IOException {
            return this.wrapped.readChar();
        }

        @Override
        public short readShort() throws IOException {
            return this.wrapped.readShort();
        }

        @Override
        public int readUnsignedShort() throws IOException {
            return this.wrapped.readUnsignedShort();
        }

        @Override
        public int readInt() throws IOException {
            return this.wrapped.readInt();
        }

        @Override
        public long readLong() throws IOException {
            return this.wrapped.readLong();
        }

        @Override
        public float readFloat() throws IOException {
            return this.wrapped.readFloat();
        }

        @Override
        public double readDouble() throws IOException {
            return this.wrapped.readDouble();
        }

        @Override
        public void readFully(byte[] buf) throws IOException {
            this.wrapped.readFully(buf);
        }

        @Override
        public void readFully(byte[] buf, int off, int len) throws IOException {
            this.wrapped.readFully(buf, off, len);
        }

        @Override
        public int skipBytes(int len) throws IOException {
            return this.wrapped.skipBytes(len);
        }

        @Override
        public String readUTF() throws IOException {
            return this.wrapped.readUTF();
        }

        @Override
        public String readLine() throws IOException {
            return this.wrapped.readLine();
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.wrapped.read(b);
        }

        @Override
        public long skip(long n) throws IOException {
            return this.wrapped.skip(n);
        }

        @Override
        public void mark(int readlimit) {
            this.wrapped.mark(readlimit);
        }

        @Override
        public void reset() throws IOException {
            this.wrapped.reset();
        }

        @Override
        public boolean markSupported() {
            return this.wrapped.markSupported();
        }
    }

    public static interface ConditionalCallback {
        public boolean shouldSkip(Object var1, int var2, Field var3);
    }

    protected static class CallbackEntry {
        ObjectInputValidation cb;
        int prio;

        CallbackEntry(ObjectInputValidation cb, int prio) {
            this.cb = cb;
            this.prio = prio;
        }
    }
}

