/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.transaction.operation;

import org.redisson.RedissonKeys;
import org.redisson.RedissonLock;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.transaction.operation.TransactionalOperation;

public class DeleteOperation
extends TransactionalOperation {
    private String lockName;

    public DeleteOperation(String name) {
        this(name, (String)null);
    }

    public DeleteOperation(String name, String lockName) {
        super(name, null);
        this.lockName = lockName;
    }

    @Override
    public void commit(CommandAsyncExecutor commandExecutor) {
        RedissonKeys keys = new RedissonKeys(commandExecutor);
        keys.deleteAsync(this.getName());
        if (this.lockName != null) {
            RedissonLock lock = new RedissonLock(commandExecutor, this.lockName);
            lock.unlockAsync();
        }
    }

    @Override
    public void rollback(CommandAsyncExecutor commandExecutor) {
        if (this.lockName != null) {
            RedissonLock lock = new RedissonLock(commandExecutor, this.lockName);
            lock.unlockAsync();
        }
    }

    public String getLockName() {
        return this.lockName;
    }
}

