/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.reactive;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import org.redisson.RedissonSet;
import org.redisson.api.RFuture;
import org.redisson.api.RSetAsync;
import org.redisson.api.RSetReactive;
import org.redisson.api.SortOrder;
import org.redisson.client.RedisClient;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.decoder.ListScanResult;
import org.redisson.command.CommandReactiveExecutor;
import org.redisson.reactive.PublisherAdder;
import org.redisson.reactive.RedissonExpirableReactive;
import org.redisson.reactive.SetReactiveIterator;
import reactor.core.publisher.Flux;

public class RedissonSetReactive<V>
extends RedissonExpirableReactive
implements RSetReactive<V> {
    private final RSetAsync<V> instance;

    public RedissonSetReactive(CommandReactiveExecutor commandExecutor, String name) {
        this(commandExecutor, name, new RedissonSet(commandExecutor.getConnectionManager().getCodec(), commandExecutor, name, null));
    }

    public RedissonSetReactive(CommandReactiveExecutor commandExecutor, String name, RSetAsync<V> instance) {
        super(commandExecutor, name, instance);
        this.instance = instance;
    }

    public RedissonSetReactive(Codec codec, CommandReactiveExecutor commandExecutor, String name) {
        this(codec, commandExecutor, name, new RedissonSet(codec, commandExecutor, name, null));
    }

    public RedissonSetReactive(Codec codec, CommandReactiveExecutor commandExecutor, String name, RSetAsync<V> instance) {
        super(codec, commandExecutor, name, instance);
        this.instance = instance;
    }

    @Override
    public Publisher<Integer> addAll(Publisher<? extends V> c) {
        return new PublisherAdder<V>(this).addAll(c);
    }

    @Override
    public Publisher<Set<V>> removeRandom(final int amount) {
        return this.reactive(new Supplier<RFuture<Set<V>>>(){

            @Override
            public RFuture<Set<V>> get() {
                return RedissonSetReactive.this.instance.removeRandomAsync(amount);
            }
        });
    }

    @Override
    public Publisher<Integer> size() {
        return this.reactive(new Supplier<RFuture<Integer>>(){

            @Override
            public RFuture<Integer> get() {
                return RedissonSetReactive.this.instance.sizeAsync();
            }
        });
    }

    @Override
    public Publisher<Boolean> contains(final Object o) {
        return this.reactive(new Supplier<RFuture<Boolean>>(){

            @Override
            public RFuture<Boolean> get() {
                return RedissonSetReactive.this.instance.containsAsync(o);
            }
        });
    }

    @Override
    public Publisher<Set<V>> readAll() {
        return this.reactive(new Supplier<RFuture<Set<V>>>(){

            @Override
            public RFuture<Set<V>> get() {
                return RedissonSetReactive.this.instance.readAllAsync();
            }
        });
    }

    private Publisher<ListScanResult<Object>> scanIteratorReactive(final RedisClient client, final long startPos, final String pattern, final int count) {
        return this.reactive(new Supplier<RFuture<ListScanResult<Object>>>(){

            @Override
            public RFuture<ListScanResult<Object>> get() {
                return ((RedissonSet)RedissonSetReactive.this.instance).scanIteratorAsync(RedissonSetReactive.this.getName(), client, startPos, pattern, count);
            }
        });
    }

    @Override
    public Publisher<Integer> add(V e) {
        return this.commandExecutor.writeReactive(this.getName(), this.codec, RedisCommands.SADD, this.getName(), this.encode(e));
    }

    @Override
    public Publisher<V> removeRandom() {
        return this.reactive(new Supplier<RFuture<V>>(){

            @Override
            public RFuture<V> get() {
                return RedissonSetReactive.this.instance.removeRandomAsync();
            }
        });
    }

    @Override
    public Publisher<V> random() {
        return this.reactive(new Supplier<RFuture<V>>(){

            @Override
            public RFuture<V> get() {
                return RedissonSetReactive.this.instance.randomAsync();
            }
        });
    }

    @Override
    public Publisher<Boolean> remove(final Object o) {
        return this.reactive(new Supplier<RFuture<Boolean>>(){

            @Override
            public RFuture<Boolean> get() {
                return RedissonSetReactive.this.instance.removeAsync(o);
            }
        });
    }

    @Override
    public Publisher<Boolean> move(final String destination, final V member) {
        return this.reactive(new Supplier<RFuture<Boolean>>(){

            @Override
            public RFuture<Boolean> get() {
                return RedissonSetReactive.this.instance.moveAsync(destination, member);
            }
        });
    }

    @Override
    public Publisher<Boolean> containsAll(final Collection<?> c) {
        return this.reactive(new Supplier<RFuture<Boolean>>(){

            @Override
            public RFuture<Boolean> get() {
                return RedissonSetReactive.this.instance.containsAllAsync(c);
            }
        });
    }

    @Override
    public Publisher<Integer> addAll(Collection<? extends V> c) {
        ArrayList<Object> args = new ArrayList<Object>(c.size() + 1);
        args.add(this.getName());
        this.encode(args, c);
        return this.commandExecutor.writeReactive(this.getName(), this.codec, RedisCommands.SADD, args.toArray());
    }

    @Override
    public Publisher<Boolean> retainAll(final Collection<?> c) {
        return this.reactive(new Supplier<RFuture<Boolean>>(){

            @Override
            public RFuture<Boolean> get() {
                return RedissonSetReactive.this.instance.retainAllAsync(c);
            }
        });
    }

    @Override
    public Publisher<Boolean> removeAll(final Collection<?> c) {
        return this.reactive(new Supplier<RFuture<Boolean>>(){

            @Override
            public RFuture<Boolean> get() {
                return RedissonSetReactive.this.instance.removeAllAsync(c);
            }
        });
    }

    @Override
    public Publisher<Set<V>> readIntersection(final String ... names) {
        return this.reactive(new Supplier<RFuture<Set<V>>>(){

            @Override
            public RFuture<Set<V>> get() {
                return RedissonSetReactive.this.instance.readIntersectionAsync(names);
            }
        });
    }

    @Override
    public Publisher<Long> intersection(String ... names) {
        ArrayList<String> args = new ArrayList<String>(names.length + 1);
        args.add(this.getName());
        args.addAll(Arrays.asList(names));
        return this.commandExecutor.writeReactive(this.getName(), this.codec, RedisCommands.SINTERSTORE, args.toArray());
    }

    @Override
    public Publisher<Long> diff(String ... names) {
        ArrayList<String> args = new ArrayList<String>(names.length + 1);
        args.add(this.getName());
        args.addAll(Arrays.asList(names));
        return this.commandExecutor.writeReactive(this.getName(), this.codec, RedisCommands.SDIFFSTORE, args.toArray());
    }

    @Override
    public Publisher<Set<V>> readDiff(final String ... names) {
        return this.reactive(new Supplier<RFuture<Set<V>>>(){

            @Override
            public RFuture<Set<V>> get() {
                return RedissonSetReactive.this.instance.readDiffAsync(names);
            }
        });
    }

    @Override
    public Publisher<Long> union(String ... names) {
        ArrayList<String> args = new ArrayList<String>(names.length + 1);
        args.add(this.getName());
        args.addAll(Arrays.asList(names));
        return this.commandExecutor.writeReactive(this.getName(), this.codec, RedisCommands.SUNIONSTORE, args.toArray());
    }

    @Override
    public Publisher<Set<V>> readUnion(final String ... names) {
        return this.reactive(new Supplier<RFuture<Set<V>>>(){

            @Override
            public RFuture<Set<V>> get() {
                return RedissonSetReactive.this.instance.readUnionAsync(names);
            }
        });
    }

    @Override
    public Publisher<V> iterator(int count) {
        return this.iterator(null, count);
    }

    @Override
    public Publisher<V> iterator(String pattern) {
        return this.iterator(pattern, 10);
    }

    @Override
    public Publisher<V> iterator(final String pattern, final int count) {
        return Flux.create(new SetReactiveIterator<V>(){

            @Override
            protected Publisher<ListScanResult<Object>> scanIteratorReactive(RedisClient client, long nextIterPos) {
                return RedissonSetReactive.this.scanIteratorReactive(client, nextIterPos, pattern, count);
            }
        });
    }

    @Override
    public Publisher<V> iterator() {
        return this.iterator(null, 10);
    }

    @Override
    public Publisher<Set<V>> readSorted(final SortOrder order) {
        return this.reactive(new Supplier<RFuture<Set<V>>>(){

            @Override
            public RFuture<Set<V>> get() {
                return RedissonSetReactive.this.instance.readSortAsync(order);
            }
        });
    }

    @Override
    public Publisher<Set<V>> readSorted(final SortOrder order, final int offset, final int count) {
        return this.reactive(new Supplier<RFuture<Set<V>>>(){

            @Override
            public RFuture<Set<V>> get() {
                return RedissonSetReactive.this.instance.readSortAsync(order, offset, count);
            }
        });
    }

    @Override
    public Publisher<Set<V>> readSorted(final String byPattern, final SortOrder order) {
        return this.reactive(new Supplier<RFuture<Set<V>>>(){

            @Override
            public RFuture<Set<V>> get() {
                return RedissonSetReactive.this.instance.readSortAsync(byPattern, order);
            }
        });
    }

    @Override
    public Publisher<Set<V>> readSorted(final String byPattern, final SortOrder order, final int offset, final int count) {
        return this.reactive(new Supplier<RFuture<Set<V>>>(){

            @Override
            public RFuture<Set<V>> get() {
                return RedissonSetReactive.this.instance.readSortAsync(byPattern, order, offset, count);
            }
        });
    }

    @Override
    public <T> Publisher<Collection<T>> readSorted(final String byPattern, final List<String> getPatterns, final SortOrder order) {
        return this.reactive(new Supplier<RFuture<Collection<T>>>(){

            @Override
            public RFuture<Collection<T>> get() {
                return RedissonSetReactive.this.instance.readSortAsync(byPattern, getPatterns, order);
            }
        });
    }

    @Override
    public <T> Publisher<Collection<T>> readSorted(final String byPattern, final List<String> getPatterns, final SortOrder order, final int offset, final int count) {
        return this.reactive(new Supplier<RFuture<Collection<T>>>(){

            @Override
            public RFuture<Collection<T>> get() {
                return RedissonSetReactive.this.instance.readSortAsync(byPattern, getPatterns, order, offset, count);
            }
        });
    }

    @Override
    public Publisher<Integer> sortTo(final String destName, final SortOrder order) {
        return this.reactive(new Supplier<RFuture<Integer>>(){

            @Override
            public RFuture<Integer> get() {
                return RedissonSetReactive.this.instance.sortToAsync(destName, order);
            }
        });
    }

    @Override
    public Publisher<Integer> sortTo(final String destName, final SortOrder order, final int offset, final int count) {
        return this.reactive(new Supplier<RFuture<Integer>>(){

            @Override
            public RFuture<Integer> get() {
                return RedissonSetReactive.this.instance.sortToAsync(destName, order, offset, count);
            }
        });
    }

    @Override
    public Publisher<Integer> sortTo(final String destName, final String byPattern, final SortOrder order) {
        return this.reactive(new Supplier<RFuture<Integer>>(){

            @Override
            public RFuture<Integer> get() {
                return RedissonSetReactive.this.instance.sortToAsync(destName, byPattern, order);
            }
        });
    }

    @Override
    public Publisher<Integer> sortTo(final String destName, final String byPattern, final SortOrder order, final int offset, final int count) {
        return this.reactive(new Supplier<RFuture<Integer>>(){

            @Override
            public RFuture<Integer> get() {
                return RedissonSetReactive.this.instance.sortToAsync(destName, byPattern, order, offset, count);
            }
        });
    }

    @Override
    public Publisher<Integer> sortTo(final String destName, final String byPattern, final List<String> getPatterns, final SortOrder order) {
        return this.reactive(new Supplier<RFuture<Integer>>(){

            @Override
            public RFuture<Integer> get() {
                return RedissonSetReactive.this.instance.sortToAsync(destName, byPattern, getPatterns, order);
            }
        });
    }

    @Override
    public Publisher<Integer> sortTo(final String destName, final String byPattern, final List<String> getPatterns, final SortOrder order, final int offset, final int count) {
        return this.reactive(new Supplier<RFuture<Integer>>(){

            @Override
            public RFuture<Integer> get() {
                return RedissonSetReactive.this.instance.sortToAsync(destName, byPattern, getPatterns, order, offset, count);
            }
        });
    }
}

