/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.reactive;

import java.util.AbstractMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.LongConsumer;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.redisson.client.RedisClient;
import org.redisson.client.protocol.decoder.MapScanResult;
import org.redisson.reactive.MapReactive;
import reactor.core.publisher.FluxSink;
import reactor.core.publisher.Mono;

public class RedissonMapReactiveIterator<K, V, M>
implements Consumer<FluxSink<M>> {
    private final MapReactive<K, V> map;
    private final String pattern;
    private final int count;

    public RedissonMapReactiveIterator(MapReactive<K, V> map, String pattern, int count) {
        this.map = map;
        this.pattern = pattern;
        this.count = count;
    }

    @Override
    public void accept(final FluxSink<M> emitter) {
        emitter.onRequest(new LongConsumer(){
            private long nextIterPos;
            private RedisClient client;
            private AtomicLong elementsRead = new AtomicLong();
            private boolean finished;
            private volatile boolean completed;
            private AtomicLong readAmount = new AtomicLong();

            @Override
            public void accept(long value) {
                this.readAmount.addAndGet(value);
                if (this.completed || this.elementsRead.get() == 0L) {
                    this.nextValues(emitter);
                    this.completed = false;
                }
            }

            protected void nextValues(final FluxSink<M> emitter2) {
                RedissonMapReactiveIterator.this.map.scanIteratorReactive(this.client, this.nextIterPos, RedissonMapReactiveIterator.this.pattern, RedissonMapReactiveIterator.this.count).subscribe(new Subscriber<MapScanResult<Object, Object>>(){

                    @Override
                    public void onSubscribe(Subscription s) {
                        s.request(Long.MAX_VALUE);
                    }

                    @Override
                    public void onNext(MapScanResult<Object, Object> res) {
                        if (finished) {
                            client = null;
                            nextIterPos = 0L;
                            return;
                        }
                        client = res.getRedisClient();
                        nextIterPos = res.getPos();
                        for (Map.Entry<Object, Object> entry : res.getMap().entrySet()) {
                            Object val = RedissonMapReactiveIterator.this.getValue(entry);
                            emitter2.next(val);
                            elementsRead.incrementAndGet();
                        }
                        if (elementsRead.get() >= readAmount.get()) {
                            emitter2.complete();
                            elementsRead.set(0L);
                            completed = true;
                            return;
                        }
                        if (res.getPos() == 0L && !RedissonMapReactiveIterator.this.tryAgain()) {
                            finished = true;
                            emitter2.complete();
                        }
                    }

                    @Override
                    public void onError(Throwable error) {
                        emitter2.error(error);
                    }

                    @Override
                    public void onComplete() {
                        if (finished || completed) {
                            return;
                        }
                        this.nextValues(emitter2);
                    }
                });
            }
        });
    }

    protected boolean tryAgain() {
        return false;
    }

    M getValue(final Map.Entry<Object, Object> entry) {
        return (M)new AbstractMap.SimpleEntry<K, V>(entry.getKey(), entry.getValue()){

            @Override
            public V setValue(V value) {
                Publisher publisher = RedissonMapReactiveIterator.this.map.put(entry.getKey(), value);
                return Mono.from(publisher).block();
            }
        };
    }
}

