/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.reactive;

import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import org.redisson.RedissonBucket;
import org.redisson.api.RBucketAsync;
import org.redisson.api.RBucketReactive;
import org.redisson.api.RFuture;
import org.redisson.client.codec.Codec;
import org.redisson.command.CommandReactiveExecutor;
import org.redisson.reactive.RedissonExpirableReactive;

public class RedissonBucketReactive<V>
extends RedissonExpirableReactive
implements RBucketReactive<V> {
    private final RBucketAsync<V> instance;

    public RedissonBucketReactive(CommandReactiveExecutor connectionManager, String name) {
        this(connectionManager, name, new RedissonBucket(connectionManager, name));
    }

    public RedissonBucketReactive(CommandReactiveExecutor connectionManager, String name, RBucketAsync<V> instance) {
        super(connectionManager, name, instance);
        this.instance = instance;
    }

    public RedissonBucketReactive(Codec codec, CommandReactiveExecutor connectionManager, String name) {
        this(codec, connectionManager, name, new RedissonBucket(codec, connectionManager, name));
    }

    public RedissonBucketReactive(Codec codec, CommandReactiveExecutor connectionManager, String name, RBucketAsync<V> instance) {
        super(codec, connectionManager, name, instance);
        this.instance = instance;
    }

    @Override
    public Publisher<V> get() {
        return this.reactive(new Supplier<RFuture<V>>(){

            @Override
            public RFuture<V> get() {
                return RedissonBucketReactive.this.instance.getAsync();
            }
        });
    }

    @Override
    public Publisher<V> getAndDelete() {
        return this.reactive(new Supplier<RFuture<V>>(){

            @Override
            public RFuture<V> get() {
                return RedissonBucketReactive.this.instance.getAndDeleteAsync();
            }
        });
    }

    @Override
    public Publisher<Void> set(final V value) {
        return this.reactive(new Supplier<RFuture<Void>>(){

            @Override
            public RFuture<Void> get() {
                return RedissonBucketReactive.this.instance.setAsync(value);
            }
        });
    }

    @Override
    public Publisher<Void> set(final V value, final long timeToLive, final TimeUnit timeUnit) {
        return this.reactive(new Supplier<RFuture<Void>>(){

            @Override
            public RFuture<Void> get() {
                return RedissonBucketReactive.this.instance.setAsync(value, timeToLive, timeUnit);
            }
        });
    }

    @Override
    public Publisher<Long> size() {
        return this.reactive(new Supplier<RFuture<Long>>(){

            @Override
            public RFuture<Long> get() {
                return RedissonBucketReactive.this.instance.sizeAsync();
            }
        });
    }

    @Override
    public Publisher<Boolean> trySet(final V value) {
        return this.reactive(new Supplier<RFuture<Boolean>>(){

            @Override
            public RFuture<Boolean> get() {
                return RedissonBucketReactive.this.instance.trySetAsync(value);
            }
        });
    }

    @Override
    public Publisher<Boolean> trySet(final V value, final long timeToLive, final TimeUnit timeUnit) {
        return this.reactive(new Supplier<RFuture<Boolean>>(){

            @Override
            public RFuture<Boolean> get() {
                return RedissonBucketReactive.this.instance.trySetAsync(value, timeToLive, timeUnit);
            }
        });
    }

    @Override
    public Publisher<Boolean> compareAndSet(final V expect, final V update) {
        return this.reactive(new Supplier<RFuture<Boolean>>(){

            @Override
            public RFuture<Boolean> get() {
                return RedissonBucketReactive.this.instance.compareAndSetAsync(expect, update);
            }
        });
    }

    @Override
    public Publisher<V> getAndSet(final V newValue) {
        return this.reactive(new Supplier<RFuture<V>>(){

            @Override
            public RFuture<V> get() {
                return RedissonBucketReactive.this.instance.getAndSetAsync(newValue);
            }
        });
    }
}

