/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.reactive;

import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import org.redisson.api.RFuture;
import org.redisson.api.RMultimap;
import org.redisson.api.RMultimapReactive;
import org.redisson.client.codec.Codec;
import org.redisson.command.CommandReactiveExecutor;
import org.redisson.reactive.RedissonExpirableReactive;

abstract class RedissonBaseMultimapReactive<K, V>
extends RedissonExpirableReactive
implements RMultimapReactive<K, V> {
    protected final RMultimap<K, V> instance;

    public RedissonBaseMultimapReactive(RMultimap<K, V> instance, CommandReactiveExecutor commandExecutor, String name) {
        super(commandExecutor, name, instance);
        this.instance = instance;
    }

    public RedissonBaseMultimapReactive(RMultimap<K, V> instance, Codec codec, CommandReactiveExecutor commandExecutor, String name) {
        super(codec, commandExecutor, name, instance);
        this.instance = instance;
    }

    @Override
    public Publisher<Integer> size() {
        return this.reactive(new Supplier<RFuture<Integer>>(){

            @Override
            public RFuture<Integer> get() {
                return RedissonBaseMultimapReactive.this.instance.sizeAsync();
            }
        });
    }

    @Override
    public Publisher<Boolean> containsKey(final Object key) {
        return this.reactive(new Supplier<RFuture<Boolean>>(){

            @Override
            public RFuture<Boolean> get() {
                return RedissonBaseMultimapReactive.this.instance.containsKeyAsync(key);
            }
        });
    }

    @Override
    public Publisher<Boolean> containsValue(final Object value) {
        return this.reactive(new Supplier<RFuture<Boolean>>(){

            @Override
            public RFuture<Boolean> get() {
                return RedissonBaseMultimapReactive.this.instance.containsValueAsync(value);
            }
        });
    }

    @Override
    public Publisher<Boolean> containsEntry(final Object key, final Object value) {
        return this.reactive(new Supplier<RFuture<Boolean>>(){

            @Override
            public RFuture<Boolean> get() {
                return RedissonBaseMultimapReactive.this.instance.containsEntryAsync(key, value);
            }
        });
    }

    @Override
    public Publisher<Boolean> put(final K key, final V value) {
        return this.reactive(new Supplier<RFuture<Boolean>>(){

            @Override
            public RFuture<Boolean> get() {
                return RedissonBaseMultimapReactive.this.instance.putAsync(key, value);
            }
        });
    }

    @Override
    public Publisher<Boolean> remove(final Object key, final Object value) {
        return this.reactive(new Supplier<RFuture<Boolean>>(){

            @Override
            public RFuture<Boolean> get() {
                return RedissonBaseMultimapReactive.this.instance.removeAsync(key, value);
            }
        });
    }

    @Override
    public Publisher<Boolean> putAll(final K key, final Iterable<? extends V> values) {
        return this.reactive(new Supplier<RFuture<Boolean>>(){

            @Override
            public RFuture<Boolean> get() {
                return RedissonBaseMultimapReactive.this.instance.putAllAsync(key, values);
            }
        });
    }

    @Override
    public Publisher<Integer> keySize() {
        return this.reactive(new Supplier<RFuture<Integer>>(){

            @Override
            public RFuture<Integer> get() {
                return RedissonBaseMultimapReactive.this.instance.keySizeAsync();
            }
        });
    }

    @Override
    public Publisher<Long> fastRemove(final K ... keys) {
        return this.reactive(new Supplier<RFuture<Long>>(){

            @Override
            public RFuture<Long> get() {
                return RedissonBaseMultimapReactive.this.instance.fastRemoveAsync(keys);
            }
        });
    }

    @Override
    public Publisher<Set<K>> readAllKeySet() {
        return this.reactive(new Supplier<RFuture<Set<K>>>(){

            @Override
            public RFuture<Set<K>> get() {
                return RedissonBaseMultimapReactive.this.instance.readAllKeySetAsync();
            }
        });
    }

    @Override
    public Publisher<Boolean> delete() {
        return this.reactive(new Supplier<RFuture<Boolean>>(){

            @Override
            public RFuture<Boolean> get() {
                return RedissonBaseMultimapReactive.this.instance.deleteAsync();
            }
        });
    }

    @Override
    public Publisher<Boolean> expire(final long timeToLive, final TimeUnit timeUnit) {
        return this.reactive(new Supplier<RFuture<Boolean>>(){

            @Override
            public RFuture<Boolean> get() {
                return RedissonBaseMultimapReactive.this.instance.expireAsync(timeToLive, timeUnit);
            }
        });
    }

    @Override
    public Publisher<Boolean> expireAt(final long timestamp) {
        return this.reactive(new Supplier<RFuture<Boolean>>(){

            @Override
            public RFuture<Boolean> get() {
                return RedissonBaseMultimapReactive.this.instance.expireAtAsync(timestamp);
            }
        });
    }

    @Override
    public Publisher<Boolean> clearExpire() {
        return this.reactive(new Supplier<RFuture<Boolean>>(){

            @Override
            public RFuture<Boolean> get() {
                return RedissonBaseMultimapReactive.this.instance.clearExpireAsync();
            }
        });
    }
}

