/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.transaction.operation.bucket;

import org.redisson.RedissonBucket;
import org.redisson.RedissonLock;
import org.redisson.client.codec.Codec;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.transaction.operation.TransactionalOperation;

public class BucketCompareAndSetOperation<V>
extends TransactionalOperation {
    private V expected;
    private V value;
    private String lockName;

    public BucketCompareAndSetOperation(String name, String lockName, Codec codec, V expected, V value) {
        super(name, codec);
        this.expected = expected;
        this.value = value;
        this.lockName = lockName;
    }

    @Override
    public void commit(CommandAsyncExecutor commandExecutor) {
        RedissonBucket<V> bucket = new RedissonBucket<V>(this.codec, commandExecutor, this.name);
        bucket.compareAndSetAsync(this.expected, this.value);
        RedissonLock lock = new RedissonLock(commandExecutor, this.lockName);
        lock.unlockAsync();
    }

    @Override
    public void rollback(CommandAsyncExecutor commandExecutor) {
        RedissonLock lock = new RedissonLock(commandExecutor, this.lockName);
        lock.unlockAsync();
    }

    public V getExpected() {
        return this.expected;
    }

    public V getValue() {
        return this.value;
    }

    public String getLockName() {
        return this.lockName;
    }
}

