/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.executor;

import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.redisson.api.RExecutorBatchFuture;
import org.redisson.api.RExecutorFuture;
import org.redisson.misc.RedissonPromise;

public class RedissonExecutorBatchFuture
extends RedissonPromise<Void>
implements RExecutorBatchFuture {
    private List<RExecutorFuture<?>> futures;

    public RedissonExecutorBatchFuture(List<RExecutorFuture<?>> futures) {
        this.futures = futures;
        final AtomicInteger counter = new AtomicInteger(futures.size());
        for (RExecutorFuture<?> future : futures) {
            future.addListener(new FutureListener<Object>(){

                @Override
                public void operationComplete(Future<Object> future) throws Exception {
                    if (!future.isSuccess()) {
                        RedissonExecutorBatchFuture.this.tryFailure(future.cause());
                        return;
                    }
                    if (counter.decrementAndGet() == 0) {
                        RedissonExecutorBatchFuture.this.trySuccess(null);
                    }
                }
            });
        }
    }

    @Override
    public List<RExecutorFuture<?>> getTaskFutures() {
        return this.futures;
    }
}

