/*
 * Decompiled with CFR 0.152.
 */
package reactor.util;

import java.io.PrintStream;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.regex.Matcher;
import reactor.util.Logger;
import reactor.util.annotation.Nullable;

public abstract class Loggers {
    public static final String FALLBACK_PROPERTY = "reactor.logging.fallback";
    private static LoggerFactory LOGGER_FACTORY;

    public static final void resetLoggerFactory() {
        try {
            Loggers.useSl4jLoggers();
        }
        catch (Throwable t) {
            if (Loggers.isFallbackToJdk()) {
                Loggers.useJdkLoggers();
            }
            Loggers.useConsoleLoggers();
        }
    }

    static final boolean isFallbackToJdk() {
        return "JDK".equalsIgnoreCase(System.getProperty(FALLBACK_PROPERTY));
    }

    public static final void useConsoleLoggers() {
        String name = LoggerFactory.class.getName();
        ConsoleLoggerFactory loggerFactory = new ConsoleLoggerFactory();
        loggerFactory.getLogger(name).debug("Using Console logging");
        LOGGER_FACTORY = loggerFactory;
    }

    public static final void useJdkLoggers() {
        String name = LoggerFactory.class.getName();
        JdkLoggerFactory loggerFactory = new JdkLoggerFactory();
        loggerFactory.getLogger(name).debug("Using JDK logging framework");
        LOGGER_FACTORY = loggerFactory;
    }

    public static final void useSl4jLoggers() {
        String name = LoggerFactory.class.getName();
        Slf4JLoggerFactory loggerFactory = new Slf4JLoggerFactory();
        loggerFactory.getLogger(name).debug("Using Slf4j logging framework");
        LOGGER_FACTORY = loggerFactory;
    }

    public static Logger getLogger(String name) {
        return LOGGER_FACTORY.getLogger(name);
    }

    public static Logger getLogger(Class<?> cls) {
        return LOGGER_FACTORY.getLogger(cls.getName());
    }

    Loggers() {
    }

    static {
        Loggers.resetLoggerFactory();
    }

    private static final class ConsoleLoggerFactory
    implements LoggerFactory {
        private static final HashMap<String, Logger> consoleLoggers = new HashMap();

        private ConsoleLoggerFactory() {
        }

        @Override
        public Logger getLogger(String name) {
            return consoleLoggers.computeIfAbsent(name, ConsoleLogger::new);
        }
    }

    static class ConsoleLogger
    implements Logger {
        private final String name;
        private final PrintStream err;
        private final PrintStream log;

        ConsoleLogger(String name, PrintStream log, PrintStream err) {
            this.name = name;
            this.log = log;
            this.err = err;
        }

        ConsoleLogger(String name) {
            this(name, System.out, System.err);
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Nullable
        private String format(@Nullable String from, Object ... arguments) {
            if (from != null) {
                String computed = from;
                if (arguments != null && arguments.length != 0) {
                    for (Object argument : arguments) {
                        computed = computed.replaceFirst("\\{\\}", Matcher.quoteReplacement(argument.toString()));
                    }
                }
                return computed;
            }
            return null;
        }

        @Override
        public boolean isTraceEnabled() {
            return true;
        }

        @Override
        public synchronized void trace(String msg) {
            this.log.format("[TRACE] (%s) %s\n", Thread.currentThread().getName(), msg);
        }

        @Override
        public synchronized void trace(String format, Object ... arguments) {
            this.log.format("[TRACE] (%s) %s\n", Thread.currentThread().getName(), this.format(format, arguments));
        }

        @Override
        public synchronized void trace(String msg, Throwable t) {
            this.log.format("[TRACE] (%s) %s - %s\n", Thread.currentThread().getName(), msg, t);
            t.printStackTrace(this.log);
        }

        @Override
        public boolean isDebugEnabled() {
            return true;
        }

        @Override
        public synchronized void debug(String msg) {
            this.log.format("[DEBUG] (%s) %s\n", Thread.currentThread().getName(), msg);
        }

        @Override
        public synchronized void debug(String format, Object ... arguments) {
            this.log.format("[DEBUG] (%s) %s\n", Thread.currentThread().getName(), this.format(format, arguments));
        }

        @Override
        public synchronized void debug(String msg, Throwable t) {
            this.log.format("[DEBUG] (%s) %s - %s\n", Thread.currentThread().getName(), msg, t);
            t.printStackTrace(this.log);
        }

        @Override
        public boolean isInfoEnabled() {
            return true;
        }

        @Override
        public synchronized void info(String msg) {
            this.log.format("[ INFO] (%s) %s\n", Thread.currentThread().getName(), msg);
        }

        @Override
        public synchronized void info(String format, Object ... arguments) {
            this.log.format("[ INFO] (%s) %s\n", Thread.currentThread().getName(), this.format(format, arguments));
        }

        @Override
        public synchronized void info(String msg, Throwable t) {
            this.log.format("[ INFO] (%s) %s - %s\n", Thread.currentThread().getName(), msg, t);
            t.printStackTrace(this.log);
        }

        @Override
        public boolean isWarnEnabled() {
            return true;
        }

        @Override
        public synchronized void warn(String msg) {
            this.err.format("[ WARN] (%s) %s\n", Thread.currentThread().getName(), msg);
        }

        @Override
        public synchronized void warn(String format, Object ... arguments) {
            this.err.format("[ WARN] (%s) %s\n", Thread.currentThread().getName(), this.format(format, arguments));
        }

        @Override
        public synchronized void warn(String msg, Throwable t) {
            this.err.format("[ WARN] (%s) %s - %s\n", Thread.currentThread().getName(), msg, t);
            t.printStackTrace(this.err);
        }

        @Override
        public boolean isErrorEnabled() {
            return true;
        }

        @Override
        public synchronized void error(String msg) {
            this.err.format("[ERROR] (%s) %s\n", Thread.currentThread().getName(), msg);
        }

        @Override
        public synchronized void error(String format, Object ... arguments) {
            this.err.format("[ERROR] (%s) %s\n", Thread.currentThread().getName(), this.format(format, arguments));
        }

        @Override
        public synchronized void error(String msg, Throwable t) {
            this.err.format("[ERROR] (%s) %s - %s\n", Thread.currentThread().getName(), msg, t);
            t.printStackTrace(this.err);
        }
    }

    private static class JdkLoggerFactory
    implements LoggerFactory {
        private JdkLoggerFactory() {
        }

        @Override
        public Logger getLogger(String name) {
            return new JdkLogger(java.util.logging.Logger.getLogger(name));
        }
    }

    private static class JdkLogger
    implements Logger {
        private final java.util.logging.Logger logger;

        public JdkLogger(java.util.logging.Logger logger) {
            this.logger = logger;
        }

        @Override
        public String getName() {
            return this.logger.getName();
        }

        @Override
        public boolean isTraceEnabled() {
            return this.logger.isLoggable(Level.FINEST);
        }

        @Override
        public void trace(String msg) {
            this.logger.log(Level.FINEST, msg);
        }

        @Override
        public void trace(String format, Object ... arguments) {
            this.logger.log(Level.FINEST, this.format(format, arguments));
        }

        @Override
        public void trace(String msg, Throwable t) {
            this.logger.log(Level.FINEST, msg, t);
        }

        @Override
        public boolean isDebugEnabled() {
            return this.logger.isLoggable(Level.FINE);
        }

        @Override
        public void debug(String msg) {
            this.logger.log(Level.FINE, msg);
        }

        @Override
        public void debug(String format, Object ... arguments) {
            this.logger.log(Level.FINE, this.format(format, arguments));
        }

        @Override
        public void debug(String msg, Throwable t) {
            this.logger.log(Level.FINE, msg, t);
        }

        @Override
        public boolean isInfoEnabled() {
            return this.logger.isLoggable(Level.INFO);
        }

        @Override
        public void info(String msg) {
            this.logger.log(Level.INFO, msg);
        }

        @Override
        public void info(String format, Object ... arguments) {
            this.logger.log(Level.INFO, this.format(format, arguments));
        }

        @Override
        public void info(String msg, Throwable t) {
            this.logger.log(Level.INFO, msg, t);
        }

        @Override
        public boolean isWarnEnabled() {
            return this.logger.isLoggable(Level.WARNING);
        }

        @Override
        public void warn(String msg) {
            this.logger.log(Level.WARNING, msg);
        }

        @Override
        public void warn(String format, Object ... arguments) {
            this.logger.log(Level.WARNING, this.format(format, arguments));
        }

        @Override
        public void warn(String msg, Throwable t) {
            this.logger.log(Level.WARNING, msg, t);
        }

        @Override
        public boolean isErrorEnabled() {
            return this.logger.isLoggable(Level.SEVERE);
        }

        @Override
        public void error(String msg) {
            this.logger.log(Level.SEVERE, msg);
        }

        @Override
        public void error(String format, Object ... arguments) {
            this.logger.log(Level.SEVERE, this.format(format, arguments));
        }

        @Override
        public void error(String msg, Throwable t) {
            this.logger.log(Level.SEVERE, msg, t);
        }

        @Nullable
        private String format(@Nullable String from, Object ... arguments) {
            if (from != null) {
                String computed = from;
                if (arguments != null && arguments.length != 0) {
                    for (Object argument : arguments) {
                        computed = computed.replaceFirst("\\{\\}", Matcher.quoteReplacement(argument.toString()));
                    }
                }
                return computed;
            }
            return null;
        }
    }

    private static class Slf4JLogger
    implements Logger {
        private final org.slf4j.Logger logger;

        public Slf4JLogger(org.slf4j.Logger logger) {
            this.logger = logger;
        }

        @Override
        public String getName() {
            return this.logger.getName();
        }

        @Override
        public boolean isTraceEnabled() {
            return this.logger.isTraceEnabled();
        }

        @Override
        public void trace(String msg) {
            this.logger.trace(msg);
        }

        @Override
        public void trace(String format, Object ... arguments) {
            this.logger.trace(format, arguments);
        }

        @Override
        public void trace(String msg, Throwable t) {
            this.logger.trace(msg, t);
        }

        @Override
        public boolean isDebugEnabled() {
            return this.logger.isDebugEnabled();
        }

        @Override
        public void debug(String msg) {
            this.logger.debug(msg);
        }

        @Override
        public void debug(String format, Object ... arguments) {
            this.logger.debug(format, arguments);
        }

        @Override
        public void debug(String msg, Throwable t) {
            this.logger.debug(msg, t);
        }

        @Override
        public boolean isInfoEnabled() {
            return this.logger.isInfoEnabled();
        }

        @Override
        public void info(String msg) {
            this.logger.info(msg);
        }

        @Override
        public void info(String format, Object ... arguments) {
            this.logger.info(format, arguments);
        }

        @Override
        public void info(String msg, Throwable t) {
            this.logger.info(msg, t);
        }

        @Override
        public boolean isWarnEnabled() {
            return this.logger.isWarnEnabled();
        }

        @Override
        public void warn(String msg) {
            this.logger.warn(msg);
        }

        @Override
        public void warn(String format, Object ... arguments) {
            this.logger.warn(format, arguments);
        }

        @Override
        public void warn(String msg, Throwable t) {
            this.logger.warn(msg, t);
        }

        @Override
        public boolean isErrorEnabled() {
            return this.logger.isErrorEnabled();
        }

        @Override
        public void error(String msg) {
            this.logger.error(msg);
        }

        @Override
        public void error(String format, Object ... arguments) {
            this.logger.error(format, arguments);
        }

        @Override
        public void error(String msg, Throwable t) {
            this.logger.error(msg, t);
        }
    }

    private static class Slf4JLoggerFactory
    implements LoggerFactory {
        private Slf4JLoggerFactory() {
        }

        @Override
        public Logger getLogger(String name) {
            return new Slf4JLogger(org.slf4j.LoggerFactory.getLogger(name));
        }
    }

    private static interface LoggerFactory {
        public Logger getLogger(String var1);
    }
}

