/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.transaction.operation.set;

import org.redisson.RedissonSet;
import org.redisson.api.RObject;
import org.redisson.client.codec.Codec;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.transaction.operation.TransactionalOperation;

public class MoveOperation
extends TransactionalOperation {
    private String destinationName;
    private Object value;
    private long threadId;

    public MoveOperation(RObject set, String destinationName, long threadId, Object value) {
        this(set.getName(), set.getCodec(), destinationName, threadId, value);
    }

    public MoveOperation(String name, Codec codec, String destinationName, long threadId, Object value) {
        super(name, codec);
        this.destinationName = destinationName;
        this.value = value;
        this.threadId = threadId;
    }

    @Override
    public void commit(CommandAsyncExecutor commandExecutor) {
        RedissonSet<Object> set = new RedissonSet<Object>(this.codec, commandExecutor, this.name, null);
        RedissonSet<Object> destinationSet = new RedissonSet<Object>(this.codec, commandExecutor, this.destinationName, null);
        set.moveAsync(destinationSet.getName(), this.value);
        destinationSet.getLock(this.value).unlockAsync(this.threadId);
        set.getLock(this.value).unlockAsync(this.threadId);
    }

    @Override
    public void rollback(CommandAsyncExecutor commandExecutor) {
        RedissonSet<Object> set = new RedissonSet<Object>(this.codec, commandExecutor, this.name, null);
        RedissonSet<Object> destinationSet = new RedissonSet<Object>(this.codec, commandExecutor, this.destinationName, null);
        destinationSet.getLock(this.value).unlockAsync(this.threadId);
        set.getLock(this.value).unlockAsync(this.threadId);
    }

    public String getDestinationName() {
        return this.destinationName;
    }

    public Object getValue() {
        return this.value;
    }

    public long getThreadId() {
        return this.threadId;
    }
}

