/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.liveobject.core;

import java.lang.reflect.Method;
import net.bytebuddy.implementation.bind.annotation.AllArguments;
import net.bytebuddy.implementation.bind.annotation.FieldProxy;
import net.bytebuddy.implementation.bind.annotation.FieldValue;
import net.bytebuddy.implementation.bind.annotation.Origin;
import net.bytebuddy.implementation.bind.annotation.RuntimeType;
import net.bytebuddy.implementation.bind.annotation.This;
import org.redisson.RedissonMap;
import org.redisson.api.RMap;
import org.redisson.api.RedissonClient;
import org.redisson.api.annotation.REntity;
import org.redisson.client.RedisException;
import org.redisson.client.codec.Codec;
import org.redisson.codec.ReferenceCodecProvider;
import org.redisson.liveobject.misc.ClassUtils;
import org.redisson.liveobject.resolver.NamingScheme;

public class LiveObjectInterceptor {
    private final RedissonClient redisson;
    private final ReferenceCodecProvider codecProvider;
    private final Class<?> originalClass;
    private final String idFieldName;
    private final Class<?> idFieldType;
    private final NamingScheme namingScheme;
    private final Class<? extends Codec> codecClass;

    public LiveObjectInterceptor(RedissonClient redisson, Class<?> entityClass, String idFieldName) {
        this.redisson = redisson;
        this.codecProvider = redisson.getConfig().getReferenceCodecProvider();
        this.originalClass = entityClass;
        this.idFieldName = idFieldName;
        REntity anno = ClassUtils.getAnnotation(entityClass, REntity.class);
        this.codecClass = anno.codec();
        try {
            this.namingScheme = anno.namingScheme().getDeclaredConstructor(Codec.class).newInstance(this.codecProvider.getCodec(anno, this.originalClass));
            this.idFieldType = ClassUtils.getDeclaredField(this.originalClass, idFieldName).getType();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    @RuntimeType
    public Object intercept(@Origin Method method, @AllArguments Object[] args, @This Object me, @FieldValue(value="liveObjectId") Object id, @FieldProxy(value="liveObjectId") Setter idSetter, @FieldProxy(value="liveObjectId") Getter idGetter, @FieldValue(value="liveObjectLiveMap") RMap<?, ?> map, @FieldProxy(value="liveObjectLiveMap") Setter mapSetter, @FieldProxy(value="liveObjectLiveMap") Getter mapGetter) throws Exception {
        if ("setLiveObjectId".equals(method.getName())) {
            String idKey;
            block11: {
                if (args[0].getClass().isArray()) {
                    throw new UnsupportedOperationException("RId value cannot be an array.");
                }
                idKey = this.getMapKey(args[0]);
                if (map != null) {
                    if (map.getName().equals(idKey)) {
                        return null;
                    }
                    try {
                        map.rename(this.getMapKey(args[0]));
                    }
                    catch (RedisException e) {
                        if (e.getMessage() != null && e.getMessage().startsWith("ERR no such key")) break block11;
                        throw e;
                    }
                }
            }
            RMap liveMap = this.redisson.getMap(idKey, this.codecProvider.getCodec(this.codecClass, RedissonMap.class, idKey));
            mapSetter.setValue(liveMap);
            return null;
        }
        if ("getLiveObjectId".equals(method.getName())) {
            if (map == null) {
                return null;
            }
            return this.namingScheme.resolveId(map.getName());
        }
        if ("getLiveObjectLiveMap".equals(method.getName())) {
            return map;
        }
        if ("isExists".equals(method.getName())) {
            return map.isExists();
        }
        if ("delete".equals(method.getName())) {
            return map.delete();
        }
        throw new NoSuchMethodException();
    }

    private String getMapKey(Object id) {
        return this.namingScheme.getName(this.originalClass, this.idFieldType, this.idFieldName, id);
    }

    public static interface Setter {
        public void setValue(Object var1);
    }

    public static interface Getter {
        public Object getValue();
    }
}

