/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import io.netty.buffer.ByteBuf;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.internal.PlatformDependent;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.redisson.RedissonMap;
import org.redisson.api.LocalCachedMapOptions;
import org.redisson.api.RFuture;
import org.redisson.api.RLocalCachedMap;
import org.redisson.api.RedissonClient;
import org.redisson.cache.Cache;
import org.redisson.cache.CacheKey;
import org.redisson.cache.LFUCacheMap;
import org.redisson.cache.LRUCacheMap;
import org.redisson.cache.LocalCacheListener;
import org.redisson.cache.LocalCachedMapClear;
import org.redisson.cache.LocalCachedMapInvalidate;
import org.redisson.cache.LocalCachedMapUpdate;
import org.redisson.cache.LocalCachedMessageCodec;
import org.redisson.cache.NoneCacheMap;
import org.redisson.cache.ReferenceCacheMap;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.convertor.NumberConvertor;
import org.redisson.client.protocol.decoder.ObjectMapEntryReplayDecoder;
import org.redisson.client.protocol.decoder.ObjectMapReplayDecoder;
import org.redisson.client.protocol.decoder.ObjectSetReplayDecoder;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.eviction.EvictionScheduler;
import org.redisson.misc.Hash;
import org.redisson.misc.RedissonPromise;

public class RedissonLocalCachedMap<K, V>
extends RedissonMap<K, V>
implements RLocalCachedMap<K, V> {
    public static final String TOPIC_SUFFIX = "topic";
    public static final String DISABLED_KEYS_SUFFIX = "disabled-keys";
    public static final String DISABLED_ACK_SUFFIX = ":topic";
    private static final RedisCommand<Set<Object>> ALL_KEYS = new RedisCommand("EVAL", new ObjectSetReplayDecoder(), RedisCommand.ValueType.MAP_KEY);
    private static final RedisCommand<Set<Map.Entry<Object, Object>>> ALL_ENTRIES = new RedisCommand<Set<Map.Entry<Object, Object>>>("EVAL", new ObjectMapEntryReplayDecoder(), RedisCommand.ValueType.MAP);
    private static final RedisCommand<Map<Object, Object>> ALL_MAP = new RedisCommand<Map<Object, Object>>("EVAL", new ObjectMapReplayDecoder(), RedisCommand.ValueType.MAP);
    private long cacheUpdateLogTime = TimeUnit.MINUTES.toMillis(10L);
    private byte[] instanceId;
    private Cache<CacheKey, CacheValue> cache;
    private int invalidateEntryOnChange;
    private LocalCachedMapOptions.SyncStrategy syncStrategy;
    private LocalCacheListener listener;

    public RedissonLocalCachedMap(CommandAsyncExecutor commandExecutor, String name, LocalCachedMapOptions<K, V> options, EvictionScheduler evictionScheduler, RedissonClient redisson) {
        super(commandExecutor, name, redisson, options);
        this.init(name, options, redisson, evictionScheduler);
    }

    public RedissonLocalCachedMap(Codec codec, CommandAsyncExecutor connectionManager, String name, LocalCachedMapOptions<K, V> options, EvictionScheduler evictionScheduler, RedissonClient redisson) {
        super(codec, connectionManager, name, redisson, options);
        this.init(name, options, redisson, evictionScheduler);
    }

    private void init(String name, LocalCachedMapOptions<K, V> options, RedissonClient redisson, EvictionScheduler evictionScheduler) {
        this.instanceId = RedissonLocalCachedMap.generateId();
        this.syncStrategy = options.getSyncStrategy();
        if (options.getSyncStrategy() != LocalCachedMapOptions.SyncStrategy.NONE) {
            this.invalidateEntryOnChange = 1;
        }
        if (options.getReconnectionStrategy() == LocalCachedMapOptions.ReconnectionStrategy.LOAD) {
            this.invalidateEntryOnChange = 2;
            evictionScheduler.schedule(this.listener.getUpdatesLogName(), this.cacheUpdateLogTime + TimeUnit.MINUTES.toMillis(1L));
        }
        this.cache = this.createCache(options);
        this.listener = new LocalCacheListener(name, this.commandExecutor, this.cache, this, this.instanceId, this.codec, options, this.cacheUpdateLogTime){

            @Override
            protected void updateCache(ByteBuf keyBuf, ByteBuf valueBuf) throws IOException {
                CacheKey cacheKey = RedissonLocalCachedMap.this.toCacheKey(keyBuf);
                Object key = RedissonLocalCachedMap.this.codec.getMapKeyDecoder().decode(keyBuf, null);
                Object value = RedissonLocalCachedMap.this.codec.getMapValueDecoder().decode(valueBuf, null);
                RedissonLocalCachedMap.this.cachePut(cacheKey, key, value);
            }
        };
        this.listener.add();
    }

    private void cachePut(CacheKey cacheKey, Object key, Object value) {
        if (this.listener.isDisabled(cacheKey)) {
            return;
        }
        this.cache.put(cacheKey, new CacheValue(key, value));
    }

    protected Cache<CacheKey, CacheValue> createCache(LocalCachedMapOptions<K, V> options) {
        if (options.getEvictionPolicy() == LocalCachedMapOptions.EvictionPolicy.NONE) {
            return new NoneCacheMap<CacheKey, CacheValue>(options.getTimeToLiveInMillis(), options.getMaxIdleInMillis());
        }
        if (options.getEvictionPolicy() == LocalCachedMapOptions.EvictionPolicy.LRU) {
            return new LRUCacheMap<CacheKey, CacheValue>(options.getCacheSize(), options.getTimeToLiveInMillis(), options.getMaxIdleInMillis());
        }
        if (options.getEvictionPolicy() == LocalCachedMapOptions.EvictionPolicy.LFU) {
            return new LFUCacheMap<CacheKey, CacheValue>(options.getCacheSize(), options.getTimeToLiveInMillis(), options.getMaxIdleInMillis());
        }
        if (options.getEvictionPolicy() == LocalCachedMapOptions.EvictionPolicy.SOFT) {
            return ReferenceCacheMap.soft(options.getTimeToLiveInMillis(), options.getMaxIdleInMillis());
        }
        if (options.getEvictionPolicy() == LocalCachedMapOptions.EvictionPolicy.WEAK) {
            return ReferenceCacheMap.weak(options.getTimeToLiveInMillis(), options.getMaxIdleInMillis());
        }
        throw new IllegalArgumentException("Invalid eviction policy: " + (Object)((Object)options.getEvictionPolicy()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheKey toCacheKey(Object key) {
        ByteBuf encoded = this.encodeMapKey(key);
        try {
            CacheKey cacheKey = this.toCacheKey(encoded);
            return cacheKey;
        }
        finally {
            encoded.release();
        }
    }

    private CacheKey toCacheKey(ByteBuf encodedKey) {
        return new CacheKey(Hash.hash128toArray(encodedKey));
    }

    @Override
    public RFuture<Boolean> containsKeyAsync(Object key) {
        this.checkKey(key);
        CacheKey cacheKey = this.toCacheKey(key);
        if (!this.cache.containsKey(cacheKey)) {
            return super.containsKeyAsync(key);
        }
        return RedissonPromise.newSucceededFuture(true);
    }

    @Override
    public RFuture<Boolean> containsValueAsync(Object value) {
        this.checkValue(value);
        CacheValue cacheValue = new CacheValue(null, value);
        if (!this.cache.containsValue(cacheValue)) {
            return super.containsValueAsync(value);
        }
        return RedissonPromise.newSucceededFuture(true);
    }

    @Override
    public RFuture<V> getAsync(final Object key) {
        this.checkKey(key);
        final CacheKey cacheKey = this.toCacheKey(key);
        CacheValue cacheValue = (CacheValue)this.cache.get(cacheKey);
        if (cacheValue != null && cacheValue.getValue() != null) {
            return RedissonPromise.newSucceededFuture(cacheValue.getValue());
        }
        RFuture future = super.getAsync(key);
        future.addListener(new FutureListener<V>(){

            @Override
            public void operationComplete(Future<V> future) throws Exception {
                if (!future.isSuccess()) {
                    return;
                }
                Object value = future.getNow();
                if (value != null) {
                    RedissonLocalCachedMap.this.cachePut(cacheKey, key, value);
                }
            }
        });
        return future;
    }

    protected static byte[] generateId() {
        byte[] id = new byte[16];
        PlatformDependent.threadLocalRandom().nextBytes(id);
        return id;
    }

    protected static byte[] generateLogEntryId(byte[] keyHash) {
        byte[] result = new byte[keyHash.length + 1 + 8];
        result[16] = 58;
        byte[] id = new byte[8];
        PlatformDependent.threadLocalRandom().nextBytes(id);
        System.arraycopy(keyHash, 0, result, 0, keyHash.length);
        System.arraycopy(id, 0, result, 17, id.length);
        return result;
    }

    @Override
    protected RFuture<V> putOperationAsync(K key, V value) {
        ByteBuf mapKey = this.encodeMapKey(key);
        ByteBuf mapValue = this.encodeMapValue(value);
        CacheKey cacheKey = this.toCacheKey(mapKey);
        byte[] entryId = RedissonLocalCachedMap.generateLogEntryId(cacheKey.getKeyHash());
        ByteBuf msg = this.createSyncMessage(mapKey, mapValue, cacheKey);
        this.cachePut(cacheKey, key, value);
        return this.commandExecutor.evalWriteAsync(this.getName(), this.codec, RedisCommands.EVAL_MAP_VALUE, "local v = redis.call('hget', KEYS[1], ARGV[1]); redis.call('hset', KEYS[1], ARGV[1], ARGV[2]); if ARGV[4] == '1' then redis.call('publish', KEYS[2], ARGV[3]); end;if ARGV[4] == '2' then redis.call('zadd', KEYS[3], ARGV[5], ARGV[6]);redis.call('publish', KEYS[2], ARGV[3]); end;return v; ", Arrays.asList(this.getName(), this.listener.getInvalidationTopicName(), this.listener.getUpdatesLogName()), mapKey, mapValue, msg, this.invalidateEntryOnChange, System.currentTimeMillis(), entryId);
    }

    protected ByteBuf createSyncMessage(ByteBuf mapKey, ByteBuf mapValue, CacheKey cacheKey) {
        if (this.syncStrategy == LocalCachedMapOptions.SyncStrategy.UPDATE) {
            return this.encode(new LocalCachedMapUpdate(mapKey, mapValue));
        }
        return this.encode(new LocalCachedMapInvalidate(this.instanceId, new byte[][]{cacheKey.getKeyHash()}));
    }

    @Override
    protected RFuture<Boolean> fastPutOperationAsync(K key, V value) {
        ByteBuf encodedKey = this.encodeMapKey(key);
        ByteBuf encodedValue = this.encodeMapValue(value);
        CacheKey cacheKey = this.toCacheKey(encodedKey);
        byte[] entryId = RedissonLocalCachedMap.generateLogEntryId(cacheKey.getKeyHash());
        ByteBuf msg = this.createSyncMessage(encodedKey, encodedValue, cacheKey);
        this.cachePut(cacheKey, key, value);
        return this.commandExecutor.evalWriteAsync(this.getName(), this.codec, RedisCommands.EVAL_BOOLEAN, "if ARGV[4] == '1' then redis.call('publish', KEYS[2], ARGV[3]); end;if ARGV[4] == '2' then redis.call('zadd', KEYS[3], ARGV[5], ARGV[6]);redis.call('publish', KEYS[2], ARGV[3]); end;if redis.call('hset', KEYS[1], ARGV[1], ARGV[2]) == 0 then return 0; end; return 1; ", Arrays.asList(this.getName(), this.listener.getInvalidationTopicName(), this.listener.getUpdatesLogName()), encodedKey, encodedValue, msg, this.invalidateEntryOnChange, System.currentTimeMillis(), entryId);
    }

    @Override
    public void destroy() {
        this.listener.remove();
    }

    @Override
    protected RFuture<V> removeOperationAsync(K key) {
        ByteBuf keyEncoded = this.encodeMapKey(key);
        CacheKey cacheKey = this.toCacheKey(keyEncoded);
        byte[] entryId = RedissonLocalCachedMap.generateLogEntryId(cacheKey.getKeyHash());
        ByteBuf msgEncoded = this.encode(new LocalCachedMapInvalidate(this.instanceId, new byte[][]{cacheKey.getKeyHash()}));
        this.cache.remove(cacheKey);
        return this.commandExecutor.evalWriteAsync(this.getName(), this.codec, RedisCommands.EVAL_MAP_VALUE, "local v = redis.call('hget', KEYS[1], ARGV[1]); if redis.call('hdel', KEYS[1], ARGV[1]) == 1 then if ARGV[3] == '1' then redis.call('publish', KEYS[2], ARGV[2]); end; if ARGV[3] == '2' then redis.call('zadd', KEYS[3], ARGV[4], ARGV[5]);redis.call('publish', KEYS[2], ARGV[2]); end;end; return v", Arrays.asList(this.getName(), this.listener.getInvalidationTopicName(), this.listener.getUpdatesLogName()), keyEncoded, msgEncoded, this.invalidateEntryOnChange, System.currentTimeMillis(), entryId);
    }

    @Override
    protected RFuture<List<Long>> fastRemoveOperationBatchAsync(K ... keys) {
        if (this.invalidateEntryOnChange == 1) {
            ArrayList<ByteBuf> params = new ArrayList<ByteBuf>(keys.length * 2);
            for (K k : keys) {
                ByteBuf keyEncoded = this.encodeMapKey(k);
                params.add(keyEncoded);
                CacheKey cacheKey = this.toCacheKey(keyEncoded);
                this.cache.remove(cacheKey);
                ByteBuf msgEncoded = this.encode(new LocalCachedMapInvalidate(this.instanceId, new byte[][]{cacheKey.getKeyHash()}));
                params.add(msgEncoded);
            }
            return this.commandExecutor.evalWriteAsync(this.getName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_LIST, "local result = {}; for j = 1, #ARGV, 2 do local val = redis.call('hdel', KEYS[1], ARGV[j]);if val == 1 then redis.call('publish', KEYS[2], ARGV[j+1]); end;table.insert(result, val);end;return result;", Arrays.asList(this.getName(), this.listener.getInvalidationTopicName()), params.toArray());
        }
        if (this.invalidateEntryOnChange == 2) {
            ArrayList<Object> params = new ArrayList<Object>(keys.length * 3);
            params.add(System.currentTimeMillis());
            for (K k : keys) {
                ByteBuf keyEncoded = this.encodeMapKey(k);
                params.add(keyEncoded);
                CacheKey cacheKey = this.toCacheKey(keyEncoded);
                this.cache.remove(cacheKey);
                ByteBuf msgEncoded = this.encode(new LocalCachedMapInvalidate(this.instanceId, new byte[][]{cacheKey.getKeyHash()}));
                params.add(msgEncoded);
                byte[] entryId = RedissonLocalCachedMap.generateLogEntryId(cacheKey.getKeyHash());
                params.add(entryId);
            }
            return this.commandExecutor.evalWriteAsync(this.getName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_LIST, "local result = {}; for j = 2, #ARGV, 3 do local val = redis.call('hdel', KEYS[1], ARGV[j]);if val == 1 then redis.call('zadd', KEYS[3], ARGV[1], ARGV[j+2]);redis.call('publish', KEYS[2], ARGV[j+1]); end;table.insert(result, val);end;return result;", Arrays.asList(this.getName(), this.listener.getInvalidationTopicName(), this.listener.getUpdatesLogName()), params.toArray());
        }
        ArrayList<ByteBuf> params = new ArrayList<ByteBuf>(keys.length);
        for (K k : keys) {
            ByteBuf keyEncoded = this.encodeMapKey(k);
            params.add(keyEncoded);
            CacheKey cacheKey = this.toCacheKey(keyEncoded);
            this.cache.remove(cacheKey);
        }
        RFuture<List<Long>> future = this.commandExecutor.evalWriteAsync(this.getName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_LIST, "local result = {}; for i = 1, #ARGV, 1 do local val = redis.call('hdel', KEYS[1], ARGV[i]); table.insert(result, val); end;return result;", Arrays.asList(this.getName()), params.toArray());
        return future;
    }

    @Override
    protected RFuture<Long> fastRemoveOperationAsync(K ... keys) {
        if (this.invalidateEntryOnChange == 1) {
            ArrayList<ByteBuf> params = new ArrayList<ByteBuf>(keys.length * 2);
            for (K k : keys) {
                ByteBuf keyEncoded = this.encodeMapKey(k);
                params.add(keyEncoded);
                CacheKey cacheKey = this.toCacheKey(keyEncoded);
                this.cache.remove(cacheKey);
                ByteBuf msgEncoded = this.encode(new LocalCachedMapInvalidate(this.instanceId, new byte[][]{cacheKey.getKeyHash()}));
                params.add(msgEncoded);
            }
            return this.commandExecutor.evalWriteAsync(this.getName(), this.codec, RedisCommands.EVAL_LONG, "local counter = 0; for j = 1, #ARGV, 2 do if redis.call('hdel', KEYS[1], ARGV[j]) == 1 then redis.call('publish', KEYS[2], ARGV[j+1]); counter = counter + 1;end;end;return counter;", Arrays.asList(this.getName(), this.listener.getInvalidationTopicName()), params.toArray());
        }
        if (this.invalidateEntryOnChange == 2) {
            ArrayList<Object> params = new ArrayList<Object>(keys.length * 3);
            params.add(System.currentTimeMillis());
            for (K k : keys) {
                ByteBuf keyEncoded = this.encodeMapKey(k);
                params.add(keyEncoded);
                CacheKey cacheKey = this.toCacheKey(keyEncoded);
                this.cache.remove(cacheKey);
                ByteBuf msgEncoded = this.encode(new LocalCachedMapInvalidate(this.instanceId, new byte[][]{cacheKey.getKeyHash()}));
                params.add(msgEncoded);
                byte[] entryId = RedissonLocalCachedMap.generateLogEntryId(cacheKey.getKeyHash());
                params.add(entryId);
            }
            return this.commandExecutor.evalWriteAsync(this.getName(), this.codec, RedisCommands.EVAL_LONG, "local counter = 0; for j = 2, #ARGV, 3 do if redis.call('hdel', KEYS[1], ARGV[j]) == 1 then redis.call('zadd', KEYS[3], ARGV[1], ARGV[j+2]);redis.call('publish', KEYS[2], ARGV[j+1]); counter = counter + 1;end;end;return counter;", Arrays.asList(this.getName(), this.listener.getInvalidationTopicName(), this.listener.getUpdatesLogName()), params.toArray());
        }
        ArrayList<Object> params = new ArrayList<Object>(keys.length + 1);
        params.add(this.getName());
        for (K k : keys) {
            ByteBuf keyEncoded = this.encodeMapKey(k);
            params.add(keyEncoded);
            CacheKey cacheKey = this.toCacheKey(keyEncoded);
            this.cache.remove(cacheKey);
        }
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.HDEL, params.toArray());
    }

    @Override
    public RFuture<Boolean> deleteAsync() {
        this.cache.clear();
        ByteBuf msgEncoded = this.encode(new LocalCachedMapClear());
        return this.commandExecutor.evalWriteAsync(this.getName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "if redis.call('del', KEYS[1], KEYS[3]) > 0 and ARGV[2] ~= '0' then redis.call('publish', KEYS[2], ARGV[1]); return 1;end; return 0;", Arrays.asList(this.getName(), this.listener.getInvalidationTopicName(), this.listener.getUpdatesLogName()), msgEncoded, this.invalidateEntryOnChange);
    }

    @Override
    public RFuture<Map<K, V>> getAllAsync(Set<K> keys) {
        if (keys.isEmpty()) {
            return RedissonPromise.newSucceededFuture(Collections.emptyMap());
        }
        final HashMap result = new HashMap();
        HashSet<K> mapKeys = new HashSet<K>(keys);
        Iterator iterator = mapKeys.iterator();
        while (iterator.hasNext()) {
            Object key = iterator.next();
            CacheKey cacheKey = this.toCacheKey(key);
            CacheValue value = (CacheValue)this.cache.get(cacheKey);
            if (value == null) continue;
            result.put(key, value.getValue());
            iterator.remove();
        }
        final RedissonPromise<Map<K, V>> promise = new RedissonPromise<Map<K, V>>();
        RFuture future = super.getAllAsync(mapKeys);
        future.addListener(new FutureListener<Map<K, V>>(){

            @Override
            public void operationComplete(Future<Map<K, V>> future) throws Exception {
                if (!future.isSuccess()) {
                    promise.tryFailure(future.cause());
                    return;
                }
                Map map = future.getNow();
                result.putAll(map);
                RedissonLocalCachedMap.this.cacheMap(map);
                promise.trySuccess(result);
            }
        });
        return promise;
    }

    private void cacheMap(Map<?, ?> map) {
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            CacheKey cacheKey = this.toCacheKey(entry.getKey());
            this.cachePut(cacheKey, entry.getKey(), entry.getValue());
        }
    }

    @Override
    protected RFuture<Void> putAllOperationAsync(final Map<? extends K, ? extends V> map) {
        ArrayList<Object> params = new ArrayList<Object>(map.size() * 3);
        params.add(this.invalidateEntryOnChange);
        params.add(map.size() * 2);
        byte[][] hashes = new byte[map.size()][];
        int i = 0;
        for (Map.Entry<K, V> t : map.entrySet()) {
            ByteBuf mapKey = this.encodeMapKey(t.getKey());
            ByteBuf mapValue = this.encodeMapValue(t.getValue());
            params.add(mapKey);
            params.add(mapValue);
            CacheKey cacheKey = this.toCacheKey(mapKey);
            hashes[i] = cacheKey.getKeyHash();
            ++i;
        }
        ByteBuf msgEncoded = null;
        if (this.syncStrategy == LocalCachedMapOptions.SyncStrategy.UPDATE) {
            ArrayList<LocalCachedMapUpdate.Entry> entries = new ArrayList<LocalCachedMapUpdate.Entry>();
            for (int j = 2; j < params.size(); j += 2) {
                ByteBuf key = (ByteBuf)params.get(j);
                ByteBuf value = (ByteBuf)params.get(j + 1);
                entries.add(new LocalCachedMapUpdate.Entry(key, value));
            }
            msgEncoded = this.encode(new LocalCachedMapUpdate(entries));
        } else {
            msgEncoded = this.encode(new LocalCachedMapInvalidate(this.instanceId, hashes));
        }
        if (this.invalidateEntryOnChange == 2) {
            long time = System.currentTimeMillis();
            for (byte[] hash : hashes) {
                byte[] entryId = RedissonLocalCachedMap.generateLogEntryId(hash);
                params.add(time);
                params.add(entryId);
            }
        }
        if (msgEncoded != null) {
            params.add(msgEncoded);
        }
        final RedissonPromise<Void> result = new RedissonPromise<Void>();
        RFuture future = this.commandExecutor.evalWriteAsync(this.getName(), this.codec, RedisCommands.EVAL_VOID, "for i=3, tonumber(ARGV[2]) + 2, 5000 do redis.call('hmset', KEYS[1], unpack(ARGV, i, math.min(i+4999, tonumber(ARGV[2]) + 2))); end; if ARGV[1] == '1' then redis.call('publish', KEYS[2], ARGV[#ARGV]); end;if ARGV[1] == '2' then for i=tonumber(ARGV[2]) + 2 + 1, #ARGV - 1, 5000 do redis.call('hmset', KEYS[3], unpack(ARGV, i, math.min(i+4999, #ARGV - 1))); end; redis.call('publish', KEYS[2], ARGV[#ARGV]); end;", Arrays.asList(this.getName(), this.listener.getInvalidationTopicName(), this.listener.getUpdatesLogName()), params.toArray());
        future.addListener(new FutureListener<Void>(){

            @Override
            public void operationComplete(Future<Void> future) throws Exception {
                if (!future.isSuccess()) {
                    result.tryFailure(future.cause());
                    return;
                }
                RedissonLocalCachedMap.this.cacheMap(map);
                result.trySuccess(null);
            }
        });
        return result;
    }

    @Override
    protected RFuture<V> addAndGetOperationAsync(final K key, Number value) {
        ByteBuf keyState = this.encodeMapKey(key);
        CacheKey cacheKey = this.toCacheKey(keyState);
        ByteBuf msg = this.encode(new LocalCachedMapInvalidate(this.instanceId, new byte[][]{cacheKey.getKeyHash()}));
        byte[] entryId = RedissonLocalCachedMap.generateLogEntryId(cacheKey.getKeyHash());
        RFuture future = this.commandExecutor.evalWriteAsync(this.getName(), (Codec)StringCodec.INSTANCE, new RedisCommand<Object>("EVAL", new NumberConvertor(value.getClass())), "local result = redis.call('HINCRBYFLOAT', KEYS[1], ARGV[1], ARGV[2]); if ARGV[3] == '1' then redis.call('publish', KEYS[2], ARGV[4]); end;if ARGV[3] == '2' then redis.call('zadd', KEYS[3], ARGV[5], ARGV[6]);redis.call('publish', KEYS[2], ARGV[4]); end;return result; ", Arrays.asList(this.getName(), this.listener.getInvalidationTopicName(), this.listener.getUpdatesLogName()), keyState, new BigDecimal(value.toString()).toPlainString(), this.invalidateEntryOnChange, msg, System.currentTimeMillis(), entryId);
        future.addListener(new FutureListener<V>(){

            @Override
            public void operationComplete(Future<V> future) throws Exception {
                if (!future.isSuccess()) {
                    return;
                }
                Object value = future.getNow();
                if (value != null) {
                    CacheKey cacheKey = RedissonLocalCachedMap.this.toCacheKey(key);
                    RedissonLocalCachedMap.this.cachePut(cacheKey, key, value);
                }
            }
        });
        return future;
    }

    @Override
    public RFuture<Boolean> fastPutIfAbsentAsync(final K key, final V value) {
        RFuture<Boolean> future = super.fastPutIfAbsentAsync(key, value);
        future.addListener(new FutureListener<Boolean>(){

            @Override
            public void operationComplete(Future<Boolean> future) throws Exception {
                if (!future.isSuccess()) {
                    return;
                }
                if (future.getNow().booleanValue()) {
                    CacheKey cacheKey = RedissonLocalCachedMap.this.toCacheKey(key);
                    RedissonLocalCachedMap.this.cachePut(cacheKey, key, value);
                }
            }
        });
        return future;
    }

    @Override
    public RFuture<Collection<V>> readAllValuesAsync() {
        final ArrayList<Object> result = new ArrayList<Object>();
        ArrayList<ByteBuf> mapKeys = new ArrayList<ByteBuf>();
        for (CacheValue value : this.cache.values()) {
            mapKeys.add(this.encodeMapKey(value.getKey()));
            result.add(value.getValue());
        }
        final RedissonPromise<Collection<V>> promise = new RedissonPromise<Collection<V>>();
        RFuture future = this.commandExecutor.evalReadAsync(this.getName(), this.codec, ALL_KEYS, "local entries = redis.call('hgetall', KEYS[1]); local result = {};for j, v in ipairs(entries) do if j % 2 ~= 0 then local founded = false;for i = 1, #ARGV, 1 do if ARGV[i] == entries[j] then founded = true;end;end; if founded == false then table.insert(result, entries[j+1]);end;end; end; return result; ", Arrays.asList(this.getName()), mapKeys.toArray());
        future.addListener(new FutureListener<Collection<V>>(){

            @Override
            public void operationComplete(Future<Collection<V>> future) throws Exception {
                if (!future.isSuccess()) {
                    promise.tryFailure(future.cause());
                    return;
                }
                result.addAll((Collection)future.get());
                promise.trySuccess(result);
            }
        });
        return promise;
    }

    @Override
    public RFuture<Map<K, V>> readAllMapAsync() {
        final HashMap<Object, Object> result = new HashMap<Object, Object>();
        ArrayList<Object> mapKeys = new ArrayList<Object>();
        for (CacheValue value : this.cache.values()) {
            mapKeys.add(this.encodeMapKey(value.getKey()));
            result.put(value.getKey(), value.getValue());
        }
        final RedissonPromise<Map<K, V>> promise = new RedissonPromise<Map<K, V>>();
        RFuture future = this.readAll(ALL_MAP, mapKeys, result);
        future.addListener(new FutureListener<Map<K, V>>(){

            @Override
            public void operationComplete(Future<Map<K, V>> future) throws Exception {
                if (!future.isSuccess()) {
                    promise.tryFailure(future.cause());
                    return;
                }
                for (Map.Entry entry : future.getNow().entrySet()) {
                    CacheKey cacheKey = RedissonLocalCachedMap.this.toCacheKey(entry.getKey());
                    RedissonLocalCachedMap.this.cachePut(cacheKey, entry.getKey(), entry.getValue());
                }
                result.putAll(future.getNow());
                promise.trySuccess(result);
            }
        });
        return promise;
    }

    @Override
    public void preloadCache() {
        for (Map.Entry entry : super.entrySet()) {
            CacheKey cacheKey = this.toCacheKey(entry.getKey());
            this.cachePut(cacheKey, entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clearLocalCache() {
        this.get(this.clearLocalCacheAsync());
    }

    @Override
    public RFuture<Void> clearLocalCacheAsync() {
        return this.listener.clearLocalCacheAsync();
    }

    @Override
    public RFuture<Set<Map.Entry<K, V>>> readAllEntrySetAsync() {
        final HashSet<AbstractMap.SimpleEntry<Object, Object>> result = new HashSet<AbstractMap.SimpleEntry<Object, Object>>();
        ArrayList<Object> mapKeys = new ArrayList<Object>();
        for (CacheValue value : this.cache.values()) {
            mapKeys.add(this.encodeMapKey(value.getKey()));
            result.add(new AbstractMap.SimpleEntry<Object, Object>(value.getKey(), value.getValue()));
        }
        final RedissonPromise<Set<Map.Entry<K, V>>> promise = new RedissonPromise<Set<Map.Entry<K, V>>>();
        RFuture future = this.readAll(ALL_ENTRIES, mapKeys, result);
        future.addListener(new FutureListener<Set<Map.Entry<K, V>>>(){

            @Override
            public void operationComplete(Future<Set<Map.Entry<K, V>>> future) throws Exception {
                if (!future.isSuccess()) {
                    promise.tryFailure(future.cause());
                    return;
                }
                for (Map.Entry entry : future.getNow()) {
                    CacheKey cacheKey = RedissonLocalCachedMap.this.toCacheKey(entry.getKey());
                    RedissonLocalCachedMap.this.cachePut(cacheKey, entry.getKey(), entry.getValue());
                }
                result.addAll(future.getNow());
                promise.trySuccess(result);
            }
        });
        return promise;
    }

    private <R> RFuture<R> readAll(RedisCommand<?> evalCommandType, List<Object> mapKeys, R result) {
        return this.commandExecutor.evalReadAsync(this.getName(), this.codec, evalCommandType, "local entries = redis.call('hgetall', KEYS[1]); local result = {};for j, v in ipairs(entries) do if j % 2 ~= 0 then local founded = false;for i = 1, #ARGV, 1 do if ARGV[i] == entries[j] then founded = true;end;end; if founded == false then table.insert(result, entries[j]);table.insert(result, entries[j+1]);end;end; end; return result; ", Arrays.asList(this.getName()), mapKeys.toArray());
    }

    @Override
    public RFuture<Boolean> fastReplaceAsync(final K key, final V value) {
        RFuture<Boolean> future = super.fastReplaceAsync(key, value);
        future.addListener(new FutureListener<Boolean>(){

            @Override
            public void operationComplete(Future<Boolean> future) throws Exception {
                if (!future.isSuccess()) {
                    return;
                }
                if (future.getNow().booleanValue()) {
                    CacheKey cacheKey = RedissonLocalCachedMap.this.toCacheKey(key);
                    RedissonLocalCachedMap.this.cachePut(cacheKey, key, value);
                }
            }
        });
        return future;
    }

    @Override
    protected RFuture<Boolean> fastReplaceOperationAsync(K key, V value) {
        ByteBuf keyState = this.encodeMapKey(key);
        ByteBuf valueState = this.encodeMapValue(value);
        CacheKey cacheKey = this.toCacheKey(keyState);
        byte[] entryId = RedissonLocalCachedMap.generateLogEntryId(cacheKey.getKeyHash());
        ByteBuf msg = this.createSyncMessage(keyState, valueState, cacheKey);
        return this.commandExecutor.evalWriteAsync(this.getName(key), this.codec, RedisCommands.EVAL_BOOLEAN, "if redis.call('hexists', KEYS[1], ARGV[1]) == 1 then redis.call('hset', KEYS[1], ARGV[1], ARGV[2]); if ARGV[3] == '1' then redis.call('publish', KEYS[2], ARGV[4]); end;if ARGV[3] == '2' then redis.call('zadd', KEYS[3], ARGV[5], ARGV[6]);redis.call('publish', KEYS[2], ARGV[4]); end;return 1; else return 0; end", Arrays.asList(this.getName(key), this.listener.getInvalidationTopicName(), this.listener.getUpdatesLogName()), keyState, valueState, this.invalidateEntryOnChange, msg, System.currentTimeMillis(), entryId);
    }

    @Override
    protected RFuture<V> replaceOperationAsync(K key, V value) {
        ByteBuf keyState = this.encodeMapKey(key);
        ByteBuf valueState = this.encodeMapValue(value);
        CacheKey cacheKey = this.toCacheKey(keyState);
        byte[] entryId = RedissonLocalCachedMap.generateLogEntryId(cacheKey.getKeyHash());
        ByteBuf msg = this.createSyncMessage(keyState, valueState, cacheKey);
        return this.commandExecutor.evalWriteAsync(this.getName(key), this.codec, RedisCommands.EVAL_MAP_VALUE, "if redis.call('hexists', KEYS[1], ARGV[1]) == 1 then local v = redis.call('hget', KEYS[1], ARGV[1]); redis.call('hset', KEYS[1], ARGV[1], ARGV[2]); if ARGV[3] == '1' then redis.call('publish', KEYS[2], ARGV[4]); end;if ARGV[3] == '2' then redis.call('zadd', KEYS[3], ARGV[5], ARGV[6]);redis.call('publish', KEYS[2], ARGV[4]); end;return v; else return nil; end", Arrays.asList(this.getName(key), this.listener.getInvalidationTopicName(), this.listener.getUpdatesLogName()), keyState, valueState, this.invalidateEntryOnChange, msg, System.currentTimeMillis(), entryId);
    }

    @Override
    public RFuture<V> replaceAsync(final K key, final V value) {
        RFuture<V> future = super.replaceAsync(key, value);
        future.addListener(new FutureListener<V>(){

            @Override
            public void operationComplete(Future<V> future) throws Exception {
                if (!future.isSuccess()) {
                    return;
                }
                if (future.getNow() != null) {
                    CacheKey cacheKey = RedissonLocalCachedMap.this.toCacheKey(key);
                    RedissonLocalCachedMap.this.cachePut(cacheKey, key, value);
                }
            }
        });
        return future;
    }

    @Override
    protected RFuture<Boolean> replaceOperationAsync(K key, V oldValue, V newValue) {
        ByteBuf keyState = this.encodeMapKey(key);
        ByteBuf oldValueState = this.encodeMapValue(oldValue);
        ByteBuf newValueState = this.encodeMapValue(newValue);
        CacheKey cacheKey = this.toCacheKey(keyState);
        byte[] entryId = RedissonLocalCachedMap.generateLogEntryId(cacheKey.getKeyHash());
        ByteBuf msg = this.createSyncMessage(keyState, newValueState, cacheKey);
        return this.commandExecutor.evalWriteAsync(this.getName(key), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "if redis.call('hget', KEYS[1], ARGV[1]) == ARGV[2] then redis.call('hset', KEYS[1], ARGV[1], ARGV[3]); if ARGV[4] == '1' then redis.call('publish', KEYS[2], ARGV[5]); end;if ARGV[4] == '2' then redis.call('zadd', KEYS[3], ARGV[6], ARGV[7]);redis.call('publish', KEYS[2], ARGV[5]); end;return 1; else return 0; end", Arrays.asList(this.getName(key), this.listener.getInvalidationTopicName(), this.listener.getUpdatesLogName()), keyState, oldValueState, newValueState, this.invalidateEntryOnChange, msg, System.currentTimeMillis(), entryId);
    }

    @Override
    public RFuture<Boolean> replaceAsync(final K key, V oldValue, final V newValue) {
        final CacheKey cacheKey = this.toCacheKey(key);
        RFuture<Boolean> future = super.replaceAsync(key, oldValue, newValue);
        future.addListener(new FutureListener<Boolean>(){

            @Override
            public void operationComplete(Future<Boolean> future) throws Exception {
                if (!future.isSuccess()) {
                    return;
                }
                if (future.getNow().booleanValue()) {
                    RedissonLocalCachedMap.this.cachePut(cacheKey, key, newValue);
                }
            }
        });
        return future;
    }

    @Override
    protected RFuture<Boolean> removeOperationAsync(Object key, Object value) {
        ByteBuf keyState = this.encodeMapKey(key);
        ByteBuf valueState = this.encodeMapValue(value);
        CacheKey cacheKey = this.toCacheKey(keyState);
        byte[] entryId = RedissonLocalCachedMap.generateLogEntryId(cacheKey.getKeyHash());
        ByteBuf msg = this.encode(new LocalCachedMapInvalidate(this.instanceId, new byte[][]{cacheKey.getKeyHash()}));
        return this.commandExecutor.evalWriteAsync(this.getName(key), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "if redis.call('hget', KEYS[1], ARGV[1]) == ARGV[2] then if ARGV[3] == '1' then redis.call('publish', KEYS[2], ARGV[4]); end;if ARGV[3] == '2' then redis.call('zadd', KEYS[3], ARGV[5], ARGV[6]);redis.call('publish', KEYS[2], ARGV[4]); end;return redis.call('hdel', KEYS[1], ARGV[1]) else return 0 end", Arrays.asList(this.getName(key), this.listener.getInvalidationTopicName(), this.listener.getUpdatesLogName()), keyState, valueState, this.invalidateEntryOnChange, msg, System.currentTimeMillis(), entryId);
    }

    @Override
    public RFuture<Boolean> removeAsync(Object key, Object value) {
        final CacheKey cacheKey = this.toCacheKey(key);
        RFuture<Boolean> future = super.removeAsync(key, value);
        future.addListener(new FutureListener<Boolean>(){

            @Override
            public void operationComplete(Future<Boolean> future) throws Exception {
                if (!future.isSuccess()) {
                    return;
                }
                if (future.getNow().booleanValue()) {
                    RedissonLocalCachedMap.this.cache.remove(cacheKey);
                }
            }
        });
        return future;
    }

    @Override
    public RFuture<V> putIfAbsentAsync(final K key, final V value) {
        RFuture<V> future = super.putIfAbsentAsync(key, value);
        future.addListener(new FutureListener<V>(){

            @Override
            public void operationComplete(Future<V> future) throws Exception {
                if (!future.isSuccess()) {
                    return;
                }
                if (future.getNow() == null) {
                    CacheKey cacheKey = RedissonLocalCachedMap.this.toCacheKey(key);
                    RedissonLocalCachedMap.this.cachePut(cacheKey, key, value);
                }
            }
        });
        return future;
    }

    @Override
    public ByteBuf encode(Object value) {
        try {
            return LocalCachedMessageCodec.INSTANCE.getValueEncoder().encode(value);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static class CacheValue
    implements Serializable {
        private final Object key;
        private final Object value;

        public CacheValue(Object key, Object value) {
            this.key = key;
            this.value = value;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CacheValue other = (CacheValue)obj;
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }

        public String toString() {
            return "CacheValue [key=" + this.key + ", value=" + this.value + "]";
        }
    }
}

