/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import io.netty.buffer.ByteBuf;
import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.ScheduledFuture;
import io.netty.util.internal.PlatformDependent;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RBlockingQueue;
import org.redisson.api.RFuture;
import org.redisson.api.RList;
import org.redisson.api.RMap;
import org.redisson.api.RedissonClient;
import org.redisson.api.RemoteInvocationOptions;
import org.redisson.api.annotation.RRemoteAsync;
import org.redisson.client.RedisException;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.codec.CompositeCodec;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.executor.RemotePromise;
import org.redisson.misc.RPromise;
import org.redisson.misc.RedissonPromise;
import org.redisson.remote.RRemoteServiceResponse;
import org.redisson.remote.RemoteServiceAck;
import org.redisson.remote.RemoteServiceAckTimeoutException;
import org.redisson.remote.RemoteServiceCancelRequest;
import org.redisson.remote.RemoteServiceCancelResponse;
import org.redisson.remote.RemoteServiceRequest;
import org.redisson.remote.RemoteServiceResponse;
import org.redisson.remote.RemoteServiceTimeoutException;
import org.redisson.remote.RequestId;
import org.redisson.remote.ResponseEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseRemoteService {
    private static final Logger log = LoggerFactory.getLogger(BaseRemoteService.class);
    private final Map<Class<?>, String> requestQueueNameCache = PlatformDependent.newConcurrentHashMap();
    private final ConcurrentMap<Method, List<String>> methodSignaturesCache = PlatformDependent.newConcurrentHashMap();
    protected final Codec codec;
    protected final RedissonClient redisson;
    protected final String name;
    protected final CommandAsyncExecutor commandExecutor;
    protected final String executorId;
    protected final String cancelRequestMapName;
    protected final String cancelResponseMapName;
    protected final String responseQueueName;
    private final ConcurrentMap<String, ResponseEntry> responses;

    public BaseRemoteService(Codec codec, RedissonClient redisson, String name, CommandAsyncExecutor commandExecutor, String executorId, ConcurrentMap<String, ResponseEntry> responses) {
        this.codec = codec;
        this.redisson = redisson;
        this.name = name;
        this.commandExecutor = commandExecutor;
        this.executorId = executorId;
        this.responses = responses;
        this.cancelRequestMapName = "{" + name + ":remote}:cancel-request";
        this.cancelResponseMapName = "{" + name + ":remote}:cancel-response";
        this.responseQueueName = this.getResponseQueueName(executorId);
    }

    public String getResponseQueueName(String executorId) {
        return "{remote_response}:" + executorId;
    }

    protected String getAckName(RequestId requestId) {
        return "{" + this.name + ":remote}:" + requestId + ":ack";
    }

    protected String getAckName(String requestId) {
        return "{" + this.name + ":remote}:" + requestId + ":ack";
    }

    public String getRequestQueueName(Class<?> remoteInterface) {
        String str = this.requestQueueNameCache.get(remoteInterface);
        if (str == null) {
            str = "{" + this.name + ":" + remoteInterface.getName() + "}";
            this.requestQueueNameCache.put(remoteInterface, str);
        }
        return str;
    }

    protected ByteBuf encode(Object obj) {
        try {
            return this.codec.getValueEncoder().encode(obj);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public <T> T get(Class<T> remoteInterface) {
        return this.get(remoteInterface, RemoteInvocationOptions.defaults());
    }

    public <T> T get(Class<T> remoteInterface, long executionTimeout, TimeUnit executionTimeUnit) {
        return this.get(remoteInterface, RemoteInvocationOptions.defaults().expectResultWithin(executionTimeout, executionTimeUnit));
    }

    public <T> T get(Class<T> remoteInterface, long executionTimeout, TimeUnit executionTimeUnit, long ackTimeout, TimeUnit ackTimeUnit) {
        return this.get(remoteInterface, RemoteInvocationOptions.defaults().expectAckWithin(ackTimeout, ackTimeUnit).expectResultWithin(executionTimeout, executionTimeUnit));
    }

    public <T> T get(Class<T> remoteInterface, RemoteInvocationOptions options) {
        for (Annotation annotation : remoteInterface.getAnnotations()) {
            if (annotation.annotationType() != RRemoteAsync.class) continue;
            Class<?> syncInterface = ((RRemoteAsync)annotation).value();
            for (Method m : remoteInterface.getMethods()) {
                try {
                    syncInterface.getMethod(m.getName(), m.getParameterTypes());
                }
                catch (NoSuchMethodException e) {
                    throw new IllegalArgumentException("Method '" + m.getName() + "' with params '" + Arrays.toString(m.getParameterTypes()) + "' isn't defined in " + syncInterface);
                }
                catch (SecurityException e) {
                    throw new IllegalArgumentException(e);
                }
                if (m.getReturnType().getClass().isInstance(RFuture.class)) continue;
                throw new IllegalArgumentException(m.getReturnType().getClass() + " isn't allowed as return type");
            }
            return this.async(remoteInterface, options, syncInterface);
        }
        return this.sync(remoteInterface, options);
    }

    private <T> T async(final Class<T> remoteInterface, RemoteInvocationOptions options, final Class<?> syncInterface) {
        final RemoteInvocationOptions optionsCopy = new RemoteInvocationOptions(options);
        InvocationHandler handler = new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                final RequestId requestId = BaseRemoteService.this.generateRequestId();
                if (method.getName().equals("toString")) {
                    return this.getClass().getSimpleName() + "-" + remoteInterface.getSimpleName() + "-proxy-" + requestId;
                }
                if (method.getName().equals("equals")) {
                    return proxy == args[0];
                }
                if (method.getName().equals("hashCode")) {
                    return (this.getClass().getSimpleName() + "-" + remoteInterface.getSimpleName() + "-proxy-" + requestId).hashCode();
                }
                if (!(optionsCopy.isResultExpected() || method.getReturnType().equals(Void.class) || method.getReturnType().equals(Void.TYPE) || method.getReturnType().equals(RFuture.class))) {
                    throw new IllegalArgumentException("The noResult option only supports void return value");
                }
                final String requestQueueName = BaseRemoteService.this.getRequestQueueName(syncInterface);
                final Long ackTimeout = optionsCopy.getAckTimeoutInMillis();
                final RemotePromise<Object> result = new RemotePromise<Object>(requestId){

                    @Override
                    public boolean cancel(boolean mayInterruptIfRunning) {
                        if (this.isCancelled()) {
                            return true;
                        }
                        if (this.isDone()) {
                            return false;
                        }
                        if (optionsCopy.isAckExpected()) {
                            String ackName = BaseRemoteService.this.getAckName(requestId);
                            RFuture future = BaseRemoteService.this.commandExecutor.evalWriteAsync(BaseRemoteService.this.responseQueueName, (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "if redis.call('setnx', KEYS[1], 1) == 1 then redis.call('pexpire', KEYS[1], ARGV[1]);return 1;end;return 0;", Arrays.asList(ackName), ackTimeout);
                            boolean ackNotSent = (Boolean)BaseRemoteService.this.commandExecutor.get(future);
                            if (ackNotSent) {
                                RList list = BaseRemoteService.this.redisson.getList(requestQueueName, LongCodec.INSTANCE);
                                list.remove(requestId.toString());
                                super.cancel(mayInterruptIfRunning);
                                return true;
                            }
                            return this.doCancel(mayInterruptIfRunning);
                        }
                        boolean removed = BaseRemoteService.this.commandExecutor.get(BaseRemoteService.this.removeAsync(requestQueueName, requestId));
                        if (removed) {
                            super.cancel(mayInterruptIfRunning);
                            return true;
                        }
                        return this.doCancel(mayInterruptIfRunning);
                    }

                    private boolean doCancel(boolean mayInterruptIfRunning) {
                        if (this.isCancelled()) {
                            return true;
                        }
                        if (this.isDone()) {
                            return false;
                        }
                        BaseRemoteService.this.cancelExecution(optionsCopy, mayInterruptIfRunning, this);
                        try {
                            this.awaitUninterruptibly(60L, TimeUnit.SECONDS);
                        }
                        catch (CancellationException cancellationException) {
                            // empty catch block
                        }
                        return this.isCancelled();
                    }
                };
                RemoteServiceRequest request = new RemoteServiceRequest(BaseRemoteService.this.executorId, requestId.toString(), method.getName(), BaseRemoteService.this.getMethodSignatures(method), args, optionsCopy, System.currentTimeMillis());
                final RPromise ackFuture = optionsCopy.isAckExpected() ? BaseRemoteService.this.poll(optionsCopy.getAckTimeoutInMillis(), requestId, false) : null;
                final RPromise responseFuture = optionsCopy.isResultExpected() ? BaseRemoteService.this.poll(optionsCopy.getExecutionTimeoutInMillis(), requestId, false) : null;
                RFuture<Boolean> addFuture = BaseRemoteService.this.addAsync(requestQueueName, request, result);
                addFuture.addListener(new FutureListener<Boolean>(){

                    @Override
                    public void operationComplete(Future<Boolean> future) throws Exception {
                        if (!future.isSuccess()) {
                            if (responseFuture != null) {
                                responseFuture.cancel(false);
                            }
                            if (ackFuture != null) {
                                ackFuture.cancel(false);
                            }
                            result.tryFailure(future.cause());
                            return;
                        }
                        if (!((Boolean)future.get()).booleanValue()) {
                            result.tryFailure(new RedisException("Task hasn't been added"));
                            if (responseFuture != null) {
                                responseFuture.cancel(false);
                            }
                            if (ackFuture != null) {
                                ackFuture.cancel(false);
                            }
                            return;
                        }
                        if (optionsCopy.isAckExpected()) {
                            ackFuture.addListener(new FutureListener<RemoteServiceAck>(){

                                @Override
                                public void operationComplete(Future<RemoteServiceAck> future) throws Exception {
                                    if (!future.isSuccess()) {
                                        if (responseFuture != null) {
                                            responseFuture.cancel(false);
                                        }
                                        result.tryFailure(future.cause());
                                        return;
                                    }
                                    RemoteServiceAck ack = future.getNow();
                                    if (ack == null) {
                                        final String ackName = BaseRemoteService.this.getAckName(requestId);
                                        RFuture ackFutureAttempt = BaseRemoteService.this.tryPollAckAgainAsync(optionsCopy, ackName, requestId);
                                        ackFutureAttempt.addListener(new FutureListener<RemoteServiceAck>(){

                                            @Override
                                            public void operationComplete(Future<RemoteServiceAck> future) throws Exception {
                                                if (!future.isSuccess()) {
                                                    result.tryFailure(future.cause());
                                                    return;
                                                }
                                                if (future.getNow() == null) {
                                                    RemoteServiceAckTimeoutException ex = new RemoteServiceAckTimeoutException("No ACK response after " + optionsCopy.getAckTimeoutInMillis() + "ms for request: " + requestId);
                                                    result.tryFailure(ex);
                                                    return;
                                                }
                                                BaseRemoteService.this.awaitResultAsync(optionsCopy, result, ackName, responseFuture);
                                            }
                                        });
                                    } else {
                                        BaseRemoteService.this.awaitResultAsync(optionsCopy, result, responseFuture);
                                    }
                                }
                            });
                        } else {
                            BaseRemoteService.this.awaitResultAsync(optionsCopy, result, responseFuture);
                        }
                    }
                });
                return result;
            }
        };
        return (T)Proxy.newProxyInstance(remoteInterface.getClassLoader(), new Class[]{remoteInterface}, handler);
    }

    private void awaitResultAsync(final RemoteInvocationOptions optionsCopy, final RemotePromise<Object> result, String ackName, final RFuture<RRemoteServiceResponse> responseFuture) {
        RFuture<Boolean> deleteFuture = this.redisson.getBucket(ackName).deleteAsync();
        deleteFuture.addListener(new FutureListener<Boolean>(){

            @Override
            public void operationComplete(Future<Boolean> future) throws Exception {
                if (!future.isSuccess()) {
                    result.tryFailure(future.cause());
                    return;
                }
                BaseRemoteService.this.awaitResultAsync(optionsCopy, result, responseFuture);
            }
        });
    }

    protected void awaitResultAsync(final RemoteInvocationOptions optionsCopy, final RemotePromise<Object> result, RFuture<RRemoteServiceResponse> responseFuture) {
        if (!optionsCopy.isResultExpected()) {
            return;
        }
        responseFuture.addListener(new FutureListener<RRemoteServiceResponse>(){

            @Override
            public void operationComplete(Future<RRemoteServiceResponse> future) throws Exception {
                if (!future.isSuccess()) {
                    result.tryFailure(future.cause());
                    return;
                }
                if (future.getNow() == null) {
                    RemoteServiceTimeoutException e = new RemoteServiceTimeoutException("No response after " + optionsCopy.getExecutionTimeoutInMillis() + "ms for request: " + result.getRequestId());
                    result.tryFailure(e);
                    return;
                }
                if (future.getNow() instanceof RemoteServiceCancelResponse) {
                    result.doCancel();
                    return;
                }
                RemoteServiceResponse response = (RemoteServiceResponse)future.getNow();
                if (response.getError() != null) {
                    result.tryFailure(response.getError());
                    return;
                }
                result.trySuccess(response.getResult());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends RRemoteServiceResponse> RPromise<T> poll(final long timeout, final RequestId requestId, boolean insertFirst) {
        ResponseEntry entry;
        final RedissonPromise responseFuture = new RedissonPromise();
        ConcurrentMap<String, ResponseEntry> concurrentMap = this.responses;
        synchronized (concurrentMap) {
            ResponseEntry oldEntry;
            entry = (ResponseEntry)this.responses.get(this.responseQueueName);
            if (entry == null && (oldEntry = this.responses.putIfAbsent(this.responseQueueName, entry = new ResponseEntry())) != null) {
                entry = oldEntry;
            }
            responseFuture.addListener(new FutureListener<T>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void operationComplete(Future<T> future) throws Exception {
                    if (future.isCancelled()) {
                        ConcurrentMap concurrentMap = BaseRemoteService.this.responses;
                        synchronized (concurrentMap) {
                            ResponseEntry entry = (ResponseEntry)BaseRemoteService.this.responses.get(BaseRemoteService.this.responseQueueName);
                            List<ResponseEntry.Result> list = entry.getResponses().get(requestId);
                            if (list == null) {
                                return;
                            }
                            Iterator<ResponseEntry.Result> iterator = list.iterator();
                            while (iterator.hasNext()) {
                                ResponseEntry.Result result = iterator.next();
                                if (result.getPromise() != responseFuture) continue;
                                result.getScheduledFuture().cancel(true);
                                iterator.remove();
                            }
                            if (list.isEmpty()) {
                                entry.getResponses().remove(requestId);
                            }
                            if (entry.getResponses().isEmpty()) {
                                BaseRemoteService.this.responses.remove(BaseRemoteService.this.responseQueueName, entry);
                            }
                        }
                    }
                }
            });
            ScheduledFuture<?> future = this.commandExecutor.getConnectionManager().getGroup().schedule(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    ConcurrentMap concurrentMap = BaseRemoteService.this.responses;
                    synchronized (concurrentMap) {
                        ResponseEntry entry = (ResponseEntry)BaseRemoteService.this.responses.get(BaseRemoteService.this.responseQueueName);
                        if (entry == null) {
                            return;
                        }
                        RemoteServiceTimeoutException ex = new RemoteServiceTimeoutException("No response after " + timeout + "ms");
                        if (responseFuture.tryFailure(ex)) {
                            List<ResponseEntry.Result> list = entry.getResponses().get(requestId);
                            list.remove(0);
                            if (list.isEmpty()) {
                                entry.getResponses().remove(requestId);
                            }
                            if (entry.getResponses().isEmpty()) {
                                BaseRemoteService.this.responses.remove(BaseRemoteService.this.responseQueueName, entry);
                            }
                        }
                    }
                }
            }, timeout, TimeUnit.MILLISECONDS);
            Map<RequestId, List<ResponseEntry.Result>> entryResponses = entry.getResponses();
            List<ResponseEntry.Result> list = entryResponses.get(requestId);
            if (list == null) {
                list = new ArrayList<ResponseEntry.Result>(3);
                entryResponses.put(requestId, list);
            }
            ResponseEntry.Result res = new ResponseEntry.Result(responseFuture, future);
            if (insertFirst) {
                list.add(0, res);
            } else {
                list.add(res);
            }
        }
        this.pollTasks(entry);
        return responseFuture;
    }

    private void pollTasks(ResponseEntry entry) {
        if (!entry.getStarted().compareAndSet(false, true)) {
            return;
        }
        RBlockingQueue responseQueue = this.redisson.getBlockingQueue(this.responseQueueName, this.codec);
        RFuture<RRemoteServiceResponse> future = responseQueue.takeAsync();
        future.addListener(new FutureListener<RRemoteServiceResponse>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void operationComplete(Future<RRemoteServiceResponse> future) throws Exception {
                RPromise<RRemoteServiceResponse> promise;
                if (!future.isSuccess()) {
                    log.error("Can't get response from " + BaseRemoteService.this.responseQueueName, future.cause());
                    return;
                }
                RRemoteServiceResponse response = future.getNow();
                ConcurrentMap concurrentMap = BaseRemoteService.this.responses;
                synchronized (concurrentMap) {
                    ResponseEntry entry = (ResponseEntry)BaseRemoteService.this.responses.get(BaseRemoteService.this.responseQueueName);
                    if (entry == null) {
                        return;
                    }
                    RequestId key = new RequestId(response.getId());
                    List<ResponseEntry.Result> list = entry.getResponses().get(key);
                    if (list == null) {
                        RBlockingQueue responseQueue = BaseRemoteService.this.redisson.getBlockingQueue(BaseRemoteService.this.responseQueueName, BaseRemoteService.this.codec);
                        responseQueue.takeAsync().addListener(this);
                        return;
                    }
                    ResponseEntry.Result res = list.remove(0);
                    if (list.isEmpty()) {
                        entry.getResponses().remove(key);
                    }
                    promise = res.getPromise();
                    res.getScheduledFuture().cancel(true);
                    if (entry.getResponses().isEmpty()) {
                        BaseRemoteService.this.responses.remove(BaseRemoteService.this.responseQueueName, entry);
                    } else {
                        RBlockingQueue responseQueue = BaseRemoteService.this.redisson.getBlockingQueue(BaseRemoteService.this.responseQueueName, BaseRemoteService.this.codec);
                        responseQueue.takeAsync().addListener(this);
                    }
                }
                if (promise != null) {
                    promise.trySuccess(response);
                }
            }
        });
    }

    private <T> T sync(final Class<T> remoteInterface, RemoteInvocationOptions options) {
        final RemoteInvocationOptions optionsCopy = new RemoteInvocationOptions(options);
        final String toString = this.getClass().getSimpleName() + "-" + remoteInterface.getSimpleName() + "-proxy-" + this.generateRequestId();
        InvocationHandler handler = new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (method.getName().equals("toString")) {
                    return toString;
                }
                if (method.getName().equals("equals")) {
                    return proxy == args[0];
                }
                if (method.getName().equals("hashCode")) {
                    return toString.hashCode();
                }
                if (!(optionsCopy.isResultExpected() || method.getReturnType().equals(Void.class) || method.getReturnType().equals(Void.TYPE))) {
                    throw new IllegalArgumentException("The noResult option only supports void return value");
                }
                RequestId requestId = BaseRemoteService.this.generateRequestId();
                String requestQueueName = BaseRemoteService.this.getRequestQueueName(remoteInterface);
                RemotePromise<Object> addPromise = new RemotePromise<Object>(requestId);
                RemoteServiceRequest request = new RemoteServiceRequest(BaseRemoteService.this.executorId, requestId.toString(), method.getName(), BaseRemoteService.this.getMethodSignatures(method), args, optionsCopy, System.currentTimeMillis());
                RPromise ackFuture = optionsCopy.isAckExpected() ? BaseRemoteService.this.poll(optionsCopy.getAckTimeoutInMillis(), requestId, false) : null;
                RPromise responseFuture = optionsCopy.isResultExpected() ? BaseRemoteService.this.poll(optionsCopy.getExecutionTimeoutInMillis(), requestId, false) : null;
                RFuture<Boolean> futureAdd = BaseRemoteService.this.addAsync(requestQueueName, request, addPromise);
                futureAdd.await();
                if (!futureAdd.isSuccess()) {
                    if (responseFuture != null) {
                        responseFuture.cancel(false);
                    }
                    if (ackFuture != null) {
                        ackFuture.cancel(false);
                    }
                    throw futureAdd.cause();
                }
                if (!((Boolean)futureAdd.get()).booleanValue()) {
                    if (responseFuture != null) {
                        responseFuture.cancel(false);
                    }
                    if (ackFuture != null) {
                        ackFuture.cancel(false);
                    }
                    throw new RedisException("Task hasn't been added");
                }
                if (ackFuture != null) {
                    String ackName = BaseRemoteService.this.getAckName(requestId);
                    ackFuture.await();
                    RemoteServiceAck ack = (RemoteServiceAck)ackFuture.getNow();
                    if (ack == null) {
                        RFuture ackFutureAttempt = BaseRemoteService.this.tryPollAckAgainAsync(optionsCopy, ackName, requestId);
                        ackFutureAttempt.await();
                        ack = (RemoteServiceAck)ackFutureAttempt.getNow();
                        if (ack == null) {
                            throw new RemoteServiceAckTimeoutException("No ACK response after " + optionsCopy.getAckTimeoutInMillis() + "ms for request: " + request);
                        }
                    }
                    BaseRemoteService.this.redisson.getBucket(ackName).delete();
                }
                if (responseFuture != null) {
                    responseFuture.awaitUninterruptibly();
                    RemoteServiceResponse response = (RemoteServiceResponse)responseFuture.getNow();
                    if (response == null) {
                        throw new RemoteServiceTimeoutException("No response after " + optionsCopy.getExecutionTimeoutInMillis() + "ms for request: " + request);
                    }
                    if (response.getError() != null) {
                        throw response.getError();
                    }
                    return response.getResult();
                }
                return null;
            }
        };
        return (T)Proxy.newProxyInstance(remoteInterface.getClassLoader(), new Class[]{remoteInterface}, handler);
    }

    private RFuture<RemoteServiceAck> tryPollAckAgainAsync(RemoteInvocationOptions optionsCopy, String ackName, final RequestId requestId) {
        final RedissonPromise<RemoteServiceAck> promise = new RedissonPromise<RemoteServiceAck>();
        RFuture ackClientsFuture = this.commandExecutor.evalWriteAsync(ackName, (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "if redis.call('setnx', KEYS[1], 1) == 1 then redis.call('pexpire', KEYS[1], ARGV[1]);return 0;end;redis.call('del', KEYS[1]);return 1;", Arrays.asList(ackName), optionsCopy.getAckTimeoutInMillis());
        ackClientsFuture.addListener(new FutureListener<Boolean>(){

            @Override
            public void operationComplete(Future<Boolean> future) throws Exception {
                if (!future.isSuccess()) {
                    promise.tryFailure(future.cause());
                    return;
                }
                if (future.getNow().booleanValue()) {
                    RPromise ackFuture = BaseRemoteService.this.poll(BaseRemoteService.this.commandExecutor.getConnectionManager().getConfig().getTimeout(), requestId, true);
                    ackFuture.addListener(new FutureListener<RemoteServiceAck>(){

                        @Override
                        public void operationComplete(Future<RemoteServiceAck> future) throws Exception {
                            if (!future.isSuccess()) {
                                promise.tryFailure(future.cause());
                                return;
                            }
                            promise.trySuccess(future.getNow());
                        }
                    });
                } else {
                    promise.trySuccess(null);
                }
            }
        });
        return promise;
    }

    protected <T> void scheduleCheck(final String mapName, final RequestId requestId, final RPromise<T> cancelRequest) {
        this.commandExecutor.getConnectionManager().newTimeout(new TimerTask(){

            @Override
            public void run(Timeout timeout) throws Exception {
                if (cancelRequest.isDone()) {
                    return;
                }
                RMap canceledRequests = BaseRemoteService.this.redisson.getMap(mapName, new CompositeCodec(StringCodec.INSTANCE, BaseRemoteService.this.codec, BaseRemoteService.this.codec));
                RFuture future = canceledRequests.removeAsync(requestId.toString());
                future.addListener(new FutureListener<T>(){

                    @Override
                    public void operationComplete(Future<T> future) throws Exception {
                        if (cancelRequest.isDone()) {
                            return;
                        }
                        if (!future.isSuccess()) {
                            BaseRemoteService.this.scheduleCheck(mapName, requestId, cancelRequest);
                            return;
                        }
                        Object request = future.getNow();
                        if (request == null) {
                            BaseRemoteService.this.scheduleCheck(mapName, requestId, cancelRequest);
                        } else {
                            cancelRequest.trySuccess(request);
                        }
                    }
                });
            }
        }, 3000L, TimeUnit.MILLISECONDS);
    }

    protected RequestId generateRequestId() {
        byte[] id = new byte[17];
        PlatformDependent.threadLocalRandom().nextBytes(id);
        id[0] = 0;
        return new RequestId(id);
    }

    protected abstract RFuture<Boolean> addAsync(String var1, RemoteServiceRequest var2, RemotePromise<Object> var3);

    protected abstract RFuture<Boolean> removeAsync(String var1, RequestId var2);

    private void cancelExecution(RemoteInvocationOptions optionsCopy, boolean mayInterruptIfRunning, RemotePromise<Object> remotePromise) {
        RMap<String, RemoteServiceCancelRequest> canceledRequests = this.redisson.getMap(this.cancelRequestMapName, new CompositeCodec(StringCodec.INSTANCE, this.codec, this.codec));
        canceledRequests.putAsync(remotePromise.getRequestId().toString(), new RemoteServiceCancelRequest(mayInterruptIfRunning, false));
        canceledRequests.expireAsync(60L, TimeUnit.SECONDS);
        if (!optionsCopy.isResultExpected()) {
            RemoteInvocationOptions options = new RemoteInvocationOptions(optionsCopy);
            options.expectResultWithin(60L, TimeUnit.SECONDS);
            RPromise<RRemoteServiceResponse> responseFuture = this.poll(options.getExecutionTimeoutInMillis(), remotePromise.getRequestId(), false);
            this.awaitResultAsync(options, remotePromise, responseFuture);
        }
    }

    protected List<String> getMethodSignatures(Method method) {
        List<String> result = (ArrayList<String>)this.methodSignaturesCache.get(method);
        if (result == null) {
            result = new ArrayList<String>(method.getParameterTypes().length);
            for (Class<?> t : method.getParameterTypes()) {
                result.add(t.getName());
            }
            List oldList = this.methodSignaturesCache.putIfAbsent(method, result);
            if (oldList != null) {
                result = oldList;
            }
        }
        return result;
    }
}

