/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Collection;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import reactor.core.CoreSubscriber;
import reactor.core.Fuseable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxDistinct;
import reactor.core.publisher.FluxOperator;
import reactor.core.publisher.Operators;

final class FluxDistinctFuseable<T, K, C extends Collection<? super K>>
extends FluxOperator<T, T>
implements Fuseable {
    final Function<? super T, ? extends K> keyExtractor;
    final Supplier<C> collectionSupplier;

    FluxDistinctFuseable(Flux<? extends T> source, Function<? super T, ? extends K> keyExtractor, Supplier<C> collectionSupplier) {
        super(source);
        this.keyExtractor = Objects.requireNonNull(keyExtractor, "keyExtractor");
        this.collectionSupplier = Objects.requireNonNull(collectionSupplier, "collectionSupplier");
    }

    @Override
    public void subscribe(CoreSubscriber<? super T> actual) {
        Collection collection;
        try {
            collection = (Collection)Objects.requireNonNull(this.collectionSupplier.get(), "The collectionSupplier returned a null collection");
        }
        catch (Throwable e) {
            Operators.error(actual, Operators.onOperatorError(e, actual.currentContext()));
            return;
        }
        this.source.subscribe(new FluxDistinct.DistinctFuseableSubscriber<T, K, Collection>(actual, collection, this.keyExtractor));
    }
}

